/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.part;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.objectstyle.wolips.componenteditor.ComponenteditorPlugin;
import org.objectstyle.wolips.componenteditor.part.ComponentEditorPart;
import org.objectstyle.wolips.componenteditor.part.ComponentEditorTab;
import org.objectstyle.wolips.components.input.ComponentEditorFileEditorInput;
import org.objectstyle.wolips.templateeditor.TemplateEditor;
import org.objectstyle.wolips.wodclipse.WodclipsePlugin;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.editor.WodEditor;

public class HtmlWodTab
extends ComponentEditorTab {
    private static final String SASH_WEIGHTS_KEY = "org.objectstyle.wolips.componenteditor.sashWeights";
    private TemplateEditor templateEditor;
    private WodEditor wodEditor;
    private boolean htmlActive;
    private IEditorInput htmlInput;
    private IEditorInput wodInput;
    private Composite _templateContainer;
    private Composite _wodContainer;
    private Label nonEmptyWodWarning;

    public HtmlWodTab(ComponentEditorPart componentEditorPart, int tabIndex, IEditorInput htmlInput, IEditorInput wodInput) {
        super(componentEditorPart, tabIndex);
        this.htmlInput = htmlInput;
        this.wodInput = wodInput;
    }

    @Override
    public IEditorPart getActiveEmbeddedEditor() {
        if (this.htmlActive) {
            return this.templateEditor;
        }
        return this.wodEditor;
    }

    public void createTab() {
        this.templateEditor = new TemplateEditor();
        IEditorSite htmlSite = this.getComponentEditorPart().publicCreateSite((IEditorPart)this.templateEditor);
        try {
            this.templateEditor.init(htmlSite, this.htmlInput);
        }
        catch (PartInitException e) {
            ComponenteditorPlugin.getDefault().log(e);
        }
        this._templateContainer = this.createInnerPartControl((Composite)this.getParentSashForm(), (IEditorPart)this.templateEditor);
        this.templateEditor.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propertyId) {
                HtmlWodTab.this.getComponentEditorPart().publicHandlePropertyChange(propertyId);
            }
        });
        if (this.wodInput != null && ((ComponentEditorFileEditorInput)this.wodInput).getFile().exists()) {
            this.wodEditor = new WodEditor();
            IEditorSite wodSite = this.getComponentEditorPart().publicCreateSite((IEditorPart)this.wodEditor);
            try {
                this.wodEditor.init(wodSite, this.wodInput);
            }
            catch (PartInitException e) {
                ComponenteditorPlugin.getDefault().log(e);
            }
            this._wodContainer = this.createInnerPartControl((Composite)this.getParentSashForm(), (IEditorPart)this.wodEditor);
            this._wodContainer.setBackground(this._wodContainer.getDisplay().getSystemColor(1));
            this.wodEditor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propertyId) {
                    HtmlWodTab.this.getComponentEditorPart().publicHandlePropertyChange(propertyId);
                }
            });
            this.wodEditor.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    WodclipsePlugin.getDefault().updateWebObjectsTagNames(null);
                }
            });
            WodclipsePlugin.getDefault().updateWebObjectsTagNames(this.wodEditor);
            this._templateContainer.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    HtmlWodTab.this.setHtmlActive(true);
                    HtmlWodTab.this.getComponentEditorPart().pageChange(HtmlWodTab.this.getTabIndex());
                    HtmlWodTab.this.getComponentEditorPart().updateOutline();
                }
            });
            this._wodContainer.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    HtmlWodTab.this.setHtmlActive(false);
                    HtmlWodTab.this.getComponentEditorPart().pageChange(HtmlWodTab.this.getTabIndex());
                    HtmlWodTab.this.getComponentEditorPart().updateOutline();
                }
            });
        }
        this.restoreSashWeights();
        this.hideWodIfNecessary();
        this._templateContainer.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                HtmlWodTab.this.saveSashWeights();
                HtmlWodTab.this.hideWodIfNecessary();
            }
        });
        this.templateEditor.initEditorInteraction(this.getComponentEditorPart().getEditorInteraction());
        if (this.wodEditor != null) {
            this.wodEditor.initEditorInteraction(this.getComponentEditorPart().getEditorInteraction());
        }
        this.addWebObjectsTagNamesListener();
    }

    public boolean isHtmlActive() {
        return this.htmlActive;
    }

    protected void setHtmlActive(boolean htmlActive) {
        this.htmlActive = htmlActive;
    }

    protected void hideWodIfNecessary() {
        if (this._wodContainer == null) {
            int[] weights = new int[]{100};
            this.getParentSashForm().setWeights(weights);
            return;
        }
        int[] weights = this.getParentSashForm().getWeights();
        if (weights.length >= 2 && weights[1] < 132) {
            if (this.nonEmptyWodWarning == null) {
                this._wodContainer.getChildren()[0].setVisible(false);
                this.nonEmptyWodWarning = new Label(this._wodContainer, 0x1000000);
                this.nonEmptyWodWarning.setBackground(this._wodContainer.getBackground());
                this.nonEmptyWodWarning.setForeground(this._wodContainer.getDisplay().getSystemColor(15));
                if (this.wodEditor.getWodEditDocument().getLength() > 0) {
                    this.nonEmptyWodWarning.setText("wod file is not empty");
                } else {
                    this.nonEmptyWodWarning.setText("");
                }
                this.nonEmptyWodWarning.moveAbove(this._wodContainer.getChildren()[0]);
                if (!this.isHtmlActive()) {
                    this._templateContainer.forceFocus();
                }
            }
        } else if (this.nonEmptyWodWarning != null) {
            this.nonEmptyWodWarning.dispose();
            this.nonEmptyWodWarning = null;
            this._wodContainer.getChildren()[0].setVisible(true);
        }
    }

    protected void restoreSashWeights() {
        String sashWeightsStr = Activator.getDefault().getPluginPreferences().getString(SASH_WEIGHTS_KEY);
        if (sashWeightsStr != null && sashWeightsStr.length() > 0) {
            String[] sashWeightStrs = sashWeightsStr.split(",");
            int[] sashWeights = new int[sashWeightStrs.length];
            for (int sashWeightNum = 0; sashWeightNum < sashWeightStrs.length; ++sashWeightNum) {
                sashWeights[sashWeightNum] = Integer.parseInt(sashWeightStrs[sashWeightNum]);
            }
            if (sashWeights.length == this.getParentSashForm().getWeights().length) {
                if ((double)((float)sashWeights[1] / (float)sashWeights[0]) < 0.15) {
                    sashWeights[0] = 85;
                    sashWeights[1] = 15;
                }
                this.getParentSashForm().setWeights(sashWeights);
            }
        }
    }

    protected void saveSashWeights() {
        int[] weights = this.getParentSashForm().getWeights();
        StringBuffer weightsBuffer = new StringBuffer();
        for (int weight : weights) {
            weightsBuffer.append(weight);
            weightsBuffer.append(",");
        }
        if (weightsBuffer.length() > 0) {
            weightsBuffer.setLength(weightsBuffer.length() - 1);
        }
        Activator.getDefault().getPluginPreferences().setValue(SASH_WEIGHTS_KEY, weightsBuffer.toString());
    }

    public TemplateEditor templateEditor() {
        return this.templateEditor;
    }

    public WodEditor wodEditor() {
        return this.wodEditor;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (this.wodEditor != null && this.wodEditor.isDirty()) {
            this.wodEditor.doSave(monitor);
        }
        if (this.templateEditor.isDirty()) {
            this.templateEditor.doSave(monitor);
        }
    }

    @Override
    public void close(boolean save) {
        if (this.wodEditor != null) {
            this.wodEditor.close(save);
        }
    }

    @Override
    public void dispose() {
        if (this.wodEditor != null) {
            this.wodEditor.dispose();
        }
        this.templateEditor.dispose();
        super.dispose();
    }

    @Override
    public boolean isDirty() {
        return this.wodEditor != null && this.wodEditor.isDirty() || this.templateEditor.isDirty();
    }

    private void addWebObjectsTagNamesListener() {
        if (this.wodEditor == null) {
            return;
        }
        final WodEditor finalWodEditor = this.wodEditor;
        this.wodEditor.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WodclipsePlugin.getDefault().updateWebObjectsTagNames(finalWodEditor);
            }
        });
        WodclipsePlugin.getDefault().updateWebObjectsTagNames(this.wodEditor);
    }

    public void setHtmlActive() {
        this.setHtmlActive(true);
    }

    public void setWodActive() {
        this.setHtmlActive(false);
    }

    @Override
    public IEditorInput getActiveEditorInput() {
        if (this.htmlActive) {
            return this.htmlInput;
        }
        return this.wodInput;
    }
}

