/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.types.folder;

import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.baseforplugins.util.FileUtilities;
import org.objectstyle.wolips.core.CorePlugin;
import org.objectstyle.wolips.core.resources.internal.types.folder.AbstractFolderAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IBuildAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotApplicationAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotFrameworkAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IProductAdapter;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;

public class BuildAdapter
extends AbstractFolderAdapter
implements IBuildAdapter {
    public BuildAdapter(IFolder folder) {
        super(folder);
    }

    @Override
    public IDotApplicationAdapter getDotApplicationAdapter() {
        IFolder resource = this.getUnderlyingFolder().getFolder(this.getUnderlyingResource().getProject().getName() + ".woa");
        return (IDotApplicationAdapter)resource.getAdapter(IDotApplicationAdapter.class);
    }

    @Override
    public IDotFrameworkAdapter getDotFrameworkAdapter() {
        IFolder resource = this.getUnderlyingFolder().getFolder(this.getUnderlyingResource().getProject().getName() + ".framework");
        return (IDotFrameworkAdapter)resource.getAdapter(IDotFrameworkAdapter.class);
    }

    @Override
    public IProductAdapter getProductAdapter() {
        IProject project = this.getUnderlyingResource().getProject();
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        if (projectAdapter.isFramework()) {
            return this.getDotFrameworkAdapter();
        }
        return this.getDotApplicationAdapter();
    }

    @Override
    public void clean(IProgressMonitor monitor) {
        IFolder underlyingFolder = this.getUnderlyingFolder();
        if (!underlyingFolder.exists()) {
            return;
        }
        File underlyingFile = underlyingFolder.getLocation().toFile();
        if (underlyingFile.exists()) {
            FileUtilities.deleteRecursively((File)underlyingFile);
            try {
                underlyingFolder.refreshLocal(1, monitor);
            }
            catch (CoreException e) {
                CorePlugin.getDefault().log(e);
            }
        } else {
            try {
                this.getUnderlyingFolder().delete(true, monitor);
            }
            catch (CoreException e) {
                CorePlugin.getDefault().log(e);
            }
        }
    }
}

