/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eogenerator.ui.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.eogenerator.core.model.EOGeneratorModel;
import org.objectstyle.wolips.eogenerator.ui.editors.EOGeneratorFormPage;

public class EOGeneratorEditor
extends FormEditor {
    private EOGeneratorModel myModel;
    private EOGeneratorFormPage myFormPage;
    private boolean myModelGroupEditor;

    protected void setInput(IEditorInput _input) {
        super.setInput(_input);
        try {
            FileEditorInput editorInput = (FileEditorInput)_input;
            IFile eogenFile = editorInput.getFile();
            this.myModel = EOGeneratorModel.createModelFromFile((IFile)eogenFile);
            this.myModelGroupEditor = "eomodelgroup".equals(eogenFile.getFileExtension());
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to read EOGen file.", e);
        }
    }

    protected void addPages() {
        try {
            this.myFormPage = new EOGeneratorFormPage(this, this.myModel, this.myModelGroupEditor);
            this.addPage((IFormPage)this.myFormPage);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating form pages.", null, (IStatus)e.getStatus());
        }
    }

    public void doSave(IProgressMonitor _monitor) {
        try {
            FileEditorInput editorInput = (FileEditorInput)this.getEditorInput();
            editorInput.getFile().deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            this.myModel.writeToFile(editorInput.getFile(), _monitor);
            this.editorDirtyStateChanged();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to write EOGen file.", e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        return this.myModel.isDirty() || super.isDirty();
    }
}

