/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforuiplugins;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.objectstyle.wolips.baseforuiplugins.IEditorTarget;
import org.osgi.framework.BundleContext;

public abstract class AbstractBaseUIActivator
extends AbstractUIPlugin {
    private ResourceBundle resourceBundle;
    private static AbstractBaseUIActivator Plugin;
    private boolean debug = true;
    private String bundleID;

    public AbstractBaseUIActivator() {
        Plugin = this;
    }

    public final String getBundleID() {
        if (this.bundleID == null) {
            this.bundleID = ((Object)((Object)this)).getClass().getName() + "Resources";
        }
        return this.bundleID;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.resourceBundle = null;
    }

    public static final String getResourceString(String key) {
        ResourceBundle bundle = Plugin.getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public final ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle(this.getBundleID());
            }
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(Object message) {
        this.log((IStatus)new Status(4, this.getBundleID(), 4, "" + message, null));
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, this.getBundleID(), 4, "Internal Error", e));
    }

    public void log(Object message, Throwable e) {
        this.log((IStatus)new Status(4, this.getBundleID(), 4, "" + message, e));
    }

    public void debug(Throwable aThrowable) {
        if (this.debug) {
            this.log((IStatus)new Status(2, this.getBundleID(), 2, aThrowable.getMessage(), aThrowable));
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.debug) {
            this.log((IStatus)new Status(2, this.getBundleID(), 2, "" + message, t));
        }
    }

    public void debug(Object message) {
        if (this.debug) {
            this.log((IStatus)new Status(2, this.getBundleID(), 2, "" + message, null));
        }
    }

    public void publicSaveDialogSettings() {
        this.saveDialogSettings();
    }

    public final void selectAndReveal(IFile file) {
        this.selectAndReveal(file, null, -1);
    }

    public final void selectAndReveal(final IFile file, final String string, final int targetEditorID) {
        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        for (int i = 0; i < workbenchWindows.length; ++i) {
            final IWorkbenchPage workbenchPage = workbenchWindows[i].getActivePage();
            if (workbenchPage == null) continue;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractBaseUIActivator.this.runSelectAndReveal(workbenchPage, file, string, targetEditorID);
                }
            });
        }
    }

    protected void runSelectAndReveal(IWorkbenchPage workbenchPage, IFile file, String string, int targetEditorID) {
        try {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)file, (boolean)true);
            if (string != null && string.length() > 0 && editorPart != null && editorPart instanceof ITextEditor) {
                ITextEditor textEditor;
                IDocumentProvider documentProvider;
                IDocument document;
                int offset;
                if (editorPart instanceof IEditorTarget) {
                    IEditorTarget editorTarget = (IEditorTarget)editorPart;
                    editorPart = editorTarget.switchTo(targetEditorID);
                }
                if ((offset = (document = (documentProvider = (textEditor = (ITextEditor)editorPart).getDocumentProvider()).getDocument((Object)textEditor.getEditorInput())).search(0, string, true, true, false)) >= 0) {
                    textEditor.selectAndReveal(offset, string.length());
                }
            }
        }
        catch (BadLocationException e) {
            this.log(e);
        }
        catch (PartInitException e) {
            this.log(e);
        }
    }
}

