/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforuiplugins.plist;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.baseforuiplugins.plist.IPropertyListChangeListener;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListContentProvider;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListKeyEditingSupport;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListKeyLabelProvider;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListPath;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListTypeEditingSupport;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListTypeLabelProvider;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListValueEditingSupport;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListValueLabelProvider;
import org.objectstyle.wolips.baseforuiplugins.plist.StableDataStructureFactory;
import org.objectstyle.wolips.baseforuiplugins.utils.WOTreeCellNavigationStrategy;

public class PropertyListEditor
extends Viewer
implements IPropertyListChangeListener,
KeyListener {
    private IPropertyListChangeListener _listener;
    private ParserDataStructureFactory _parserDataStructureFactory;
    private TreeViewer _propertyListTree;

    public PropertyListEditor(Composite parent, boolean rootVisible, boolean canEditRootType, Set<String> filteredKeyPaths) {
        this._propertyListTree = new TreeViewer(parent, 68124);
        this._propertyListTree.getTree().setHeaderVisible(true);
        this._propertyListTree.getTree().setLinesVisible(true);
        this._propertyListTree.setAutoExpandLevel(2);
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager(this._propertyListTree, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this._propertyListTree), (CellNavigationStrategy)new WOTreeCellNavigationStrategy());
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this._propertyListTree){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = (ViewerCell)event.getSource();
                boolean isEditorActivationEvent = cell.getColumnIndex() == 1 ? event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 32 || event.eventType == 4 : event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 32 || event.eventType == 4;
                return isEditorActivationEvent;
            }
        };
        TreeViewerEditor.create((TreeViewer)this._propertyListTree, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)122);
        TreeViewerColumn keyColumn = new TreeViewerColumn(this._propertyListTree, 0);
        keyColumn.getColumn().setWidth(120);
        keyColumn.getColumn().setText("Key");
        keyColumn.setLabelProvider((CellLabelProvider)new PropertyListKeyLabelProvider());
        keyColumn.setEditingSupport((EditingSupport)new PropertyListKeyEditingSupport(this._propertyListTree, this));
        TreeViewerColumn typeColumn = new TreeViewerColumn(this._propertyListTree, 0);
        typeColumn.getColumn().setWidth(75);
        typeColumn.getColumn().setText("Type");
        typeColumn.setLabelProvider((CellLabelProvider)new PropertyListTypeLabelProvider());
        typeColumn.setEditingSupport((EditingSupport)new PropertyListTypeEditingSupport(this._propertyListTree, this, canEditRootType));
        TreeViewerColumn valueColumn = new TreeViewerColumn(this._propertyListTree, 0);
        valueColumn.getColumn().setWidth(250);
        valueColumn.getColumn().setText("Value");
        valueColumn.setLabelProvider((CellLabelProvider)new PropertyListValueLabelProvider());
        valueColumn.setEditingSupport((EditingSupport)new PropertyListValueEditingSupport(this._propertyListTree, this));
        this._propertyListTree.getTree().addKeyListener((KeyListener)this);
        this._parserDataStructureFactory = new StableDataStructureFactory();
        this._propertyListTree.setContentProvider((IContentProvider)new PropertyListContentProvider(this._parserDataStructureFactory, rootVisible, filteredKeyPaths));
    }

    public void setListener(IPropertyListChangeListener listener) {
        this._listener = listener;
    }

    public IPropertyListChangeListener getListener() {
        return this._listener;
    }

    public Control getControl() {
        return this._propertyListTree.getTree();
    }

    public Object getInput() {
        try {
            return WOLPropertyListSerialization.propertyListFromString((String)WOLPropertyListSerialization.stringFromPropertyList((Object)this._propertyListTree.getInput()), (ParserDataStructureFactory)new StableDataStructureFactory());
        }
        catch (PropertyListParserException e) {
            throw new IllegalArgumentException("Failed to parse property list.", e);
        }
    }

    public ISelection getSelection() {
        return this._propertyListTree.getSelection();
    }

    public void refresh() {
        this._propertyListTree.refresh();
    }

    public void setInput(Object input) {
        try {
            this._propertyListTree.setInput(WOLPropertyListSerialization.propertyListFromString((String)WOLPropertyListSerialization.stringFromPropertyList((Object)input), (ParserDataStructureFactory)new StableDataStructureFactory()));
        }
        catch (PropertyListParserException e) {
            throw new IllegalArgumentException("Failed to parse property list.", e);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this._propertyListTree.setSelection(selection);
    }

    @Override
    public void pathRenamed(String oldPath, String newPath) {
        if (this._listener != null) {
            this._listener.pathRenamed(oldPath, newPath);
        }
    }

    @Override
    public void pathChanged(String path, Object oldValue, Object newValue) {
        if (this._listener != null) {
            this._listener.pathChanged(path, oldValue, newValue);
        }
    }

    @Override
    public void pathAdded(String path, Object value) {
        if (this._listener != null) {
            this._listener.pathAdded(path, value);
        }
    }

    @Override
    public void pathRemoved(String path, Object value) {
        if (this._listener != null) {
            this._listener.pathRemoved(path, value);
        }
    }

    public void addRow() {
        PropertyListPath selectedPath = (PropertyListPath)((IStructuredSelection)this._propertyListTree.getSelection()).getFirstElement();
        PropertyListPath parentPath = selectedPath.isCollectionValue() ? (this._propertyListTree.getExpandedState((Object)selectedPath) || selectedPath.getParent() == null ? selectedPath : selectedPath.getParent()) : selectedPath.getParent();
        PropertyListPath newChild = parentPath.addRow();
        this._propertyListTree.refresh((Object)parentPath);
        this._propertyListTree.setSelection((ISelection)new StructuredSelection((Object)newChild), true);
        if (this._listener != null) {
            this._listener.pathAdded(newChild.getKeyPath(), newChild.getValue());
        }
        this._propertyListTree.editElement((Object)newChild, 0);
    }

    public void deleteRow() {
        PropertyListPath selectedPath = (PropertyListPath)((IStructuredSelection)this._propertyListTree.getSelection()).getFirstElement();
        String keyPath = selectedPath.getKeyPath();
        PropertyListPath parentPath = selectedPath.getParent();
        int index = parentPath.getIndexOf(selectedPath);
        if (selectedPath.delete()) {
            List<PropertyListPath> children;
            this._propertyListTree.refresh((Object)parentPath);
            if (this._listener != null) {
                this._listener.pathRemoved(keyPath, selectedPath.getValue());
            }
            if ((children = parentPath.getChildren()).size() == 0) {
                this._propertyListTree.setSelection((ISelection)new StructuredSelection((Object)parentPath), true);
            } else if (index == children.size()) {
                this._propertyListTree.setSelection((ISelection)new StructuredSelection((Object)parentPath.getChildAtIndex(index - 1)), true);
            } else {
                this._propertyListTree.setSelection((ISelection)new StructuredSelection((Object)parentPath.getChildAtIndex(index)), true);
            }
        }
    }

    public void moveRowUp() {
        PropertyListPath selectedPath = (PropertyListPath)((IStructuredSelection)this._propertyListTree.getSelection()).getFirstElement();
        PropertyListPath parentPath = selectedPath.getParent();
        int index = parentPath.getIndexOf(selectedPath);
        if (selectedPath.moveUp()) {
            this._propertyListTree.refresh((Object)parentPath);
            if (this._listener != null) {
                this._listener.pathChanged(parentPath.getKeyPath(), null, null);
            }
            this._propertyListTree.setSelection((ISelection)new StructuredSelection((Object)parentPath.getChildAtIndex(index - 1)), true);
        }
    }

    public void moveRowDown() {
        PropertyListPath selectedPath = (PropertyListPath)((IStructuredSelection)this._propertyListTree.getSelection()).getFirstElement();
        PropertyListPath parentPath = selectedPath.getParent();
        int index = parentPath.getIndexOf(selectedPath);
        if (selectedPath.moveDown()) {
            this._propertyListTree.refresh((Object)parentPath);
            if (this._listener != null) {
                this._listener.pathChanged(parentPath.getKeyPath(), null, null);
            }
            this._propertyListTree.setSelection((ISelection)new StructuredSelection((Object)parentPath.getChildAtIndex(index + 1)), true);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (!this._propertyListTree.isCellEditorActive()) {
            if (e.keyCode == 13) {
                this.addRow();
            } else if (e.keyCode == 127) {
                this.deleteRow();
            } else if (e.keyCode == 0x1000001 && (e.stateMask & 0x400000) != 0) {
                this.moveRowUp();
                e.doit = false;
            } else if (e.keyCode == 0x1000002 && (e.stateMask & 0x400000) != 0) {
                this.moveRowDown();
                e.doit = false;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

