/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforuiplugins.utils;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.objectstyle.wolips.baseforuiplugins.utils.IHateCCombo;

public class KeyComboBoxCellEditor
extends CellEditor {
    private String[] items;
    int selection;
    IHateCCombo comboBox;
    private static final int defaultStyle = 0;
    private long lastKeyTime;
    private StringBuffer searchStringBuffer;
    private boolean _moving;
    private boolean _resizing;

    public KeyComboBoxCellEditor() {
        this.setStyle(0x800000);
        this.searchStringBuffer = new StringBuffer();
    }

    public KeyComboBoxCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public KeyComboBoxCellEditor(Composite parent, String[] items, int style) {
        super(parent, style);
        this.setItems(items);
        this.searchStringBuffer = new StringBuffer();
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    public IHateCCombo getComboBox() {
        return this.comboBox;
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new IHateCCombo(parent, this.getStyle());
        this.comboBox.setBackground(parent.getBackground());
        this.comboBox.setFont(parent.getFont());
        if ("carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform())) {
            this.comboBox.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    if (!KeyComboBoxCellEditor.this._moving) {
                        KeyComboBoxCellEditor.this._moving = true;
                        Point location = KeyComboBoxCellEditor.this.comboBox.getLocation();
                        if (System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null) {
                            KeyComboBoxCellEditor.this.comboBox.setLocation(location.x - 3, location.y - 1);
                        } else {
                            KeyComboBoxCellEditor.this.comboBox.setLocation(location.x - 3, location.y - 2);
                        }
                        KeyComboBoxCellEditor.this._moving = false;
                    }
                }

                public void controlResized(ControlEvent e) {
                    if (!KeyComboBoxCellEditor.this._resizing) {
                        KeyComboBoxCellEditor.this._resizing = true;
                        Point size = KeyComboBoxCellEditor.this.comboBox.getSize();
                        if (System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null) {
                            KeyComboBoxCellEditor.this.comboBox.setSize(size.x + 3, size.y + 2);
                        } else {
                            KeyComboBoxCellEditor.this.comboBox.setSize(size.x + 3, size.y + 3);
                        }
                        if (!KeyComboBoxCellEditor.this.isActivated() || !KeyComboBoxCellEditor.this.comboBox.getEditable()) {
                            // empty if block
                        }
                        KeyComboBoxCellEditor.this._resizing = false;
                    }
                }
            });
        }
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                KeyComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                KeyComboBoxCellEditor.this.applyEditorValue(false);
            }

            public void widgetSelected(SelectionEvent event) {
                KeyComboBoxCellEditor.this.selection = KeyComboBoxCellEditor.this.comboBox.getSelectionIndex();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                KeyComboBoxCellEditor.this.focusLost();
            }
        });
        return this.comboBox;
    }

    protected Object doGetValue() {
        return this.selection;
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = new CellEditor.LayoutData();
        return layoutData;
    }

    protected void doSetValue(Object value) {
        if (value == null) {
            this.comboBox.select(-1);
        } else {
            this.selection = (Integer)value;
            this.comboBox.select(this.selection);
        }
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            for (int i = 0; i < this.items.length; ++i) {
                this.comboBox.add(this.items[i], i);
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    public void activate() {
        super.activate();
    }

    void applyEditorValue(boolean deactivate) {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            if (this.items.length > 0 && this.selection >= 0 && this.selection < this.items.length) {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.items[this.selection]));
            } else {
                this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.comboBox.getText()));
            }
        }
        this.fireApplyEditorValue();
        this.comboBox.dropDown(false);
        if (deactivate) {
            this.deactivate();
        }
    }

    public void deactivate() {
        super.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValue(true);
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValue(true);
        } else if (keyEvent.keyCode == 0x1000002) {
            this.comboBox.dropDown(true);
        } else if (Character.isLetterOrDigit(keyEvent.character)) {
            long now = System.currentTimeMillis();
            if (now - this.lastKeyTime > 1000L) {
                this.lastKeyTime = now;
                this.searchStringBuffer.setLength(0);
            }
            this.searchStringBuffer.append(Character.toLowerCase(keyEvent.character));
            int matchingIndex = -1;
            String searchString = this.searchStringBuffer.toString();
            for (int itemNum = 0; matchingIndex == -1 && itemNum < this.items.length; ++itemNum) {
                if (!this.items[itemNum].toLowerCase().startsWith(searchString)) continue;
                matchingIndex = itemNum;
            }
            if (matchingIndex != -1) {
                this.comboBox.select(matchingIndex);
                this.selection = matchingIndex;
            } else {
                this.comboBox.clearSelection();
                this.selection = 0;
                this.comboBox.select(-1);
            }
        }
    }
}

