/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import org.neo4j.jmx.Description;
import org.neo4j.jmx.ManagementInterface;
import org.neo4j.management.InstanceInfo;
import org.neo4j.management.SlaveInfo;

@ManagementInterface(name="High Availability")
@Description(value="Information about an instance participating in a HA cluster")
public interface HighAvailability {
    public static final String NAME = "High Availability";

    @Description(value="The identifier used to identify this machine in the HA cluster")
    public String getMachineId();

    @Description(value="Whether this instance is master or not")
    public boolean isMaster();

    @Description(value="The time when the data on this instance was last updated from the master")
    public String getLastUpdateTime();

    @Description(value="(If this is a master) Information about the instances connected to this instance")
    public SlaveInfo[] getConnectedSlaves();

    @Description(value="Information about all instances in this cluster")
    public InstanceInfo[] getInstancesInCluster();

    @Description(value="(If this is a slave) Update the database on this instance with the latest transactions from the master")
    public String update();
}

