/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Map;
import org.neo4j.management.InstanceInfo;

public final class SlaveInfo
extends InstanceInfo {
    private static final long serialVersionUID = 1L;
    private final SlaveTransaction[] txInfo;

    @ConstructorProperties(value={"address", "instanceId", "machineId", "master", "lastCommittedTransactionId", "txInfo"})
    public SlaveInfo(String address, String instanceId, int machineId, boolean master, long lastTxId, SlaveTransaction ... txInfo) {
        super(address, instanceId, machineId, master, lastTxId);
        this.txInfo = txInfo;
    }

    public SlaveTransaction[] getTxInfo() {
        return this.txInfo;
    }

    public static final class SlaveTransaction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int eventId;
        private final Map<String, Long> lastTransactions;

        @ConstructorProperties(value={"eventIdentifier", "lastTransaction"})
        public SlaveTransaction(int eventId, Map<String, Long> lastTransactions) {
            this.eventId = eventId;
            this.lastTransactions = lastTransactions;
        }

        public int getEventIdentifier() {
            return this.eventId;
        }

        public long getLastTransaction(String resource) {
            return this.lastTransactions.get(resource);
        }
    }
}

