/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.util.LinkedList;
import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.management.Cache;

public class CacheBean
extends ManagementBeanProvider {
    public CacheBean() {
        super(Cache.class);
    }

    protected Iterable<? extends Neo4jMBean> createMBeans(ManagementData management) throws NotCompliantMBeanException {
        NodeManager nm = management.getKernelData().graphDatabase().getNodeManager();
        LinkedList<CacheManager> cacheBeans = new LinkedList<CacheManager>();
        for (org.neo4j.kernel.impl.cache.Cache cache : nm.caches()) {
            cacheBeans.add(new CacheManager(management, nm, cache));
        }
        return cacheBeans;
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        throw new UnsupportedOperationException("Uses createMBeans");
    }

    private class CacheManager
    extends Neo4jMBean
    implements Cache {
        private final org.neo4j.kernel.impl.cache.Cache cache;
        private final NodeManager nodeManager;

        CacheManager(ManagementData management, NodeManager nodeManager, org.neo4j.kernel.impl.cache.Cache cache) throws NotCompliantMBeanException {
            super(management, new String[]{cache.getName()});
            this.nodeManager = nodeManager;
            this.cache = cache;
        }

        @Override
        public String getCacheType() {
            return this.nodeManager.getCacheType().getDescription();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public long getCacheSize() {
            return this.cache.size();
        }

        @Override
        public long getHitCount() {
            return this.cache.hitCount();
        }

        @Override
        public long getMissCount() {
            return this.cache.missCount();
        }
    }
}

