/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.util.ArrayList;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.management.Diagnostics;

public class DiagnosticsBean
extends ManagementBeanProvider {
    public DiagnosticsBean() {
        super(Diagnostics.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new DiagnosticsImpl(management);
    }

    private static class DiagnosticsImpl
    extends Neo4jMBean
    implements Diagnostics {
        private final DiagnosticsManager diagnostics;
        private final StringLogger log;

        DiagnosticsImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.diagnostics = management.getKernelData().graphDatabase().getDiagnosticsManager();
            this.log = management.getKernelData().graphDatabase().getMessageLog();
        }

        @Override
        public void dumpToLog() {
            this.diagnostics.dumpAll();
        }

        @Override
        public List<String> getDiagnosticsProviders() {
            ArrayList<String> result = new ArrayList<String>();
            for (DiagnosticsProvider provider : this.diagnostics) {
                result.add(provider.getDiagnosticsIdentifier());
            }
            return result;
        }

        @Override
        public void dumpToLog(String providerId) {
            this.diagnostics.dump(providerId);
        }

        @Override
        public String extract(String providerId) {
            StringBuffer result = new StringBuffer();
            this.diagnostics.extract(providerId, StringLogger.wrap((StringBuffer)result));
            return result.toString();
        }
    }
}

