/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.neo4j.kernel.KernelData;
import org.neo4j.management.impl.AdvancedManagementSupport;
import org.neo4j.management.impl.KernelProxy;

public class HotspotManagementSupport
extends AdvancedManagementSupport {
    private static final Logger log = Logger.getLogger(HotspotManagementSupport.class.getName());

    protected JMXServiceURL getJMXServiceURL(KernelData kernel) {
        JMXServiceURL url = null;
        try {
            Class<?> cal = Class.forName("sun.management.ConnectorAddressLink");
            try {
                Method importRemoteFrom = cal.getMethod("importRemoteFrom", Integer.TYPE);
                Map remote = (Map)importRemoteFrom.invoke(null, 0);
                url = this.getUrlFrom(remote);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (url == null) {
                Method importFrom = cal.getMethod("importFrom", Integer.TYPE);
                url = this.getUrlFrom((String)importFrom.invoke(null, 0));
            }
        }
        catch (InvocationTargetException e) {
            log.log(Level.CONFIG, "Failed to load local JMX connection URL.", e.getTargetException());
        }
        catch (LinkageError e) {
            log.log(Level.CONFIG, "Failed to load local JMX connection URL.", e);
        }
        catch (Exception e) {
            log.log(Level.CONFIG, "Failed to load local JMX connection URL.", e);
        }
        if (url == null) {
            Object portObj = kernel.getParam("jmx.port");
            int port = 0;
            if (portObj instanceof Integer) {
                port = (Integer)portObj;
            } else if (portObj instanceof String) {
                try {
                    port = Integer.parseInt((String)portObj);
                }
                catch (NumberFormatException ok) {
                    // empty catch block
                }
            }
            if (port > 0) {
                Object useSslObj = kernel.getParam("jmx.use_ssl");
                boolean useSSL = false;
                if (useSslObj instanceof Boolean) {
                    useSSL = (Boolean)useSslObj;
                } else if (useSslObj instanceof String) {
                    useSSL = Boolean.parseBoolean((String)useSslObj);
                }
                log.log(Level.CONFIG, "Creating new MBean server on port %s%s", new Object[]{port, useSSL ? " using ssl" : ""});
                JMXConnectorServer server = this.createServer(port, useSSL);
                if (server != null) {
                    try {
                        server.start();
                    }
                    catch (IOException e) {
                        log.log(Level.CONFIG, "Failed to start MBean server", e);
                        server = null;
                    }
                    if (server != null) {
                        try {
                            server.getMBeanServer().registerMBean(server, KernelProxy.createObjectName(kernel.instanceId(), "JMX Server", new String[0]));
                        }
                        catch (Exception e) {
                            log.log(Level.CONFIG, "Failed to register MBean server as JMX bean", e);
                        }
                        url = server.getAddress();
                    }
                }
            }
        }
        return url;
    }

    private JMXServiceURL getUrlFrom(Map<String, String> remote) {
        HashSet<Integer> instances = new HashSet<Integer>();
        for (String key : remote.keySet()) {
            int id;
            int start;
            int end;
            if (!key.startsWith("sun.management.JMXConnectorServer") || (end = key.lastIndexOf(46)) < 0 || (start = key.lastIndexOf(46, end)) < 0) continue;
            try {
                id = Integer.parseInt(key.substring(start, end));
            }
            catch (NumberFormatException e) {
                continue;
            }
            instances.add(id);
        }
        if (!instances.isEmpty()) {
            String prefix = "sun.management.JMXConnectorServer.";
            if (instances.size() > 1) {
                for (Object key : instances.toArray()) {
                    if (remote.containsKey("sun.management.JMXConnectorServer." + key + ".remoteAddress")) continue;
                    instances.remove(key);
                }
                if (instances.contains(0)) {
                    prefix = prefix + "0.";
                }
            }
            if (instances.size() == 1) {
                String remoteAddress = remote.get(prefix + instances.iterator().next() + "remoteAddress");
                try {
                    return new JMXServiceURL(remoteAddress);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            if (!instances.isEmpty()) {
                // empty if block
            }
        }
        return null;
    }

    private JMXServiceURL getUrlFrom(String url) {
        JMXServiceURL jmxUrl;
        if (url == null) {
            return null;
        }
        try {
            jmxUrl = new JMXServiceURL(url);
        }
        catch (MalformedURLException e1) {
            return null;
        }
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ok) {
            // empty catch block
        }
        if (host == null) {
            host = jmxUrl.getHost();
        }
        try {
            return new JMXServiceURL(jmxUrl.getProtocol(), host, jmxUrl.getPort(), jmxUrl.getURLPath());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private JMXConnectorServer createServer(int port, boolean useSSL) {
        JMXServiceURL url;
        MBeanServer server = this.getMBeanServer();
        try {
            url = new JMXServiceURL("rmi", null, port);
        }
        catch (MalformedURLException e) {
            log.log(Level.WARNING, "Failed to start JMX Server", e);
            return null;
        }
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (useSSL) {
            env.put("jmx.remote.rmi.client.socket.factory", new SslRMIClientSocketFactory());
            env.put("jmx.remote.rmi.server.socket.factory", new SslRMIServerSocketFactory());
        }
        try {
            return JMXConnectorServerFactory.newJMXConnectorServer(url, env, server);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to start JMX Server", e);
            return null;
        }
    }
}

