/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.util.List;
import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.info.LockInfo;
import org.neo4j.management.LockManager;

public final class LockManagerBean
extends ManagementBeanProvider {
    public LockManagerBean() {
        super(LockManager.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new LockManagerImpl(management);
    }

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        return new LockManagerImpl(management, true);
    }

    private static class LockManagerImpl
    extends Neo4jMBean
    implements LockManager {
        private final org.neo4j.kernel.impl.transaction.LockManager lockManager;

        LockManagerImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.lockManager = management.getKernelData().graphDatabase().getLockManager();
        }

        LockManagerImpl(ManagementData management, boolean mxBean) {
            super(management, mxBean, new String[0]);
            this.lockManager = management.getKernelData().graphDatabase().getLockManager();
        }

        @Override
        public long getNumberOfAdvertedDeadlocks() {
            return this.lockManager.getDetectedDeadlockCount();
        }

        @Override
        public List<LockInfo> getLocks() {
            return this.lockManager.getAllLocks();
        }

        @Override
        public List<LockInfo> getContendedLocks(long minWaitTime) {
            return this.lockManager.getAwaitedLocks(minWaitTime);
        }
    }
}

