/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.util.Iterator;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.management.MemoryMapping;
import org.neo4j.management.WindowPoolInfo;

public final class MemoryMappingBean
extends ManagementBeanProvider {
    public MemoryMappingBean() {
        super(MemoryMapping.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new MemoryMappingImpl(management);
    }

    protected Neo4jMBean createMXBean(ManagementData management) throws NotCompliantMBeanException {
        return new MemoryMappingImpl(management, true);
    }

    private static class MemoryMappingImpl
    extends Neo4jMBean
    implements MemoryMapping {
        private final NeoStoreXaDataSource datasource;

        MemoryMappingImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.datasource = management.getKernelData().graphDatabase().getXaDataSourceManager().getNeoStoreDataSource();
        }

        MemoryMappingImpl(ManagementData management, boolean isMxBean) {
            super(management, isMxBean, new String[0]);
            this.datasource = management.getKernelData().graphDatabase().getXaDataSourceManager().getNeoStoreDataSource();
        }

        @Override
        public WindowPoolInfo[] getMemoryPools() {
            return MemoryMappingImpl.getMemoryPoolsImpl(this.datasource);
        }

        public static WindowPoolInfo[] getMemoryPoolsImpl(NeoStoreXaDataSource datasource) {
            List stats = datasource.getWindowPoolStats();
            WindowPoolInfo[] pools = new WindowPoolInfo[stats.size()];
            Iterator iter = stats.iterator();
            int index = 0;
            while (iter.hasNext()) {
                pools[index] = MemoryMappingImpl.createWindowPoolInfo((WindowPoolStats)iter.next());
                ++index;
            }
            return pools;
        }

        private static WindowPoolInfo createWindowPoolInfo(WindowPoolStats stats) {
            return new WindowPoolInfo(stats.getName(), stats.getMemAvail(), stats.getMemUsed(), stats.getWindowCount(), stats.getWindowSize(), stats.getHitCount(), stats.getMissCount(), stats.getOomCount());
        }
    }
}

