/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.io.File;
import java.io.IOException;
import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.management.StoreFile;

public final class StoreFileBean
extends ManagementBeanProvider {
    public StoreFileBean() {
        super(StoreFile.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new StoreFileImpl(management);
    }

    private static class StoreFileImpl
    extends Neo4jMBean
    implements StoreFile {
        private static final String NODE_STORE = "neostore.nodestore.db";
        private static final String RELATIONSHIP_STORE = "neostore.relationshipstore.db";
        private static final String PROPERTY_STORE = "neostore.propertystore.db";
        private static final String ARRAY_STORE = "neostore.propertystore.db.arrays";
        private static final String STRING_STORE = "neostore.propertystore.db.strings";
        private static final String LOGICAL_LOG1 = "nioneo_logical.log.1";
        private static final String LOGICAL_LOG2 = "nioneo_logical.log.2";
        private final File storePath;

        StoreFileImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            File path;
            NeoStoreXaDataSource nioneodb = management.getKernelData().graphDatabase().getXaDataSourceManager().getNeoStoreDataSource();
            try {
                path = new File(nioneodb.getStoreDir()).getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                path = new File(nioneodb.getStoreDir()).getAbsoluteFile();
            }
            this.storePath = path;
        }

        @Override
        public long getTotalStoreSize() {
            return StoreFileImpl.sizeOf(this.storePath);
        }

        @Override
        public long getLogicalLogSize() {
            File logicalLog = new File(this.storePath, LOGICAL_LOG1);
            if (!logicalLog.isFile()) {
                logicalLog = new File(this.storePath, LOGICAL_LOG2);
            }
            return StoreFileImpl.sizeOf(logicalLog);
        }

        private static long sizeOf(File file) {
            if (file.isFile()) {
                return file.length();
            }
            if (file.isDirectory()) {
                long size = 0L;
                for (File child : file.listFiles()) {
                    size += StoreFileImpl.sizeOf(child);
                }
                return size;
            }
            return 0L;
        }

        private long sizeOf(String name) {
            return StoreFileImpl.sizeOf(new File(this.storePath, name));
        }

        @Override
        public long getArrayStoreSize() {
            return this.sizeOf(ARRAY_STORE);
        }

        @Override
        public long getNodeStoreSize() {
            return this.sizeOf(NODE_STORE);
        }

        @Override
        public long getPropertyStoreSize() {
            return this.sizeOf(PROPERTY_STORE);
        }

        @Override
        public long getRelationshipStoreSize() {
            return this.sizeOf(RELATIONSHIP_STORE);
        }

        @Override
        public long getStringStoreSize() {
            return this.sizeOf(STRING_STORE);
        }
    }
}

