/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.management.TransactionManager;

public final class TransactionManagerBean
extends ManagementBeanProvider {
    public TransactionManagerBean() {
        super(TransactionManager.class);
    }

    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new TransactionManagerImpl(management);
    }

    private static class TransactionManagerImpl
    extends Neo4jMBean
    implements TransactionManager {
        private final TxManager txManager;
        private final NeoStore neoStore;

        TransactionManagerImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            this.txManager = (TxManager)management.getKernelData().graphDatabase().getTxManager();
            this.neoStore = management.getKernelData().graphDatabase().getXaDataSourceManager().getNeoStoreDataSource().getNeoStore();
        }

        @Override
        public int getNumberOfOpenTransactions() {
            return this.txManager.getActiveTxCount();
        }

        @Override
        public int getPeakNumberOfConcurrentTransactions() {
            return this.txManager.getPeakConcurrentTxCount();
        }

        @Override
        public int getNumberOfOpenedTransactions() {
            return this.txManager.getStartedTxCount();
        }

        @Override
        public long getNumberOfCommittedTransactions() {
            return this.txManager.getCommittedTxCount();
        }

        @Override
        public long getNumberOfRolledBackTransactions() {
            return this.txManager.getRolledbackTxCount();
        }

        @Override
        public long getLastCommittedTxId() {
            return this.neoStore.getLastCommittedTx();
        }
    }
}

