/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.helpers.Args;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.shell.impl.ShellBootstrap;
import org.neo4j.shell.impl.ShellServerExtension;
import org.neo4j.shell.impl.StandardConsole;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;

public class StartClient {
    private AtomicBoolean hasBeenShutdown = new AtomicBoolean();
    public static final String ARG_PATH = "path";
    public static final String ARG_READONLY = "readonly";
    public static final String ARG_HOST = "host";
    public static final String ARG_PORT = "port";
    public static final String ARG_NAME = "name";
    public static final String ARG_PID = "pid";
    public static final String ARG_COMMAND = "c";
    public static final String ARG_CONFIG = "config";
    private static final Method attachMethod;
    private static final Method loadMethod;

    private StartClient() {
    }

    public static void main(String[] arguments) {
        new StartClient().start(arguments);
    }

    public static void agentmain(String agentArgs) {
        new ShellServerExtension().loadAgent(agentArgs);
    }

    private void start(String[] arguments) {
        Args args = new Args(arguments);
        if (args.has("?") || args.has("h") || args.has("help") || args.has("usage")) {
            StartClient.printUsage();
            return;
        }
        String path = args.get(ARG_PATH, null);
        String host = args.get(ARG_HOST, null);
        String port = args.get(ARG_PORT, null);
        String name = args.get(ARG_NAME, null);
        String pid = args.get(ARG_PID, null);
        if (path != null && (port != null || name != null || host != null || pid != null) || pid != null && host != null) {
            System.err.println("You have supplied both path as well as host/port/name. You should either supply only path or host/port/name so that either a local or remote shell client can be started");
            return;
        }
        if (path != null) {
            try {
                StartClient.checkNeo4jDependency();
            }
            catch (ShellException e) {
                StartClient.handleException(e, args);
            }
            this.startLocal(args);
        } else {
            if (pid != null) {
                this.startServer(pid, args);
            }
            StartClient.startRemote(args);
        }
    }

    private static void checkNeo4jDependency() throws ShellException {
        try {
            Class.forName("org.neo4j.graphdb.GraphDatabaseService");
        }
        catch (Exception e) {
            throw new ShellException("Neo4j not found on the classpath");
        }
    }

    private void startLocal(Args args) {
        String dbPath = args.get(ARG_PATH, null);
        if (dbPath == null) {
            System.err.println("ERROR: To start a local Neo4j service and a shell client on top of that you need to supply a path to a Neo4j store or just a new path where a new store will be created if it doesn't exist. -path /my/path/here");
            return;
        }
        try {
            boolean readOnly = args.getBoolean(ARG_READONLY, false, true);
            this.tryStartLocalServerAndClient(dbPath, readOnly, args);
        }
        catch (Exception e) {
            if (StartClient.storeWasLocked(e)) {
                if (StartClient.wantToConnectReadOnlyInstead()) {
                    try {
                        this.tryStartLocalServerAndClient(dbPath, true, args);
                    }
                    catch (Exception innerException) {
                        StartClient.handleException(innerException, args);
                    }
                } else {
                    StartClient.handleException(e, args);
                }
            }
            StartClient.handleException(e, args);
        }
        System.exit(0);
    }

    private static boolean wantToConnectReadOnlyInstead() {
        StandardConsole console = new StandardConsole();
        console.format("\nThe store seem locked. Start a read-only client instead (y/n) [y]? ", new Object[0]);
        String input = console.readLine("");
        return input.length() == 0 || input.equals("y");
    }

    private static boolean storeWasLocked(Exception e) {
        return StartClient.mineException(e, IllegalStateException.class, "Unable to lock store");
    }

    private static boolean mineException(Throwable e, Class<IllegalStateException> eClass, String startOfMessage) {
        if (eClass.isInstance(e) && e.getMessage().startsWith(startOfMessage)) {
            return true;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            return StartClient.mineException(cause, eClass, startOfMessage);
        }
        return false;
    }

    private void tryStartLocalServerAndClient(String dbPath, boolean readOnly, Args args) throws Exception {
        String configFile = args.get(ARG_CONFIG, null);
        final GraphDatabaseShellServer server = new GraphDatabaseShellServer(dbPath, readOnly, configFile);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                StartClient.this.shutdownIfNecessary(server);
            }
        });
        if (!StartClient.isCommandLine(args)) {
            System.out.println("NOTE: Local Neo4j graph database service at '" + dbPath + "'");
        }
        SameJvmClient client = new SameJvmClient(server);
        StartClient.setSessionVariablesFromArgs(client, args);
        StartClient.grabPromptOrJustExecuteCommand(client, args);
        this.shutdownIfNecessary(server);
    }

    private void shutdownIfNecessary(ShellServer server) {
        try {
            if (!this.hasBeenShutdown.compareAndSet(false, true)) {
                server.shutdown();
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void startServer(String pid, Args args) {
        String port = args.get(ARG_PORT, Integer.toString(1337));
        String name = args.get(ARG_NAME, "shell");
        try {
            String jarfile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsolutePath();
            Object vm = attachMethod.invoke(null, pid);
            loadMethod.invoke(vm, jarfile, new ShellBootstrap(Integer.parseInt(port), name).serialize());
        }
        catch (Exception e) {
            StartClient.handleException(e, args);
        }
    }

    private static void startRemote(Args args) {
        try {
            String host = args.get(ARG_HOST, "localhost");
            int port = args.getNumber(ARG_PORT, 1337).intValue();
            String name = args.get(ARG_NAME, "shell");
            ShellClient client = ShellLobby.newClient(host, port, name);
            if (!StartClient.isCommandLine(args)) {
                System.out.println("NOTE: Remote Neo4j graph database service '" + name + "' at port " + port);
            }
            StartClient.setSessionVariablesFromArgs(client, args);
            StartClient.grabPromptOrJustExecuteCommand(client, args);
        }
        catch (Exception e) {
            StartClient.handleException(e, args);
        }
    }

    private static boolean isCommandLine(Args args) {
        return args.get(ARG_COMMAND, null) != null;
    }

    private static void grabPromptOrJustExecuteCommand(ShellClient client, Args args) throws Exception {
        String command = args.get(ARG_COMMAND, null);
        if (command != null) {
            client.getServer().interpretLine(command, client.session(), client.getOutput());
            client.shutdown();
        } else {
            client.grabPrompt();
        }
    }

    static void setSessionVariablesFromArgs(ShellClient client, Args args) throws RemoteException {
        String profile = args.get("profile", null);
        if (profile != null) {
            StartClient.applyProfileFile(new File(profile), client);
        }
        for (Map.Entry<String, String> entry : args.asMap().entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("D")) continue;
            key = key.substring(1);
            client.session().set(key, (Serializable)((Object)entry.getValue()));
        }
    }

    private static void applyProfileFile(File file, ShellClient client) {
        InputStream in = null;
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            for (Object key : properties.keySet()) {
                String stringKey = (String)key;
                String value = properties.getProperty(stringKey);
                client.session().set(stringKey, (Serializable)((Object)value));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't find profile '" + file.getAbsolutePath() + "'");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void handleException(Exception e, Args args) {
        String message = e.getCause() instanceof ConnectException ? "Connection refused" : e.getMessage();
        System.err.println("ERROR (-v for expanded information):\n\t" + message);
        if (args.has("v")) {
            e.printStackTrace(System.err);
        }
        System.err.println();
        StartClient.printUsage();
        System.exit(1);
    }

    private static int longestString(String ... strings) {
        int length = 0;
        for (String string : strings) {
            if (string.length() <= length) continue;
            length = string.length();
        }
        return length;
    }

    private static void printUsage() {
        int port = 1337;
        String name = "shell";
        int longestArgLength = StartClient.longestString(ARG_COMMAND, ARG_CONFIG, ARG_HOST, ARG_NAME, ARG_PATH, ARG_PID, ARG_PORT, ARG_READONLY);
        System.out.println(StartClient.padArg(ARG_HOST, longestArgLength) + "Domain name or IP of host to connect to (default: localhost)\n" + StartClient.padArg(ARG_PORT, longestArgLength) + "Port of host to connect to (default: " + 1337 + ")\n" + StartClient.padArg(ARG_NAME, longestArgLength) + "RMI name, i.e. rmi://<host>:<port>/<name> (default: " + "shell" + ")\n" + StartClient.padArg(ARG_PID, longestArgLength) + "Process ID to connect to\n" + StartClient.padArg(ARG_COMMAND, longestArgLength) + "Command line to execute. After executing it the shell exits\n" + StartClient.padArg(ARG_READONLY, longestArgLength) + "Connect in readonly mode\n" + StartClient.padArg(ARG_PATH, longestArgLength) + "Points to a neo4j db path so that a local server can be started there\n" + StartClient.padArg(ARG_CONFIG, longestArgLength) + "Points to a config file when starting a local server\n\n" + "Example arguments for remote:\n" + "\t-" + ARG_PORT + " " + port + "\n" + "\t-" + ARG_HOST + " " + "192.168.1.234" + " -" + ARG_PORT + " " + port + " -" + ARG_NAME + " " + name + "\n" + "\t-" + ARG_HOST + " " + "localhost" + " -" + ARG_READONLY + "\n" + "\t...or no arguments for default values\n" + "Example arguments for local:\n" + "\t-" + ARG_PATH + " /path/to/db" + "\n" + "\t-" + ARG_PATH + " /path/to/db -" + ARG_CONFIG + " /path/to/neo4j.config" + "\n" + "\t-" + ARG_PATH + " /path/to/db -" + ARG_READONLY);
    }

    private static String padArg(String arg, int length) {
        return " -" + StartClient.pad(arg, length) + "  ";
    }

    private static String pad(String string, int length) {
        while (string.length() < length) {
            string = string + " ";
        }
        return string;
    }

    static {
        Method load;
        Method attach;
        try {
            Class<?> vmClass = Class.forName("com.sun.tools.attach.VirtualMachine");
            attach = vmClass.getMethod("attach", String.class);
            load = vmClass.getMethod("loadAgent", String.class, String.class);
        }
        catch (Exception e) {
            load = null;
            attach = null;
        }
        attachMethod = attach;
        loadMethod = load;
    }
}

