/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.GraphDatabaseApp;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;

public class Mkrel
extends GraphDatabaseApp {
    public static final String KEY_LAST_CREATED_NODE = "LAST_CREATED_NODE";
    public static final String KEY_LAST_CREATED_RELATIONSHIP = "LAST_CREATED_RELATIONSHIP";

    public Mkrel() {
        this.addOptionDefinition("t", new OptionDefinition(OptionValueType.MUST, "The relationship type"));
        this.addOptionDefinition("d", new OptionDefinition(OptionValueType.MUST, "The direction: " + this.directionAlternatives() + "."));
        this.addOptionDefinition("c", new OptionDefinition(OptionValueType.NONE, "Supplied if there should be created a new node"));
        this.addOptionDefinition("v", new OptionDefinition(OptionValueType.NONE, "Verbose mode: display created nodes/relationships"));
        this.addOptionDefinition("np", new OptionDefinition(OptionValueType.MUST, "Properties (a json map) to set for the new node (if one is created)"));
        this.addOptionDefinition("rp", new OptionDefinition(OptionValueType.MUST, "Properties (a json map) to set for the new relationship"));
        this.addOptionDefinition("cd", new OptionDefinition(OptionValueType.NONE, "Go to the created node, like doing 'cd'"));
    }

    @Override
    public String getDescription() {
        return "Creates a relationship to a new or existing node, f.ex:\nmkrel -ct KNOWS (will create a relationship to a new node)\nmkrel -t KNOWS 123 (will create a relationship to node with id 123)";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        this.assertCurrentIsNode(session);
        boolean createNode = parser.options().containsKey("c");
        boolean suppliedNode = !parser.arguments().isEmpty();
        Node node = null;
        if (createNode) {
            node = this.getServer().getDb().createNode();
            session.set(KEY_LAST_CREATED_NODE, (Serializable)((Object)("" + node.getId())));
            this.setProperties(node, parser.options().get("np"));
        } else if (suppliedNode) {
            node = this.getNodeById(Long.parseLong(parser.arguments().get(0)));
        } else {
            throw new ShellException("Must either create node (-c) or supply node id as the first argument");
        }
        if (parser.options().get("t") == null) {
            throw new ShellException("Must supply relationship type (-t <relationship-type-name>)");
        }
        RelationshipType type = Mkrel.getRelationshipType(parser.options().get("t"));
        Direction direction = Mkrel.getDirection(parser.options().get("d"));
        NodeOrRelationship current = this.getCurrent(session);
        Node currentNode = current.asNode();
        Node startNode = direction == Direction.OUTGOING ? currentNode : node;
        Node endNode = direction == Direction.OUTGOING ? node : currentNode;
        Relationship relationship = startNode.createRelationshipTo(endNode, type);
        this.setProperties(relationship, parser.options().get("rp"));
        session.set(KEY_LAST_CREATED_RELATIONSHIP, Long.valueOf(relationship.getId()));
        boolean verbose = parser.options().containsKey("v");
        if (createNode && verbose) {
            out.println((Serializable)((Object)("Node " + Mkrel.getDisplayName(this.getServer(), session, node, false) + " created")));
        }
        if (verbose) {
            out.println((Serializable)((Object)("Relationship " + Mkrel.getDisplayName(this.getServer(), session, relationship, true, false) + " created")));
        }
        if (parser.options().containsKey("cd")) {
            this.cdTo(session, node);
        }
        return null;
    }
}

