/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public abstract class GraphDatabaseSetting {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ANY = ".+";
    public static final String SIZE = "\\d+[kmgKMG]";
    public static final String DURATION = "\\d+(ms|s|m)";
    private String name;
    private String validationMessage;

    protected GraphDatabaseSetting(String name, String validationMessage) {
        this.name = name;
        this.validationMessage = validationMessage;
    }

    public String name() {
        return this.name;
    }

    public String validationMessage() {
        return this.validationMessage;
    }

    public void validate(String value) throws IllegalArgumentException {
        this.validate(Locale.getDefault(), value);
    }

    public abstract void validate(Locale var1, String var2);

    protected String getMessage(Locale locale, String defaultMessage) {
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            return defaultMessage;
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getName());
            return bundle.getString(this.name());
        }
        catch (Exception e) {
            return defaultMessage;
        }
    }

    protected IllegalArgumentException illegalValue(Locale locale, String ... args) throws IllegalArgumentException {
        String message = this.getMessage(locale, this.validationMessage);
        Formatter formatter = new Formatter(locale);
        formatter.format(message, args);
        return new IllegalArgumentException(formatter.toString());
    }

    public static boolean osIsWindows() {
        String nameOs = System.getProperty("os.name");
        return nameOs.startsWith("Windows");
    }

    public static boolean osIsMacOS() {
        String nameOs = System.getProperty("os.name");
        return nameOs.equalsIgnoreCase("Mac OS X");
    }

    public static class OptionsSetting
    extends GraphDatabaseSetting {
        String[] options;

        protected OptionsSetting(String name, String ... options) {
            super(name, "Value '%s' is not valid. Valid options are:%s");
            this.options = options;
        }

        @Override
        public void validate(Locale locale, String value) throws IllegalArgumentException {
            for (String option : this.options()) {
                if (!option.equalsIgnoreCase(value)) continue;
                return;
            }
            throw this.illegalValue(locale, value, Arrays.asList(this.options()).toString());
        }

        public String[] options() {
            return this.options;
        }
    }

    public static class PortSetting
    extends IntegerSetting {
        public PortSetting(String name) {
            super(name, "Must be a valid port number", 1, 65535);
        }
    }

    public static class DoubleSetting
    extends NumberSetting<Double> {
        public DoubleSetting(String name, String formatMessage) {
            super(name, formatMessage);
        }

        public DoubleSetting(String name, String formatMessage, Double min, Double max) {
            super(name, formatMessage, min, max);
        }

        @Override
        public void validate(Locale locale, String value) {
            double val;
            if (value == null) {
                throw this.illegalValue(locale, value);
            }
            try {
                val = Double.parseDouble(value);
            }
            catch (Exception e) {
                throw this.illegalValue(locale, value);
            }
            this.rangeCheck(Double.valueOf(val));
        }
    }

    public static class FloatSetting
    extends NumberSetting<Float> {
        public FloatSetting(String name, String formatMessage) {
            super(name, formatMessage);
        }

        public FloatSetting(String name, String formatMessage, Float min, Float max) {
            super(name, formatMessage, min, max);
        }

        @Override
        public void validate(Locale locale, String value) {
            float val;
            if (value == null) {
                throw this.illegalValue(locale, value);
            }
            try {
                val = Float.parseFloat(value);
            }
            catch (Exception e) {
                throw this.illegalValue(locale, value);
            }
            this.rangeCheck(Float.valueOf(val));
        }
    }

    public static class LongSetting
    extends NumberSetting<Long> {
        public LongSetting(String name, String formatMessage) {
            super(name, formatMessage);
        }

        public LongSetting(String name, String formatMessage, Long min, Long max) {
            super(name, formatMessage, min, max);
        }

        @Override
        public void validate(Locale locale, String value) {
            long val;
            if (value == null) {
                throw this.illegalValue(locale, value);
            }
            try {
                val = Long.parseLong(value);
            }
            catch (Exception e) {
                throw this.illegalValue(locale, value);
            }
            this.rangeCheck(Long.valueOf(val));
        }
    }

    public static class IntegerSetting
    extends NumberSetting<Integer> {
        public IntegerSetting(String name, String formatMessage) {
            super(name, formatMessage);
        }

        public IntegerSetting(String name, String formatMessage, Integer min, Integer max) {
            super(name, formatMessage, min, max);
        }

        @Override
        public void validate(Locale locale, String value) {
            int val;
            if (value == null) {
                throw this.illegalValue(locale, value);
            }
            try {
                val = Integer.parseInt(value);
            }
            catch (Exception e) {
                throw this.illegalValue(locale, value);
            }
            this.rangeCheck(Integer.valueOf(val));
        }
    }

    public static abstract class NumberSetting<T extends Number>
    extends GraphDatabaseSetting {
        protected T min;
        protected T max;

        protected NumberSetting(String name, String validationMessage) {
            super(name, validationMessage);
        }

        protected NumberSetting(String name, String validationMessage, T min, T max) {
            super(name, validationMessage);
            this.min = min;
            this.max = max;
        }

        protected void rangeCheck(Comparable value) {
            if (this.min != null && value.compareTo(this.min) < 0) {
                throw new IllegalArgumentException("Minimum allowed value is:" + this.min);
            }
            if (this.max != null && value.compareTo(this.max) > 0) {
                throw new IllegalArgumentException("Maximum allowed value is:" + this.max);
            }
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }
    }

    public static class StringSetting
    extends GraphDatabaseSetting {
        private Pattern regex;

        public StringSetting(String name, String regex, String formatMessage) {
            super(name, formatMessage);
            this.regex = Pattern.compile(regex);
        }

        @Override
        public void validate(Locale locale, String value) {
            if (value == null) {
                throw this.illegalValue(locale, value);
            }
            if (!this.regex.matcher(value).matches()) {
                throw this.illegalValue(locale, value);
            }
        }
    }

    public static class BooleanSetting
    extends OptionsSetting {
        public BooleanSetting(String name) {
            super(name, GraphDatabaseSetting.TRUE, GraphDatabaseSetting.FALSE);
        }
    }

    public static interface DefaultValue {
        public String getDefaultValue();
    }
}

