/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ClockCache<K, V> {
    private final Queue<Page<V>> clock = new ConcurrentLinkedQueue<Page<V>>();
    private final ConcurrentHashMap<K, Page<V>> cache = new ConcurrentHashMap();
    private final int maxSize;
    private final AtomicInteger currentSize = new AtomicInteger(0);
    private final String name;

    public ClockCache(String name, int size) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (size <= 0) {
            throw new IllegalArgumentException(size + " is not > 0");
        }
        this.name = name;
        this.maxSize = size;
    }

    public synchronized void put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("null key not allowed");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value not allowed");
        }
        Page<Object> theValue = this.cache.get(key);
        if (theValue == null) {
            theValue = new Page();
            if (this.cache.putIfAbsent(key, theValue) == null) {
                this.clock.offer(theValue);
            } else {
                System.out.println("Ouch, for key " + key);
            }
        }
        Object myValue = theValue.value.get();
        theValue.flag.set(true);
        theValue.value.set(value);
        if (myValue == null) {
            if (this.currentSize.incrementAndGet() > this.maxSize) {
                this.evict();
            }
            assert (this.currentSize.get() <= this.maxSize) : "put: " + this.currentSize.get();
        }
    }

    public V get(K key) {
        if (key == null) {
            throw new IllegalArgumentException("cannot get null key");
        }
        Page<V> theElement = this.cache.get(key);
        if (theElement == null || theElement.value.get() == null) {
            return null;
        }
        Object theValue = theElement.value.get();
        theElement.flag.set(true);
        if (theValue == null) {
            theElement.flag.set(false);
        }
        return (V)theValue;
    }

    private void evict() {
        Page<V> theElement = null;
        while ((theElement = this.clock.poll()) != null && this.currentSize.get() > this.maxSize) {
            if (!theElement.flag.compareAndSet(true, false)) {
                Object valueCleaned = theElement.value.get();
                if (valueCleaned == null) {
                    theElement.flag.set(false);
                } else if (theElement.value.compareAndSet(valueCleaned, null)) {
                    this.elementCleaned(valueCleaned);
                    this.currentSize.decrementAndGet();
                }
            }
            this.clock.offer(theElement);
        }
        if (theElement != null) {
            this.clock.offer(theElement);
        }
    }

    protected void elementCleaned(V element) {
    }

    public Collection<V> values() {
        HashSet toReturn = new HashSet();
        for (Page<V> page : this.cache.values()) {
            if (page.value.get() == null) continue;
            toReturn.add(page.value.get());
        }
        return toReturn;
    }

    public synchronized Set<Map.Entry<K, V>> entrySet() {
        HashMap temp = new HashMap();
        for (Object key : this.cache.keySet()) {
            Page<V> value = this.cache.get(key);
            if (value.value.get() == null) continue;
            temp.put(key, value.value.get());
        }
        return temp.entrySet();
    }

    public synchronized V remove(K key) {
        if (key == null) {
            throw new IllegalArgumentException("cannot remove null key");
        }
        Page<V> toRemove = this.cache.remove(key);
        if (toRemove == null || toRemove.value == null) {
            return null;
        }
        Object toReturn = toRemove.value.get();
        toRemove.value.compareAndSet(toReturn, null);
        toRemove.flag.set(false);
        return (V)toReturn;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void clear() {
        this.cache.clear();
        this.clock.clear();
        this.currentSize.set(0);
    }

    public synchronized int size() {
        return this.currentSize.get();
    }

    private static class Page<E> {
        final AtomicBoolean flag = new AtomicBoolean(true);
        final AtomicReference<E> value = new AtomicReference();

        private Page() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Page)) {
                return false;
            }
            Page other = (Page)obj;
            if (this.value == null) {
                return other.value == null;
            }
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            return (this.value.get() != null ? "->" : "") + "[Flag: " + this.flag + ", value: " + this.value.get() + "]";
        }
    }
}

