/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.MeasureDoNothing;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class MonitorGc
implements Lifecycle {
    private final Config config;
    private final StringLogger logger;
    private volatile MeasureDoNothing monitorGc;

    public MonitorGc(Config config, StringLogger logger) {
        this.config = config;
        this.logger = logger;
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() throws Throwable {
        this.monitorGc = new MeasureDoNothing("GC-Monitor", this.logger, this.config.getDuration(Configuration.gc_monitor_wait_time), this.config.getDuration(Configuration.gc_monitor_threshold));
        this.monitorGc.start();
    }

    @Override
    public void stop() throws Throwable {
        this.monitorGc.stopMeasuring();
        this.monitorGc = null;
    }

    @Override
    public void shutdown() throws Throwable {
    }

    public static class Configuration {
        public static final GraphDatabaseSetting.StringSetting gc_monitor_wait_time = GraphDatabaseSettings.gc_monitor_wait_time;
        public static final GraphDatabaseSetting.StringSetting gc_monitor_threshold = GraphDatabaseSettings.gc_monitor_threshold;
    }
}

