/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.jmx.Description;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;

@Description(value="The configuration parameters used to configure Neo4j")
public final class ConfigurationBean
extends Neo4jMBean {
    public static final String CONFIGURATION_MBEAN_NAME = "Configuration";
    private final Map<String, String> config;
    private Config configuration;
    private static final Map<String, String> parameterDescriptions;

    ConfigurationBean(KernelData kernel, ManagementSupport support) throws NotCompliantMBeanException {
        super(CONFIGURATION_MBEAN_NAME, kernel, support);
        this.config = new HashMap<String, String>(kernel.getConfigParams());
        this.configuration = kernel.getConfig();
        this.configuration.addConfigurationChangeListener((ConfigurationChangeListener)new UpdatedConfigurationListener());
    }

    private static String describeConfigParameter(String param) {
        String description = parameterDescriptions.get(param);
        return description != null ? description : "Configuration attribute";
    }

    private MBeanAttributeInfo[] keys() {
        ArrayList<MBeanAttributeInfo> keys = new ArrayList<MBeanAttributeInfo>();
        for (Map.Entry<String, String> entry : this.config.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            keys.add(new MBeanAttributeInfo(entry.getKey(), String.class.getName(), ConfigurationBean.describeConfigParameter(entry.getKey()), true, true, false));
        }
        return keys.toArray(new MBeanAttributeInfo[keys.size()]);
    }

    private MBeanOperationInfo[] methods() {
        ArrayList<MBeanOperationInfo> methods = new ArrayList<MBeanOperationInfo>();
        try {
            methods.add(new MBeanOperationInfo("Apply settings", this.getClass().getMethod("apply", new Class[0])));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return methods.toArray(new MBeanOperationInfo[methods.size()]);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.config.get(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList(attributes.length);
        for (String attribute : attributes) {
            try {
                result.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.config.containsKey(attribute.getName())) {
            this.config.put(attribute.getName(), attribute.getValue().toString());
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        Description description = this.getClass().getAnnotation(Description.class);
        return new MBeanInfo(this.getClass().getName(), description != null ? description.value() : "Neo4j configuration", this.keys(), null, this.methods(), null);
    }

    @Override
    public Object invoke(String s, Object[] objects, String[] strings) throws MBeanException, ReflectionException {
        try {
            return this.getClass().getMethod(s, new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new MBeanException((Exception)e.getTargetException());
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void apply() {
        try {
            System.out.println("Apply new config");
            this.configuration.applyChanges(this.config);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        HashMap<String, String> descriptions = new HashMap<String, String>();
        for (Field field : GraphDatabaseSettings.class.getFields()) {
            org.neo4j.graphdb.factory.Description documentation;
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || (documentation = field.getAnnotation(org.neo4j.graphdb.factory.Description.class)) == null || !GraphDatabaseSetting.class.isAssignableFrom(field.getType())) continue;
            try {
                GraphDatabaseSetting.NumberSetting numberSetting;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                String description = documentation.value();
                GraphDatabaseSetting setting = (GraphDatabaseSetting)field.get(null);
                if (setting instanceof GraphDatabaseSetting.OptionsSetting) {
                    GraphDatabaseSetting.OptionsSetting optionsSetting = (GraphDatabaseSetting.OptionsSetting)setting;
                    description = description + ". Valid options:" + Arrays.asList(optionsSetting.options());
                }
                if (setting instanceof GraphDatabaseSetting.NumberSetting && ((numberSetting = (GraphDatabaseSetting.NumberSetting)setting).getMin() != null || numberSetting.getMax() != null)) {
                    description = description + ". ";
                    if (numberSetting.getMin() != null) {
                        description = description + numberSetting.getMin() + " < ";
                    }
                    description = description + setting.name();
                    if (numberSetting.getMax() != null) {
                        description = description + " < " + numberSetting.getMax();
                    }
                }
                descriptions.put(setting.name(), description);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        parameterDescriptions = Collections.unmodifiableMap(descriptions);
    }

    private class UpdatedConfigurationListener
    implements ConfigurationChangeListener {
        private UpdatedConfigurationListener() {
        }

        public void notifyConfigurationChanges(Iterable<ConfigurationChange> change) {
            for (ConfigurationChange configurationChange : change) {
                ConfigurationBean.this.config.put(configurationChange.getName(), configurationChange.getNewValue());
            }
        }
    }
}

