/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.backup.TheBackupInterface;
import org.neo4j.com.Client;
import org.neo4j.com.Deserializer;
import org.neo4j.com.MasterCaller;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreIdGetter;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.ToNetworkStoreWriter;
import org.neo4j.kernel.impl.util.StringLogger;

class BackupClient
extends Client<TheBackupInterface>
implements TheBackupInterface {
    public BackupClient(String hostNameOrIp, int port, StringLogger logger, StoreIdGetter storeIdGetter) {
        super(hostNameOrIp, port, logger, storeIdGetter, 0x400000, (byte)1, 40, 20, 20);
    }

    @Override
    public Response<Void> fullBackup(StoreWriter storeWriter) {
        return this.sendRequest(BackupRequestType.FULL_BACKUP, SlaveContext.EMPTY, Protocol.EMPTY_SERIALIZER, (Deserializer)new Protocol.FileStreamsDeserializer(storeWriter));
    }

    @Override
    public Response<Void> incrementalBackup(SlaveContext context) {
        return this.sendRequest(BackupRequestType.INCREMENTAL_BACKUP, context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    protected boolean shouldCheckStoreId(RequestType<TheBackupInterface> type) {
        return type != BackupRequestType.FULL_BACKUP;
    }

    public static enum BackupRequestType implements RequestType<TheBackupInterface>
    {
        FULL_BACKUP((MasterCaller)new MasterCaller<TheBackupInterface, Void>(){

            public Response<Void> callMaster(TheBackupInterface master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.fullBackup((StoreWriter)new ToNetworkStoreWriter(target));
            }
        }, Protocol.VOID_SERIALIZER),
        INCREMENTAL_BACKUP((MasterCaller)new MasterCaller<TheBackupInterface, Void>(){

            public Response<Void> callMaster(TheBackupInterface master, SlaveContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.incrementalBackup(context);
            }
        }, Protocol.VOID_SERIALIZER);

        private final MasterCaller masterCaller;
        private final ObjectSerializer serializer;

        private BackupRequestType(MasterCaller masterCaller, ObjectSerializer serializer) {
            this.masterCaller = masterCaller;
            this.serializer = serializer;
        }

        public MasterCaller getMasterCaller() {
            return this.masterCaller;
        }

        public ObjectSerializer getObjectSerializer() {
            return this.serializer;
        }

        public byte id() {
            return (byte)this.ordinal();
        }
    }
}

