/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import org.neo4j.backup.TheBackupInterface;
import org.neo4j.com.MasterUtil;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreWriter;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.GraphDatabaseAPI;

class BackupImpl
implements TheBackupInterface {
    private final GraphDatabaseAPI graphDb;

    public BackupImpl(GraphDatabaseAPI graphDb) {
        this.graphDb = graphDb;
    }

    @Override
    public Response<Void> fullBackup(StoreWriter writer) {
        SlaveContext context = MasterUtil.rotateLogsAndStreamStoreFiles((GraphDatabaseAPI)this.graphDb, (boolean)false, (StoreWriter)writer);
        writer.done();
        return this.packResponse(context);
    }

    @Override
    public Response<Void> incrementalBackup(SlaveContext context) {
        return this.packResponse(context);
    }

    private Response<Void> packResponse(SlaveContext context) {
        if (GraphDatabaseSetting.osIsWindows()) {
            MasterUtil.rotateLogs((GraphDatabaseAPI)this.graphDb);
        }
        return MasterUtil.packResponse((GraphDatabaseAPI)this.graphDb, (SlaveContext)context, null, (Predicate)MasterUtil.ALL);
    }
}

