/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.backup.BackupClient;
import org.neo4j.backup.BackupServer;
import org.neo4j.backup.VerificationLevel;
import org.neo4j.backup.check.ConsistencyCheck;
import org.neo4j.com.Client;
import org.neo4j.com.MasterUtil;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.ToFileStoreWriter;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ProgressIndicator;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.DefaultLastCommittedTxIdSetter;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigParam;
import org.neo4j.kernel.configuration.ConfigurationDefaults;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;

public class OnlineBackup {
    private final String hostNameOrIp;
    private final int port;
    private final Map<String, Long> lastCommittedTxs = new TreeMap<String, Long>();

    public static OnlineBackup from(String hostNameOrIp, int port) {
        return new OnlineBackup(hostNameOrIp, port);
    }

    public static OnlineBackup from(String hostNameOrIp) {
        return new OnlineBackup(hostNameOrIp, BackupServer.DEFAULT_PORT);
    }

    private OnlineBackup(String hostNameOrIp, int port) {
        this.hostNameOrIp = hostNameOrIp;
        this.port = port;
    }

    public OnlineBackup full(String targetDirectory) {
        return this.full(targetDirectory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnlineBackup full(String targetDirectory, boolean verification) {
        block24: {
            if (OnlineBackup.directoryContainsDb(targetDirectory)) {
                throw new RuntimeException(targetDirectory + " already contains a database");
            }
            BackupClient client = new BackupClient(this.hostNameOrIp, this.port, StringLogger.DEV_NULL, Client.NO_STORE_ID_GETTER);
            long timestamp = System.currentTimeMillis();
            try {
                block23: {
                    Response<Void> response = client.fullBackup(this.decorateWithProgressIndicator((StoreWriter)new ToFileStoreWriter(targetDirectory)));
                    EmbeddedGraphDatabase targetDb = OnlineBackup.startTemporaryDb(targetDirectory, VerificationLevel.NONE);
                    try {
                        this.unpackResponse(response, (GraphDatabaseAPI)targetDb, MasterUtil.txHandlerForFullCopy());
                        HashSet<String> noTxPresent = new HashSet<String>();
                        for (XaDataSource ds : targetDb.getXaDataSourceManager().getAllRegisteredDataSources()) {
                            long lastTx = ds.getLastCommittedTxId();
                            try {
                                ds.getMasterForCommittedTx(lastTx);
                            }
                            catch (NoSuchLogVersionException e) {
                                noTxPresent.add(ds.getName());
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (noTxPresent.isEmpty()) break block23;
                        BackupClient recoveryClient = new BackupClient(this.hostNameOrIp, this.port, targetDb.getMessageLog(), Client.storeIdGetterForDb((GraphDatabaseService)targetDb));
                        Response<Void> recoveryResponse = null;
                        HashMap<String, Long> recoveryDiff = new HashMap<String, Long>();
                        for (String ds : noTxPresent) {
                            recoveryDiff.put(ds, -1L);
                        }
                        SlaveContext recoveryCtx = this.addDiffToSlaveContext(this.slaveContextOf((GraphDatabaseAPI)targetDb), recoveryDiff);
                        try {
                            recoveryResponse = recoveryClient.incrementalBackup(recoveryCtx);
                            TransactionStream txs = recoveryResponse.transactions();
                            ByteBuffer scratch = ByteBuffer.allocate(64);
                            while (txs.hasNext()) {
                                Triplet tx = (Triplet)txs.next();
                                scratch.clear();
                                XaDataSource ds = targetDb.getXaDataSourceManager().getXaDataSource((String)tx.first());
                                long logVersion = ds.getCurrentLogVersion() - 1L;
                                FileChannel newLog = new RandomAccessFile(ds.getFileName(logVersion), "rw").getChannel();
                                newLog.truncate(0L);
                                LogIoUtils.writeLogHeader((ByteBuffer)scratch, (long)logVersion, (long)-1L);
                                newLog.write(scratch);
                                ReadableByteChannel received = ((TxExtractor)tx.third()).extract();
                                scratch.flip();
                                while (received.read(scratch) > 0) {
                                    scratch.flip();
                                    newLog.write(scratch);
                                    scratch.flip();
                                }
                                newLog.force(false);
                                newLog.close();
                                received.close();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            recoveryClient.shutdown();
                            if (recoveryResponse != null) {
                                recoveryResponse.close();
                            }
                            targetDb.shutdown();
                        }
                    }
                    finally {
                        targetDb.shutdown();
                    }
                }
                OnlineBackup.bumpLogFile(targetDirectory, timestamp);
                if (!verification) break block24;
                StoreFactory factory = new StoreFactory(new Config(new ConfigurationDefaults(new Class[]{GraphDatabaseSettings.class}).apply(MapUtil.stringMap((String[])new String[0]))), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), (LastCommittedTxIdSetter)new DefaultLastCommittedTxIdSetter(), StringLogger.SYSTEM, (TxHook)new DefaultTxHook());
                NeoStore neoStore = factory.newNeoStore(new File(targetDirectory, "neostore").getAbsolutePath());
                try {
                    StoreAccess store = new StoreAccess(neoStore);
                    ConsistencyCheck.run(store, false);
                }
                finally {
                    neoStore.close();
                }
            }
            finally {
                client.shutdown();
            }
        }
        return this;
    }

    private StoreWriter decorateWithProgressIndicator(final StoreWriter actual) {
        return new StoreWriter(){
            private final ProgressIndicator progress = new ProgressIndicator.UnknownEndProgress(1L, "Files copied");
            private int totalFiles;

            public void write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
                actual.write(path, data, temporaryBuffer, hasData);
                this.progress.update(true, 1L);
                ++this.totalFiles;
            }

            public void done() {
                actual.done();
                this.progress.done((long)this.totalFiles);
            }
        };
    }

    static boolean directoryContainsDb(String targetDirectory) {
        return new File(targetDirectory, "neostore").exists();
    }

    public int getPort() {
        return this.port;
    }

    public String getHostNameOrIp() {
        return this.hostNameOrIp;
    }

    public Map<String, Long> getLastCommittedTxs() {
        return Collections.unmodifiableMap(this.lastCommittedTxs);
    }

    static EmbeddedGraphDatabase startTemporaryDb(String targetDirectory, ConfigParam ... params) {
        if (params != null && params.length > 0) {
            HashMap config = new HashMap();
            for (ConfigParam param : params) {
                if (param == null) continue;
                param.configure(config);
            }
            return new EmbeddedGraphDatabase(targetDirectory, config);
        }
        return new EmbeddedGraphDatabase(targetDirectory);
    }

    public OnlineBackup incremental(String targetDirectory) {
        return this.incremental(targetDirectory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnlineBackup incremental(String targetDirectory, boolean verification) {
        if (!OnlineBackup.directoryContainsDb(targetDirectory)) {
            throw new RuntimeException(targetDirectory + " doesn't contain a database");
        }
        ConfigParam keepLogs = new ConfigParam(){

            public void configure(Map<String, String> config) {
                config.put(GraphDatabaseSettings.keep_logical_logs.name(), "true");
            }
        };
        EmbeddedGraphDatabase targetDb = OnlineBackup.startTemporaryDb(targetDirectory, VerificationLevel.valueOf(verification), keepLogs);
        long backupStartTime = System.currentTimeMillis();
        OnlineBackup result = null;
        try {
            result = this.incremental((GraphDatabaseAPI)targetDb);
        }
        finally {
            targetDb.shutdown();
        }
        if (result != null) {
            OnlineBackup.bumpLogFile(targetDirectory, backupStartTime);
        }
        return result;
    }

    private SlaveContext addDiffToSlaveContext(SlaveContext original, Map<String, Long> diffPerDataSource) {
        SlaveContext.Tx[] oldTxs = original.lastAppliedTransactions();
        SlaveContext.Tx[] newTxs = new SlaveContext.Tx[oldTxs.length];
        for (int i = 0; i < oldTxs.length; ++i) {
            SlaveContext.Tx oldTx = oldTxs[i];
            String dsName = oldTx.getDataSourceName();
            long originalTxId = oldTx.getTxId();
            Long diff = diffPerDataSource.get(dsName);
            if (diff == null) {
                diff = 0L;
            }
            long newTxId = originalTxId + diff;
            newTxs[i] = SlaveContext.lastAppliedTx((String)dsName, (long)newTxId);
        }
        return SlaveContext.anonymous((SlaveContext.Tx[])newTxs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OnlineBackup incrementalWithContext(GraphDatabaseAPI targetDb, SlaveContext context) {
        BackupClient client = new BackupClient(this.hostNameOrIp, this.port, targetDb.getMessageLog(), Client.storeIdGetterForDb((GraphDatabaseService)targetDb));
        try {
            this.unpackResponse(client.incrementalBackup(context), targetDb, new ProgressTxHandler());
            this.trimLogicalLogCount(targetDb);
        }
        finally {
            client.shutdown();
        }
        return this;
    }

    private void trimLogicalLogCount(GraphDatabaseAPI targetDb) {
        for (XaDataSource ds : targetDb.getXaDataSourceManager().getAllRegisteredDataSources()) {
            long currentVersion;
            try {
                ds.rotateLogicalLog();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (currentVersion = ds.getCurrentLogVersion() - 1L; ds.getLogicalLogLength(currentVersion) <= 16L && currentVersion > 0L; --currentVersion) {
            }
            --currentVersion;
            while (ds.getLogicalLogLength(currentVersion) > 0L) {
                ds.deleteLogicalLog(currentVersion);
                --currentVersion;
            }
        }
    }

    public OnlineBackup incremental(GraphDatabaseAPI targetDb) {
        return this.incrementalWithContext(targetDb, this.slaveContextOf(targetDb));
    }

    private void unpackResponse(Response<Void> response, GraphDatabaseAPI graphDb, MasterUtil.TxHandler txHandler) {
        try {
            MasterUtil.applyReceivedTransactions(response, (GraphDatabaseAPI)graphDb, (MasterUtil.TxHandler)txHandler);
            this.getLastCommittedTxs(graphDb);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to apply received transactions", e);
        }
    }

    private void getLastCommittedTxs(GraphDatabaseAPI graphDb) {
        for (XaDataSource ds : graphDb.getXaDataSourceManager().getAllRegisteredDataSources()) {
            this.lastCommittedTxs.put(ds.getName(), ds.getLastCommittedTxId());
        }
    }

    private SlaveContext slaveContextOf(GraphDatabaseAPI graphDb) {
        XaDataSourceManager dsManager = graphDb.getXaDataSourceManager();
        ArrayList<SlaveContext.Tx> txs = new ArrayList<SlaveContext.Tx>();
        for (XaDataSource ds : dsManager.getAllRegisteredDataSources()) {
            txs.add(SlaveContext.lastAppliedTx((String)ds.getName(), (long)ds.getLastCommittedTxId()));
        }
        return SlaveContext.anonymous((SlaveContext.Tx[])txs.toArray(new SlaveContext.Tx[0]));
    }

    private static boolean bumpLogFile(String targetDirectory, long toTimestamp) {
        File dbDirectory = new File(targetDirectory);
        File[] candidates = dbDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("messages.log");
            }
        });
        File previous = null;
        if (candidates.length != 1) {
            return false;
        }
        previous = candidates[0];
        File to = new File(previous.getParentFile(), "messages.log." + toTimestamp);
        return previous.renameTo(to);
    }

    private static class ProgressTxHandler
    implements MasterUtil.TxHandler {
        private final ProgressIndicator progress = new ProgressIndicator.UnknownEndProgress(1000L, "Transactions applied");
        private long count;

        private ProgressTxHandler() {
        }

        public void accept(Triplet<String, Long, TxExtractor> tx, XaDataSource dataSource) {
            this.progress.update(true, 1L);
            ++this.count;
        }

        public void done() {
            this.progress.done(this.count);
        }
    }
}

