/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import org.neo4j.backup.BackupImpl;
import org.neo4j.backup.BackupServer;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtension;

public class OnlineBackupExtension
extends KernelExtension<BackupServer> {
    static final String KEY = "online backup";

    public OnlineBackupExtension() {
        super(KEY);
    }

    public Class getSettingsClass() {
        return OnlineBackupSettings.class;
    }

    protected void loadConfiguration(KernelData kernel) {
    }

    protected BackupServer load(KernelData kernel) {
        if (kernel.getConfig().getBoolean(OnlineBackupSettings.online_backup_enabled)) {
            BackupImpl backup = new BackupImpl(kernel.graphDatabase());
            return new BackupServer(backup, kernel.getConfig().getInteger((GraphDatabaseSetting.IntegerSetting)OnlineBackupSettings.online_backup_port), kernel.graphDatabase().getMessageLog());
        }
        return null;
    }

    protected void unload(BackupServer server) {
        server.shutdown();
    }
}

