/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.ConfigParam;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;

enum VerificationLevel implements ConfigParam
{
    NONE(null, null){

        @Override
        public void configure(Map<String, String> config) {
        }
    }
    ,
    VERIFYING("verifying", "true"),
    LOGGING("inconsistencylog", "diff"),
    FULL_WITH_LOGGING("inconsistencylog", "full");

    private final String interceptorName;
    private final String configValue;

    private VerificationLevel(String name, String value) {
        this.interceptorName = name;
        this.configValue = value;
    }

    static VerificationLevel valueOf(boolean verification) {
        return verification ? VERIFYING : NONE;
    }

    public void configure(Map<String, String> config) {
        this.configure(config, this.configValue);
    }

    void configureWithDiffLog(Map<String, String> config, String targetFile) {
        this.configure(config, this.configValue + ";log=" + targetFile);
    }

    private void configure(Map<String, String> config, String value) {
        config.put(GraphDatabaseSettings.intercept_deserialized_transactions.name(), "true");
        config.put(TransactionInterceptorProvider.class.getSimpleName() + "." + this.interceptorName, value);
    }
}

