/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.check;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.neo4j.backup.check.DiffRecordStore;
import org.neo4j.backup.check.InconsistencyType;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.ProgressIndicator;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.store.StoreAccess;

public abstract class ConsistencyCheck
extends RecordStore.Processor
implements Runnable,
Iterable<RecordStore<?>> {
    private final RecordStore<NodeRecord> nodes;
    private final RecordStore<RelationshipRecord> rels;
    private final RecordStore<PropertyRecord> props;
    private final RecordStore<DynamicRecord> strings;
    private final RecordStore<DynamicRecord> arrays;
    private final RecordStore<PropertyIndexRecord> propIndexes;
    private final RecordStore<RelationshipTypeRecord> relTypes;
    private final RecordStore<DynamicRecord> propKeys;
    private final RecordStore<DynamicRecord> typeNames;
    private final HashMap<Long, PropertyOwner> propertyOwners;
    private long brokenNodes;
    private long brokenRels;
    private long brokenProps;
    private long brokenStrings;
    private long brokenArrays;
    private long brokenTypes;
    private long brokenKeys;
    private static NodeField[] nodeFields = NodeField.values();
    private static RelationshipField[] relFields = RelationshipField.values();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        if (args == null) {
            ConsistencyCheck.printUsage(new String[0]);
            return;
        }
        Args params = new Args(args);
        boolean propowner = params.getBoolean("propowner", Boolean.valueOf(false), Boolean.valueOf(true));
        boolean recovery = params.getBoolean("recovery", Boolean.valueOf(false), Boolean.valueOf(true));
        args = params.orphans().toArray(new String[0]);
        if (args.length != 1) {
            ConsistencyCheck.printUsage(new String[0]);
            System.exit(-1);
            return;
        }
        EmbeddedGraphDatabase graphdb = new EmbeddedGraphDatabase(args[0]);
        StoreAccess stores = new StoreAccess((AbstractGraphDatabase)graphdb);
        try {
            ConsistencyCheck.run(stores, propowner);
        }
        finally {
            graphdb.shutdown();
        }
    }

    private static void printUsage(String ... msgLines) {
        for (String line : msgLines) {
            System.err.println(line);
        }
        System.err.println(Args.jarUsage(ConsistencyCheck.class, (String[])new String[]{"[-propowner] <storedir>"}));
        System.err.println("WHERE:   <storedir>  is the path to the store to check");
        System.err.println("         -propowner  --  to verify that properties are owned only once");
        System.err.println("         -recovery   --  to perform recovery on the store before checking");
    }

    public static void run(StoreAccess stores, boolean propowner) {
        new ConsistencyCheck(stores, propowner){

            @Override
            ProgressIndicator.MultiProgress progressInit() {
                System.err.println("Checking consistency" + (this.propowners() ? " (with property owner verification)" : "") + " on:");
                long total = 0L;
                for (RecordStore<?> store : this) {
                    if (store == null) continue;
                    long highId = store.getHighId();
                    System.err.println("    " + highId + " records from " + store);
                    total += highId;
                }
                return ProgressIndicator.MultiProgress.textual((PrintStream)System.err, (long)total);
            }

            @Override
            protected <R1 extends AbstractBaseRecord, R2 extends AbstractBaseRecord> void report(RecordStore<R1> recordStore, R1 record, RecordStore<? extends R2> referredStore, R2 referred, InconsistencyType inconsistency) {
                System.out.println(record + " " + referred + " //" + inconsistency.message());
            }

            @Override
            protected <R extends AbstractBaseRecord> void report(RecordStore<R> recordStore, R record, InconsistencyType inconsistency) {
                System.out.println(record + " //" + inconsistency.message());
            }
        }.run();
    }

    @Override
    public Iterator<RecordStore<?>> iterator() {
        return Arrays.asList(this.nodes, this.rels, this.props, this.strings, this.arrays, this.propIndexes, this.relTypes, this.propKeys, this.typeNames).iterator();
    }

    public ConsistencyCheck(StoreAccess stores) {
        this(stores, false);
    }

    public ConsistencyCheck(StoreAccess stores, boolean checkPropertyOwners) {
        this.nodes = stores.getNodeStore();
        this.rels = stores.getRelationshipStore();
        this.props = stores.getPropertyStore();
        this.strings = stores.getStringStore();
        this.arrays = stores.getArrayStore();
        this.relTypes = stores.getRelationshipTypeStore();
        this.propIndexes = stores.getPropertyIndexStore();
        this.propKeys = stores.getPropertyKeyStore();
        this.typeNames = stores.getTypeNameStore();
        this.propertyOwners = checkPropertyOwners ? new HashMap() : null;
    }

    boolean propowners() {
        return this.propertyOwners != null;
    }

    @Override
    public void run() {
        ProgressIndicator.MultiProgress progress = this.progressInit();
        this.applyFiltered(this.nodes, (ProgressIndicator)progress, new Predicate[]{RecordStore.IN_USE});
        this.applyFiltered(this.rels, (ProgressIndicator)progress, new Predicate[]{RecordStore.IN_USE});
        if (this.propertyOwners != null) {
            this.propertyOwners.clear();
        }
        this.applyFiltered(this.props, (ProgressIndicator)progress, new Predicate[]{RecordStore.IN_USE});
        if (this.propertyOwners != null) {
            this.propertyOwners.clear();
        }
        this.applyFiltered(this.strings, (ProgressIndicator)progress, new Predicate[]{RecordStore.IN_USE});
        this.applyFiltered(this.arrays, (ProgressIndicator)progress, new Predicate[]{RecordStore.IN_USE});
        this.applyFiltered(this.relTypes, (ProgressIndicator)progress, new Predicate[]{RecordStore.IN_USE});
        this.applyFiltered(this.propIndexes, (ProgressIndicator)progress, new Predicate[]{RecordStore.IN_USE});
        this.applyFiltered(this.propKeys, (ProgressIndicator)progress, new Predicate[]{RecordStore.IN_USE});
        this.applyFiltered(this.typeNames, (ProgressIndicator)progress, new Predicate[]{RecordStore.IN_USE});
        if (progress != null) {
            progress.done();
        }
        this.checkResult();
    }

    ProgressIndicator.MultiProgress progressInit() {
        return null;
    }

    public void checkResult() throws AssertionError {
        if (this.brokenNodes != 0L || this.brokenRels != 0L || this.brokenProps != 0L || this.brokenStrings != 0L || this.brokenArrays != 0L || this.brokenTypes != 0L || this.brokenKeys != 0L) {
            throw new AssertionError((Object)String.format("Store level inconsistency found in %d nodes, %d relationships, %d properties, %d strings, %d arrays, %d types, %d keys", this.brokenNodes, this.brokenRels, this.brokenProps, this.brokenStrings, this.brokenArrays, this.brokenTypes, this.brokenKeys));
        }
    }

    public void processNode(RecordStore<NodeRecord> store, NodeRecord node) {
        if (this.checkNode(node)) {
            ++this.brokenNodes;
        }
    }

    public void processRelationship(RecordStore<RelationshipRecord> store, RelationshipRecord rel) {
        if (this.checkRelationship(rel)) {
            ++this.brokenRels;
        }
    }

    public void processProperty(RecordStore<PropertyRecord> store, PropertyRecord property) {
        if (this.checkProperty(property)) {
            ++this.brokenProps;
        }
    }

    public void processString(RecordStore<DynamicRecord> store, DynamicRecord string) {
        if (this.checkDynamic(store, string)) {
            ++this.brokenStrings;
        }
    }

    public void processArray(RecordStore<DynamicRecord> store, DynamicRecord array) {
        if (this.checkDynamic(store, array)) {
            ++this.brokenArrays;
        }
    }

    public void processRelationshipType(RecordStore<RelationshipTypeRecord> store, RelationshipTypeRecord type) {
        if (this.checkType(type)) {
            ++this.brokenTypes;
        }
    }

    public void processPropertyIndex(RecordStore<PropertyIndexRecord> store, PropertyIndexRecord index) {
        if (this.checkKey(index)) {
            ++this.brokenKeys;
        }
    }

    private boolean checkNode(NodeRecord node) {
        boolean fail = false;
        if (!node.inUse()) {
            NodeRecord old = (NodeRecord)this.nodes.forceGetRaw(node.getId());
            if (old.inUse()) {
                RelationshipRecord rel;
                if (!Record.NO_NEXT_RELATIONSHIP.value(old.getNextRel()) && (rel = (RelationshipRecord)this.rels.forceGetRecord(old.getNextRel())).inUse()) {
                    fail |= this.inconsistent(this.nodes, node, this.rels, rel, InconsistencyType.ReferenceInconsistency.RELATIONSHIP_NOT_REMOVED_FOR_DELETED_NODE);
                }
                fail |= this.checkPropertyReference(node, this.nodes, new OwningNode(node.getId()));
            }
            return fail;
        }
        long relId = node.getNextRel();
        if (!Record.NO_NEXT_RELATIONSHIP.value(relId)) {
            RelationshipRecord rel = (RelationshipRecord)this.rels.forceGetRecord(relId);
            if (!rel.inUse()) {
                fail |= this.inconsistent(this.nodes, node, this.rels, rel, InconsistencyType.ReferenceInconsistency.RELATIONSHIP_NOT_IN_USE);
            } else if (rel.getFirstNode() != node.getId() && rel.getSecondNode() != node.getId()) {
                fail |= this.inconsistent(this.nodes, node, this.rels, rel, InconsistencyType.ReferenceInconsistency.RELATIONSHIP_FOR_OTHER_NODE);
            }
        }
        return fail |= this.checkPropertyReference(node, this.nodes, new OwningNode(node.getId()));
    }

    private <R extends PrimitiveRecord> boolean checkPropertyReference(R primitive, RecordStore<R> store, PropertyOwner owner) {
        boolean fail = false;
        if (this.props != null) {
            PropertyRecord prop;
            PrimitiveRecord old = (PrimitiveRecord)store.forceGetRaw(primitive.getId());
            if (primitive.inUse()) {
                PropertyRecord oldProp;
                if (!Record.NO_NEXT_PROPERTY.value(primitive.getNextProp())) {
                    PropertyRecord prop2 = (PropertyRecord)this.props.forceGetRecord(primitive.getNextProp());
                    fail |= this.checkPropertyOwner(prop2, owner);
                    if (!prop2.inUse()) {
                        fail |= this.inconsistent((RecordStore)store, (AbstractBaseRecord)primitive, (RecordStore)this.props, (AbstractBaseRecord)prop2, InconsistencyType.ReferenceInconsistency.PROPERTY_NOT_IN_USE);
                    } else if (owner.otherOwnerOf(prop2) != -1L || owner.ownerOf(prop2) != -1L && owner.ownerOf(prop2) != primitive.getId()) {
                        fail |= this.inconsistent((RecordStore)store, (AbstractBaseRecord)primitive, (RecordStore)this.props, (AbstractBaseRecord)prop2, InconsistencyType.ReferenceInconsistency.PROPERTY_FOR_OTHER);
                    }
                }
                if (old.inUse() && old.getNextProp() != primitive.getNextProp() && !Record.NO_NEXT_PROPERTY.value(old.getNextProp()) && owner.ownerOf(oldProp = (PropertyRecord)this.props.forceGetRecord(old.getNextProp())) != primitive.getId()) {
                    fail |= this.inconsistent((RecordStore)this.props, (AbstractBaseRecord)oldProp, (RecordStore)store, (AbstractBaseRecord)primitive, InconsistencyType.ReferenceInconsistency.ORPHANED_PROPERTY);
                }
            } else if (!Record.NO_NEXT_PROPERTY.value(old.getNextProp()) && (prop = (PropertyRecord)this.props.forceGetRecord(old.getNextProp())).inUse()) {
                fail |= this.inconsistent((RecordStore)store, (AbstractBaseRecord)primitive, (RecordStore)this.props, (AbstractBaseRecord)prop, owner.propertyNotRemoved());
            }
        }
        return fail;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkRelationship(RelationshipRecord rel) {
        boolean fail = false;
        if (!rel.inUse()) {
            RelationshipRecord old = (RelationshipRecord)this.rels.forceGetRaw(rel.getId());
            if (old.inUse()) {
                void var6_10;
                RelationshipField[] arr$ = relFields;
                int len$ = arr$.length;
                boolean bl = false;
                while (var6_10 < len$) {
                    RelationshipField field = arr$[var6_10];
                    long otherId = field.relOf(old);
                    if (otherId == field.none) {
                        NodeRecord node;
                        Long nodeId = field.nodeOf(old);
                        if (nodeId != null && (node = (NodeRecord)this.nodes.forceGetRecord(nodeId.longValue())).inUse() && node.getNextRel() == old.getId()) {
                            fail |= this.inconsistent(this.rels, rel, this.nodes, node, InconsistencyType.ReferenceInconsistency.REMOVED_RELATIONSHIP_STILL_REFERENCED);
                        }
                    } else {
                        RelationshipRecord other = (RelationshipRecord)this.rels.forceGetRecord(otherId);
                        if (other.inUse() && field.invConsistent(old, other)) {
                            fail |= this.inconsistent(this.rels, rel, other, InconsistencyType.ReferenceInconsistency.REMOVED_RELATIONSHIP_STILL_REFERENCED);
                        }
                    }
                    ++var6_10;
                }
                fail |= this.checkPropertyReference(rel, this.rels, new OwningRelationship(rel.getId()));
            }
            return fail;
        }
        if (rel.getType() < 0) {
            fail |= this.inconsistent(this.rels, rel, InconsistencyType.ReferenceInconsistency.INVALID_TYPE_ID);
        } else {
            RelationshipTypeRecord type = (RelationshipTypeRecord)this.relTypes.forceGetRecord((long)rel.getType());
            if (!type.inUse()) {
                fail |= this.inconsistent(this.rels, rel, this.relTypes, type, InconsistencyType.ReferenceInconsistency.TYPE_NOT_IN_USE);
            }
        }
        for (RelationshipField relationshipField : relFields) {
            long otherId = relationshipField.relOf(rel);
            if (otherId == relationshipField.none) {
                NodeRecord node;
                Long nodeId = relationshipField.nodeOf(rel);
                if (nodeId == null || (node = (NodeRecord)this.nodes.forceGetRecord(nodeId.longValue())).inUse() && node.getNextRel() == rel.getId()) continue;
                fail |= this.inconsistent(this.rels, rel, this.nodes, node, relationshipField.noBackReference);
                continue;
            }
            RelationshipRecord other = (RelationshipRecord)this.rels.forceGetRecord(otherId);
            if (!other.inUse()) {
                fail |= this.inconsistent(this.rels, rel, other, relationshipField.notInUse);
                continue;
            }
            if (relationshipField.invConsistent(rel, other)) continue;
            fail |= this.inconsistent(this.rels, rel, other, relationshipField.differentChain);
        }
        for (Enum enum_ : nodeFields) {
            long nodeId = ((NodeField)enum_).get(rel);
            if (nodeId < 0L) {
                fail |= this.inconsistent(this.rels, rel, ((NodeField)enum_).invalidReference);
                continue;
            }
            NodeRecord node = (NodeRecord)this.nodes.forceGetRecord(nodeId);
            if (node.inUse()) continue;
            fail |= this.inconsistent(this.rels, rel, this.nodes, node, ((NodeField)enum_).notInUse);
        }
        return fail |= this.checkPropertyReference(rel, this.rels, new OwningRelationship(rel.getId()));
    }

    private boolean checkPropertyOwner(PropertyRecord prop, PropertyOwner newOwner) {
        if (this.propertyOwners == null) {
            return false;
        }
        Long propId = prop.getId();
        PropertyOwner oldOwner = this.propertyOwners.put(propId, newOwner);
        if (oldOwner != null) {
            RecordStore<? extends PrimitiveRecord> oldStore = oldOwner.storeFrom(this);
            RecordStore<? extends PrimitiveRecord> newStore = newOwner.storeFrom(this);
            return this.inconsistent(oldStore, oldStore.getRecord(oldOwner.id), newStore, newStore.getRecord(newOwner.id), InconsistencyType.PropertyOwnerInconsistency.OwnerInconsistencyType.MULTIPLE_OWNERS.forProperty(prop));
        }
        return false;
    }

    private boolean checkProperty(PropertyRecord property) {
        long prevId;
        boolean fail = false;
        if (!property.inUse()) {
            PropertyRecord old = (PropertyRecord)this.props.forceGetRaw(property.getId());
            if (old.inUse()) {
                PropertyRecord next;
                if (!Record.NO_NEXT_PROPERTY.value(old.getNextProp()) && (next = (PropertyRecord)this.props.forceGetRecord(old.getNextProp())).inUse() && next.getPrevProp() == old.getId()) {
                    fail |= this.inconsistent(this.props, property, next, InconsistencyType.ReferenceInconsistency.REMOVED_PROPERTY_STILL_REFERENCED);
                }
                if (!Record.NO_PREVIOUS_PROPERTY.value(old.getPrevProp())) {
                    PropertyRecord prev = (PropertyRecord)this.props.forceGetRecord(old.getPrevProp());
                    if (prev.inUse() && prev.getNextProp() == old.getId()) {
                        fail |= this.inconsistent(this.props, property, prev, InconsistencyType.ReferenceInconsistency.REMOVED_PROPERTY_STILL_REFERENCED);
                    }
                } else if (property.getNodeId() != -1L) {
                    fail |= this.checkPropertyOwnerReference(property, property.getNodeId(), this.nodes);
                } else if (property.getRelId() != -1L) {
                    fail |= this.checkPropertyOwnerReference(property, property.getRelId(), this.rels);
                } else if (((DiffRecordStore)this.props).isModified(property.getId())) {
                    fail |= this.inconsistent(this.props, property, InconsistencyType.ReferenceInconsistency.PROPERTY_CHANGED_WITHOUT_OWNER);
                }
                fail |= this.checkOwnerChain(property);
            }
            return fail;
        }
        long nextId = property.getNextProp();
        if (!Record.NO_NEXT_PROPERTY.value(nextId)) {
            PropertyRecord next = (PropertyRecord)this.props.forceGetRecord(nextId);
            if (!next.inUse()) {
                fail |= this.inconsistent(this.props, property, next, InconsistencyType.ReferenceInconsistency.NEXT_PROPERTY_NOT_IN_USE);
            }
            if (next.getPrevProp() != property.getId()) {
                fail |= this.inconsistent(this.props, property, next, InconsistencyType.ReferenceInconsistency.PROPERTY_NEXT_WRONG_BACKREFERENCE);
            }
        }
        if (!Record.NO_PREVIOUS_PROPERTY.value(prevId = property.getPrevProp())) {
            PropertyRecord prev = (PropertyRecord)this.props.forceGetRecord(prevId);
            if (!prev.inUse()) {
                fail |= this.inconsistent(this.props, property, prev, InconsistencyType.ReferenceInconsistency.PREV_PROPERTY_NOT_IN_USE);
            }
            if (prev.getNextProp() != property.getId()) {
                fail |= this.inconsistent(this.props, property, prev, InconsistencyType.ReferenceInconsistency.PROPERTY_PREV_WRONG_BACKREFERENCE);
            }
        } else if (property.getNodeId() != -1L) {
            fail |= this.checkPropertyOwnerReference(property, property.getNodeId(), this.nodes);
        } else if (property.getRelId() != -1L) {
            fail |= this.checkPropertyOwnerReference(property, property.getRelId(), this.rels);
        } else if (this.props instanceof DiffRecordStore && ((DiffRecordStore)this.props).isModified(property.getId())) {
            fail |= this.inconsistent(this.props, property, InconsistencyType.ReferenceInconsistency.PROPERTY_CHANGED_WITHOUT_OWNER);
        }
        fail |= this.checkOwnerChain(property);
        for (PropertyBlock block : property.getPropertyBlocks()) {
            DynamicRecord dynrec;
            if (block.getKeyIndexId() < 0) {
                fail |= this.inconsistent(this.props, property, InconsistencyType.PropertyBlockInconsistency.BlockInconsistencyType.INVALID_PROPERTY_KEY.forBlock(block));
            } else {
                PropertyIndexRecord key = (PropertyIndexRecord)this.propIndexes.forceGetRecord((long)block.getKeyIndexId());
                if (!key.inUse()) {
                    fail |= this.inconsistent(this.props, property, this.propIndexes, key, InconsistencyType.PropertyBlockInconsistency.BlockInconsistencyType.UNUSED_PROPERTY_KEY.forBlock(block));
                }
            }
            RecordStore<DynamicRecord> dynStore = null;
            PropertyType type = block.forceGetType();
            if (type == null) {
                fail |= this.inconsistent(this.props, property, InconsistencyType.PropertyBlockInconsistency.BlockInconsistencyType.ILLEGAL_PROPERTY_TYPE.forBlock(block));
            } else {
                switch (block.getType()) {
                    case STRING: {
                        dynStore = this.strings;
                        break;
                    }
                    case ARRAY: {
                        dynStore = this.arrays;
                    }
                }
            }
            if (dynStore == null || (dynrec = (DynamicRecord)dynStore.forceGetRecord(block.getSingleValueLong())).inUse()) continue;
            fail |= this.inconsistent(this.props, property, dynStore, dynrec, InconsistencyType.PropertyBlockInconsistency.BlockInconsistencyType.DYNAMIC_NOT_IN_USE.forBlock(block));
        }
        return fail;
    }

    private boolean checkOwnerChain(PropertyRecord property) {
        boolean fail = false;
        RecordStore<NodeRecord> store = null;
        long ownerId = -1L;
        if (property.getNodeId() != -1L) {
            store = this.nodes;
            ownerId = property.getNodeId();
        } else if (property.getRelId() != -1L) {
            store = this.rels;
            ownerId = property.getRelId();
        }
        if (store != null) {
            PrimitiveRecord owner = property.inUse() ? (PrimitiveRecord)store.forceGetRecord(ownerId) : (PrimitiveRecord)store.forceGetRaw(ownerId);
            ArrayList<PropertyRecord> chain = new ArrayList<PropertyRecord>(2);
            PropertyRecord prop = null;
            long propId = owner.getNextProp();
            long target = property.getId();
            while (propId != target) {
                if (Record.NO_NEXT_PROPERTY.value(propId)) {
                    fail |= this.inconsistent(this.props, property, store, owner, InconsistencyType.PropertyOwnerInconsistency.OwnerInconsistencyType.PROPERTY_CHANGED_FOR_WRONG_OWNER.forProperties(chain));
                    break;
                }
                prop = property.inUse() ? (PropertyRecord)this.props.forceGetRecord(propId) : (PropertyRecord)this.props.forceGetRaw(propId);
                chain.add(prop);
                propId = prop.getNextProp();
            }
        } else if (this.props instanceof DiffRecordStore && ((DiffRecordStore)this.props).isModified(property.getId())) {
            fail |= this.inconsistent(this.props, property, InconsistencyType.ReferenceInconsistency.PROPERTY_CHANGED_WITHOUT_OWNER);
        }
        return fail;
    }

    private boolean checkPropertyOwnerReference(PropertyRecord property, long ownerId, RecordStore<? extends PrimitiveRecord> entityStore) {
        PrimitiveRecord old;
        DiffRecordStore diffs;
        boolean fail = false;
        PrimitiveRecord entity = (PrimitiveRecord)entityStore.forceGetRecord(ownerId);
        if (!property.inUse()) {
            if (entity.inUse() && entity.getNextProp() == property.getId()) {
                fail |= this.inconsistent(this.props, property, entityStore, entity, InconsistencyType.ReferenceInconsistency.REMOVED_PROPERTY_STILL_REFERENCED);
            }
            return fail;
        }
        if (!entity.inUse()) {
            fail |= this.inconsistent(this.props, property, entityStore, entity, InconsistencyType.ReferenceInconsistency.OWNER_NOT_IN_USE);
        } else if (entity.getNextProp() != property.getId()) {
            fail |= this.inconsistent(this.props, property, entityStore, entity, InconsistencyType.ReferenceInconsistency.OWNER_DOES_NOT_REFERENCE_BACK);
        }
        if (entityStore instanceof DiffRecordStore && (diffs = (DiffRecordStore)entityStore).isModified(entity.getId()) && (old = (PrimitiveRecord)diffs.forceGetRaw(entity.getId())).inUse() && !Record.NO_NEXT_PROPERTY.value(old.getNextProp()) && old.getNextProp() != property.getId() && !((DiffRecordStore)this.props).isModified(old.getNextProp())) {
            fail |= this.inconsistent(this.props, property, entityStore, entity, InconsistencyType.ReferenceInconsistency.REPLACED_PROPERTY);
        }
        return fail;
    }

    private boolean checkDynamic(RecordStore<DynamicRecord> store, DynamicRecord record) {
        DynamicRecord prev;
        DiffRecordStore diffs;
        boolean fail = false;
        if (!record.inUse()) {
            DynamicRecord next;
            DynamicRecord old;
            if (store instanceof DiffRecordStore && (old = (DynamicRecord)store.forceGetRaw(record.getId())).inUse() && !Record.NO_NEXT_BLOCK.value(old.getNextBlock()) && (next = (DynamicRecord)store.forceGetRecord(old.getNextBlock())).inUse()) {
                fail |= this.inconsistent(store, record, next, InconsistencyType.ReferenceInconsistency.NEXT_DYNAMIC_NOT_REMOVED);
            }
            return fail;
        }
        long nextId = record.getNextBlock();
        if (!Record.NO_NEXT_BLOCK.value(nextId)) {
            DynamicRecord next = (DynamicRecord)store.forceGetRecord(nextId);
            if (!next.inUse()) {
                fail |= this.inconsistent(store, record, next, InconsistencyType.ReferenceInconsistency.NEXT_DYNAMIC_NOT_IN_USE);
            }
            if (record.getLength() < store.getRecordSize() - store.getRecordHeaderSize()) {
                fail |= this.inconsistent(store, record, InconsistencyType.ReferenceInconsistency.NON_FULL_DYNAMIC_WITH_NEXT);
            }
        }
        if (record.getId() != 0L && record.getLength() > store.getRecordSize() - store.getRecordHeaderSize()) {
            fail |= this.inconsistent(store, record, InconsistencyType.ReferenceInconsistency.DYNAMIC_LENGTH_TOO_LARGE);
        }
        if (store instanceof DiffRecordStore && (diffs = (DiffRecordStore)store).isModified(record.getId()) && !record.isLight() && (prev = (DynamicRecord)diffs.forceGetRaw(record.getId())).inUse()) {
            fail |= this.inconsistent(store, record, prev, InconsistencyType.ReferenceInconsistency.OVERWRITE_USED_DYNAMIC);
        }
        return fail;
    }

    private boolean checkType(RelationshipTypeRecord type) {
        if (!type.inUse()) {
            return false;
        }
        if (Record.NO_NEXT_BLOCK.value((long)type.getNameId())) {
            return false;
        }
        DynamicRecord record = (DynamicRecord)this.typeNames.forceGetRecord((long)type.getNameId());
        if (!record.inUse()) {
            return this.inconsistent(this.relTypes, type, this.typeNames, record, InconsistencyType.ReferenceInconsistency.UNUSED_TYPE_NAME);
        }
        return false;
    }

    private boolean checkKey(PropertyIndexRecord key) {
        if (!key.inUse()) {
            return false;
        }
        if (Record.NO_NEXT_BLOCK.value((long)key.getNameId())) {
            return false;
        }
        DynamicRecord record = (DynamicRecord)this.propKeys.forceGetRecord((long)key.getNameId());
        if (!record.inUse()) {
            return this.inconsistent(this.propIndexes, key, this.propKeys, record, InconsistencyType.ReferenceInconsistency.UNUSED_KEY_NAME);
        }
        return false;
    }

    private <R1 extends AbstractBaseRecord, R2 extends AbstractBaseRecord> boolean inconsistent(RecordStore<R1> recordStore, R1 record, RecordStore<? extends R2> referredStore, R2 referred, InconsistencyType type) {
        this.report(recordStore, record, referredStore, referred, type);
        return !type.isWarning();
    }

    private <R extends AbstractBaseRecord> boolean inconsistent(RecordStore<R> store, R record, R referred, InconsistencyType type) {
        this.report(store, record, store, referred, type);
        return !type.isWarning();
    }

    private <R extends AbstractBaseRecord> boolean inconsistent(RecordStore<R> store, R record, InconsistencyType type) {
        this.report(store, record, type);
        return !type.isWarning();
    }

    protected abstract <R1 extends AbstractBaseRecord, R2 extends AbstractBaseRecord> void report(RecordStore<R1> var1, R1 var2, RecordStore<? extends R2> var3, R2 var4, InconsistencyType var5);

    protected abstract <R extends AbstractBaseRecord> void report(RecordStore<R> var1, R var2, InconsistencyType var3);

    private static enum RelationshipField {
        FIRST_NEXT(true, Record.NO_NEXT_RELATIONSHIP, InconsistencyType.ReferenceInconsistency.SOURCE_NEXT_NOT_IN_USE, null, InconsistencyType.ReferenceInconsistency.SOURCE_NEXT_DIFFERENT_CHAIN){

            @Override
            long relOf(RelationshipRecord rel) {
                return rel.getFirstNextRel();
            }

            @Override
            boolean invConsistent(RelationshipRecord rel, RelationshipRecord other) {
                long node = this.getNode(rel);
                if (other.getFirstNode() == node) {
                    return other.getFirstPrevRel() == rel.getId();
                }
                if (other.getSecondNode() == node) {
                    return other.getSecondPrevRel() == rel.getId();
                }
                return false;
            }
        }
        ,
        FIRST_PREV(true, Record.NO_PREV_RELATIONSHIP, InconsistencyType.ReferenceInconsistency.SOURCE_PREV_NOT_IN_USE, InconsistencyType.ReferenceInconsistency.SOURCE_NO_BACKREF, InconsistencyType.ReferenceInconsistency.SOURCE_PREV_DIFFERENT_CHAIN){

            @Override
            long relOf(RelationshipRecord rel) {
                return rel.getFirstPrevRel();
            }

            @Override
            Long nodeOf(RelationshipRecord rel) {
                return this.getNode(rel);
            }

            @Override
            boolean invConsistent(RelationshipRecord rel, RelationshipRecord other) {
                long node = this.getNode(rel);
                if (other.getFirstNode() == node) {
                    return other.getFirstNextRel() == rel.getId();
                }
                if (other.getSecondNode() == node) {
                    return other.getSecondNextRel() == rel.getId();
                }
                return false;
            }
        }
        ,
        SECOND_NEXT(false, Record.NO_NEXT_RELATIONSHIP, InconsistencyType.ReferenceInconsistency.TARGET_NEXT_NOT_IN_USE, null, InconsistencyType.ReferenceInconsistency.TARGET_NEXT_DIFFERENT_CHAIN){

            @Override
            long relOf(RelationshipRecord rel) {
                return rel.getSecondNextRel();
            }

            @Override
            boolean invConsistent(RelationshipRecord rel, RelationshipRecord other) {
                long node = this.getNode(rel);
                if (other.getFirstNode() == node) {
                    return other.getFirstPrevRel() == rel.getId();
                }
                if (other.getSecondNode() == node) {
                    return other.getSecondPrevRel() == rel.getId();
                }
                return false;
            }
        }
        ,
        SECOND_PREV(false, Record.NO_PREV_RELATIONSHIP, InconsistencyType.ReferenceInconsistency.TARGET_PREV_NOT_IN_USE, InconsistencyType.ReferenceInconsistency.TARGET_NO_BACKREF, InconsistencyType.ReferenceInconsistency.TARGET_PREV_DIFFERENT_CHAIN){

            @Override
            long relOf(RelationshipRecord rel) {
                return rel.getSecondPrevRel();
            }

            @Override
            Long nodeOf(RelationshipRecord rel) {
                return this.getNode(rel);
            }

            @Override
            boolean invConsistent(RelationshipRecord rel, RelationshipRecord other) {
                long node = this.getNode(rel);
                if (other.getFirstNode() == node) {
                    return other.getFirstNextRel() == rel.getId();
                }
                if (other.getSecondNode() == node) {
                    return other.getSecondNextRel() == rel.getId();
                }
                return false;
            }
        };

        private final InconsistencyType.ReferenceInconsistency notInUse;
        private final InconsistencyType.ReferenceInconsistency noBackReference;
        private final InconsistencyType.ReferenceInconsistency differentChain;
        private final boolean first;
        final long none;

        private RelationshipField(boolean first, Record none, InconsistencyType.ReferenceInconsistency notInUse, InconsistencyType.ReferenceInconsistency noBackReference, InconsistencyType.ReferenceInconsistency differentChain) {
            this.first = first;
            this.none = none.intValue();
            this.notInUse = notInUse;
            this.noBackReference = noBackReference;
            this.differentChain = differentChain;
        }

        abstract boolean invConsistent(RelationshipRecord var1, RelationshipRecord var2);

        long getNode(RelationshipRecord rel) {
            return this.first ? rel.getFirstNode() : rel.getSecondNode();
        }

        abstract long relOf(RelationshipRecord var1);

        Long nodeOf(RelationshipRecord rel) {
            return null;
        }
    }

    private static enum NodeField {
        FIRST(InconsistencyType.ReferenceInconsistency.SOURCE_NODE_INVALID, InconsistencyType.ReferenceInconsistency.SOURCE_NODE_NOT_IN_USE){

            @Override
            long get(RelationshipRecord rel) {
                return rel.getFirstNode();
            }
        }
        ,
        SECOND(InconsistencyType.ReferenceInconsistency.TARGET_NODE_INVALID, InconsistencyType.ReferenceInconsistency.TARGET_NODE_NOT_IN_USE){

            @Override
            long get(RelationshipRecord rel) {
                return rel.getSecondNode();
            }
        };

        private final InconsistencyType.ReferenceInconsistency invalidReference;
        private final InconsistencyType.ReferenceInconsistency notInUse;

        abstract long get(RelationshipRecord var1);

        private NodeField(InconsistencyType.ReferenceInconsistency invalidReference, InconsistencyType.ReferenceInconsistency notInUse) {
            this.invalidReference = invalidReference;
            this.notInUse = notInUse;
        }
    }

    private static final class OwningRelationship
    extends PropertyOwner {
        OwningRelationship(long id) {
            super(id);
        }

        @Override
        RecordStore<? extends PrimitiveRecord> storeFrom(ConsistencyCheck tool) {
            return tool.rels;
        }

        @Override
        InconsistencyType propertyNotRemoved() {
            return InconsistencyType.ReferenceInconsistency.PROPERTY_NOT_REMOVED_FOR_DELETED_RELATIONSHIP;
        }

        @Override
        long otherOwnerOf(PropertyRecord prop) {
            return prop.getNodeId();
        }

        @Override
        long ownerOf(PropertyRecord prop) {
            return prop.getRelId();
        }
    }

    private static final class OwningNode
    extends PropertyOwner {
        OwningNode(long id) {
            super(id);
        }

        @Override
        RecordStore<? extends PrimitiveRecord> storeFrom(ConsistencyCheck tool) {
            return tool.nodes;
        }

        @Override
        InconsistencyType propertyNotRemoved() {
            return InconsistencyType.ReferenceInconsistency.PROPERTY_NOT_REMOVED_FOR_DELETED_NODE;
        }

        @Override
        long otherOwnerOf(PropertyRecord prop) {
            return prop.getRelId();
        }

        @Override
        long ownerOf(PropertyRecord prop) {
            return prop.getNodeId();
        }
    }

    private static abstract class PropertyOwner {
        final long id;

        PropertyOwner(long id) {
            this.id = id;
        }

        abstract RecordStore<? extends PrimitiveRecord> storeFrom(ConsistencyCheck var1);

        abstract long otherOwnerOf(PropertyRecord var1);

        abstract long ownerOf(PropertyRecord var1);

        abstract InconsistencyType propertyNotRemoved();
    }
}

