/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.check;

import java.util.Collection;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;

public interface InconsistencyType {
    public String message();

    public boolean isWarning();

    public static class PropertyBlockInconsistency
    implements InconsistencyType {
        private final BlockInconsistencyType type;
        private final PropertyBlock block;

        private PropertyBlockInconsistency(BlockInconsistencyType type, PropertyBlock block) {
            this.type = type;
            this.block = block;
        }

        @Override
        public String message() {
            return this.type.message + this.block;
        }

        @Override
        public boolean isWarning() {
            return false;
        }

        public static enum BlockInconsistencyType {
            INVALID_PROPERTY_KEY("invalid key id of "),
            UNUSED_PROPERTY_KEY("key not in use for "),
            ILLEGAL_PROPERTY_TYPE("illegal property type for "),
            DYNAMIC_NOT_IN_USE("first dynamic record not in use for ");

            private final String message;

            private BlockInconsistencyType(String message) {
                this.message = message;
            }

            public InconsistencyType forBlock(PropertyBlock block) {
                return new PropertyBlockInconsistency(this, block);
            }
        }
    }

    public static class PropertyOwnerInconsistency
    implements InconsistencyType {
        private final OwnerInconsistencyType type;
        private final PropertyRecord[] properties;

        private PropertyOwnerInconsistency(OwnerInconsistencyType type, PropertyRecord ... properties) {
            this.type = type;
            this.properties = properties;
        }

        @Override
        public String message() {
            StringBuilder message = new StringBuilder(this.type.message);
            for (int i = 0; i < this.properties.length; ++i) {
                if (i > 0) {
                    message.append("\n\t");
                }
                message.append(this.properties[i]);
            }
            return message.toString();
        }

        @Override
        public boolean isWarning() {
            return false;
        }

        public static enum OwnerInconsistencyType {
            MULTIPLE_OWNERS("multiple owners for "),
            PROPERTY_CHANGED_FOR_WRONG_OWNER("property changed claimed an owner that did not contain the property record in its chain:\n\t");

            private final String message;

            private OwnerInconsistencyType(String message) {
                this.message = message;
            }

            public InconsistencyType forProperties(Collection<PropertyRecord> properties) {
                return new PropertyOwnerInconsistency(this, properties.toArray(new PropertyRecord[properties.size()]));
            }

            public InconsistencyType forProperty(PropertyRecord property) {
                return new PropertyOwnerInconsistency(this, new PropertyRecord[]{property});
            }
        }
    }

    public static enum ReferenceInconsistency implements InconsistencyType
    {
        INVALID_TYPE_ID("invalid relationship type id"),
        TYPE_NOT_IN_USE("relationship type not in use"),
        RELATIONSHIP_NOT_IN_USE("reference to relationship not in use"),
        RELATIONSHIP_FOR_OTHER_NODE("reference to relationship that does not reference back"),
        PROPERTY_NOT_IN_USE("reference to property not in use"),
        PROPERTY_FOR_OTHER("reference to property for other entity"),
        NEXT_PROPERTY_NOT_IN_USE("invalid next reference, next record not in use"),
        PROPERTY_NEXT_WRONG_BACKREFERENCE("invalid next reference, next record does not reference back"),
        PREV_PROPERTY_NOT_IN_USE("invalid prev reference, prev record not in use"),
        PROPERTY_PREV_WRONG_BACKREFERENCE("invalid prev reference, prev record does not reference back"),
        ORPHANED_PROPERTY("property record does not have a referencing node or relationship"),
        OWNER_NOT_IN_USE("owning record not in use"),
        OWNER_DOES_NOT_REFERENCE_BACK("owning record does not reference back"),
        REPLACED_PROPERTY("replacing used property record"),
        NEXT_DYNAMIC_NOT_IN_USE("next dynamic record not in use"),
        NON_FULL_DYNAMIC_WITH_NEXT("next record set, but length less than maximum"),
        DYNAMIC_LENGTH_TOO_LARGE("length larger than maximum for store"),
        OVERWRITE_USED_DYNAMIC("overwriting used dynamic record"),
        UNUSED_TYPE_NAME("reference to unused type name"),
        UNUSED_KEY_NAME("reference to unused key string"),
        SOURCE_NODE_INVALID("invalid source node reference"),
        SOURCE_NODE_NOT_IN_USE("invalid source node reference, not in use"),
        TARGET_NODE_INVALID("invalid target node reference"),
        TARGET_NODE_NOT_IN_USE("invalid target node reference, not in use"),
        TARGET_PREV_NOT_IN_USE("prev(target) reference to record not used"),
        TARGET_NO_BACKREF("relationship first in target chain, but target node does not reference back"),
        TARGET_PREV_DIFFERENT_CHAIN("not part of the same chain, invalid prev(target) reference"),
        SOURCE_PREV_NOT_IN_USE("prev(target) reference to record not used"),
        SOURCE_NO_BACKREF("relationship first in source chain, but source node does not reference back"),
        SOURCE_PREV_DIFFERENT_CHAIN("not part of the same chain, invalid prev(source) reference"),
        TARGET_NEXT_NOT_IN_USE("prev(target) reference to record not used"),
        TARGET_NEXT_DIFFERENT_CHAIN("not part of the same chain, invalid next(target) reference"),
        SOURCE_NEXT_NOT_IN_USE("prev(target) reference to record not used"),
        SOURCE_NEXT_DIFFERENT_CHAIN("not part of the same chain, invalid next(source) reference"),
        PROPERTY_CHANGED_WITHOUT_OWNER(true, "the property record was changed but did not have an owning node or relationship"),
        RELATIONSHIP_NOT_REMOVED_FOR_DELETED_NODE("node was deleted but relationship was not removed"),
        PROPERTY_NOT_REMOVED_FOR_DELETED_NODE("node was deleted but property was not removed"),
        PROPERTY_NOT_REMOVED_FOR_DELETED_RELATIONSHIP("relationship was deleted but property was not removed"),
        REMOVED_RELATIONSHIP_STILL_REFERENCED("removed relationship record still referenced"),
        REMOVED_PROPERTY_STILL_REFERENCED("removed property record still referenced"),
        NEXT_DYNAMIC_NOT_REMOVED("dynamic record removed, but next referenced in chain still in use");

        private final String message;
        private final boolean warning;

        private ReferenceInconsistency(String message) {
            this.warning = false;
            this.message = message;
        }

        private ReferenceInconsistency(boolean warning, String message) {
            this.warning = warning;
            this.message = message;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public boolean isWarning() {
            return this.warning;
        }
    }
}

