/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.log;

import java.io.File;
import java.util.Map;
import org.neo4j.backup.check.ConsistencyCheck;
import org.neo4j.backup.check.DiffRecordStore;
import org.neo4j.backup.check.DiffStore;
import org.neo4j.backup.check.InconsistencyType;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DataInconsistencyError;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.util.StringLogger;

class VerifyingTransactionInterceptor
implements TransactionInterceptor {
    private final boolean rejectInconsistentTransactions;
    private final DiffStore diffs;
    private final StringLogger msgLog;
    private LogEntry.Commit commitEntry;
    private LogEntry.Start startEntry;
    private TransactionInterceptor next;
    private final CheckerMode mode;
    private final StringLogger difflog;

    VerifyingTransactionInterceptor(NeoStoreXaDataSource ds, StringLogger stringLogger, CheckerMode mode, boolean rejectInconsistentTransactions, Map<String, String> extraConfig) {
        this.rejectInconsistentTransactions = rejectInconsistentTransactions;
        this.diffs = new DiffStore(ds.getNeoStore());
        this.msgLog = stringLogger;
        this.mode = mode;
        String log = extraConfig.get("log");
        this.difflog = log == null ? null : ("true".equalsIgnoreCase(log) ? this.msgLog : StringLogger.logger((File)new File(log)));
    }

    public void setStartEntry(LogEntry.Start startEntry) {
        this.startEntry = startEntry;
        if (this.next != null) {
            this.next.setStartEntry(startEntry);
        }
    }

    public void setCommitEntry(LogEntry.Commit commitEntry) {
        this.commitEntry = commitEntry;
        if (this.next != null) {
            this.next.setCommitEntry(commitEntry);
        }
    }

    public void setNext(TransactionInterceptor next) {
        this.next = next;
    }

    public void complete() throws DataInconsistencyError {
        DataInconsistencyError error;
        block8: {
            ConsistencyCheck consistency = this.mode.apply(this.diffs, new ConsistencyCheck(this.diffs, this.mode.checkProp){

                @Override
                protected <R extends AbstractBaseRecord> void report(RecordStore<R> recordStore, R record, InconsistencyType inconsistency) {
                    if (inconsistency.isWarning()) {
                        return;
                    }
                    StringBuilder log = VerifyingTransactionInterceptor.this.messageHeader("Inconsistencies").append("\n\t");
                    VerifyingTransactionInterceptor.logRecord(log, recordStore, record);
                    log.append(inconsistency.message());
                    VerifyingTransactionInterceptor.this.msgLog.logMessage(log.toString());
                    if (VerifyingTransactionInterceptor.this.difflog != null && VerifyingTransactionInterceptor.this.difflog != VerifyingTransactionInterceptor.this.msgLog) {
                        VerifyingTransactionInterceptor.this.difflog.logMessage(log.toString());
                    }
                }

                @Override
                protected <R1 extends AbstractBaseRecord, R2 extends AbstractBaseRecord> void report(RecordStore<R1> recordStore, R1 record, RecordStore<? extends R2> referredStore, R2 referred, InconsistencyType inconsistency) {
                    if (inconsistency.isWarning()) {
                        return;
                    }
                    if (recordStore == referredStore && record.getLongId() == referred.getLongId()) {
                        this.report(recordStore, record, inconsistency);
                        return;
                    }
                    StringBuilder log = VerifyingTransactionInterceptor.this.messageHeader("Inconsistencies").append("\n\t");
                    VerifyingTransactionInterceptor.logRecord(log, recordStore, record);
                    VerifyingTransactionInterceptor.logRecord(log, referredStore, referred);
                    log.append(inconsistency.message());
                    VerifyingTransactionInterceptor.this.msgLog.logMessage(log.toString());
                    if (VerifyingTransactionInterceptor.this.difflog != null && VerifyingTransactionInterceptor.this.difflog != VerifyingTransactionInterceptor.this.msgLog) {
                        VerifyingTransactionInterceptor.this.difflog.logMessage(log.toString());
                    }
                }
            });
            error = null;
            try {
                consistency.checkResult();
            }
            catch (AssertionError e) {
                error = new DataInconsistencyError("Inconsistencies in transaction\n\t" + (this.startEntry == null ? "NO START ENTRY" : this.startEntry.toString()) + "\n\t" + (this.commitEntry == null ? "NO COMMIT ENTRY" : this.commitEntry.toString()) + "\n\t" + ((Throwable)((Object)e)).getMessage());
                this.msgLog.logMessage(error.getMessage());
                if (this.difflog == null || this.difflog == this.msgLog) break block8;
                this.difflog.logMessage(error.getMessage());
            }
        }
        if (this.difflog != null || error != null) {
            final String header = this.messageHeader("Changes").toString();
            StringLogger target = null;
            Object visitor = null;
            if (error != null) {
                target = this.msgLog;
                visitor = this.difflog != null && this.difflog != this.msgLog ? new Visitor<StringLogger.LineLogger>(){

                    public boolean visit(final StringLogger.LineLogger first) {
                        VerifyingTransactionInterceptor.this.difflog.logLongMessage(header, (Visitor)new Visitor<StringLogger.LineLogger>(){

                            public boolean visit(final StringLogger.LineLogger other) {
                                other.logLine(VerifyingTransactionInterceptor.this.startEntry == null ? "NO START ENTRY" : VerifyingTransactionInterceptor.this.startEntry.toString());
                                other.logLine(VerifyingTransactionInterceptor.this.commitEntry == null ? "NO COMMIT ENTRY" : VerifyingTransactionInterceptor.this.commitEntry.toString());
                                VerifyingTransactionInterceptor.this.logDiffLines(new StringLogger.LineLogger(){

                                    public void logLine(String line) {
                                        first.logLine(line);
                                        other.logLine(line);
                                    }
                                });
                                return false;
                            }
                        });
                        return false;
                    }
                } : new Visitor<StringLogger.LineLogger>(){

                    public boolean visit(StringLogger.LineLogger lines) {
                        VerifyingTransactionInterceptor.this.logDiffLines(lines);
                        return false;
                    }
                };
            } else {
                target = this.difflog;
                visitor = new Visitor<StringLogger.LineLogger>(){

                    public boolean visit(StringLogger.LineLogger lines) {
                        lines.logLine(VerifyingTransactionInterceptor.this.startEntry == null ? "NO START ENTRY" : VerifyingTransactionInterceptor.this.startEntry.toString());
                        lines.logLine(VerifyingTransactionInterceptor.this.commitEntry == null ? "NO COMMIT ENTRY" : VerifyingTransactionInterceptor.this.commitEntry.toString());
                        VerifyingTransactionInterceptor.this.logDiffLines(lines);
                        return false;
                    }
                };
            }
            target.logLongMessage(header, (Visitor)visitor);
        }
        if (this.difflog != null) {
            this.difflog.close();
        }
        if (error != null && this.rejectInconsistentTransactions) {
            throw error;
        }
        if (this.next != null) {
            this.next.complete();
        }
    }

    private void logDiffLines(final StringLogger.LineLogger logger) {
        this.diffs.applyToAll(new RecordStore.Processor(){

            protected <R extends AbstractBaseRecord> void processRecord(Class<R> type, RecordStore<R> store, R record) {
                DiffRecordStore diff = (DiffRecordStore)store;
                if (diff.isModified(record.getLongId())) {
                    VerifyingTransactionInterceptor.logRecord(logger, store, record);
                }
            }
        });
        for (RecordStore<?> store : this.diffs.allStores()) {
            logger.logLine(store + ": highId(before) = " + ((DiffRecordStore)store).getRawHighId() + ", highId(after) = " + store.getHighId());
        }
    }

    private static <R extends AbstractBaseRecord> void logRecord(final StringBuilder log, RecordStore<? extends R> store, R record) {
        VerifyingTransactionInterceptor.logRecord(new StringLogger.LineLogger(){

            public void logLine(String line) {
                log.append(line).append("\n\t");
            }
        }, store, record);
    }

    private static <R extends AbstractBaseRecord> void logRecord(StringLogger.LineLogger log, RecordStore<? extends R> store, R record) {
        DiffRecordStore diff = (DiffRecordStore)store;
        String prefix = "";
        if (diff.isModified(record.getLongId())) {
            log.logLine("- " + diff.forceGetRaw(record.getLongId()));
            prefix = "+ ";
            record = store.forceGetRecord(record.getLongId());
        }
        log.logLine(prefix + record);
    }

    private StringBuilder messageHeader(String type) {
        StringBuilder log = new StringBuilder(type).append(" in transaction");
        if (this.commitEntry != null) {
            log.append(" (txId=").append(this.commitEntry.getTxId()).append(")");
        } else if (this.startEntry != null) {
            log.append(" (log local id = ").append(this.startEntry.getIdentifier()).append(")");
        }
        return log.append(':');
    }

    public void visitNode(NodeRecord record) {
        this.diffs.visitNode(record);
    }

    public void visitRelationship(RelationshipRecord record) {
        this.diffs.visitRelationship(record);
    }

    public void visitProperty(PropertyRecord record) {
        this.diffs.visitProperty(record);
    }

    public void visitRelationshipType(RelationshipTypeRecord record) {
        this.diffs.visitRelationshipType(record);
    }

    public void visitPropertyIndex(PropertyIndexRecord record) {
        this.diffs.visitPropertyIndex(record);
    }

    public void visitNeoStore(NeoStoreRecord record) {
        this.diffs.visitNeoStore(record);
    }

    static enum CheckerMode {
        FULL(true){

            @Override
            ConsistencyCheck apply(DiffStore diffs, ConsistencyCheck checker) {
                try {
                    checker.run();
                }
                catch (AssertionError e) {
                    System.err.println(((Throwable)((Object)e)).getMessage());
                }
                return checker;
            }
        }
        ,
        DIFF(false){

            @Override
            ConsistencyCheck apply(DiffStore diffs, ConsistencyCheck checker) {
                return (ConsistencyCheck)diffs.applyToAll(checker);
            }
        };

        final boolean checkProp;

        private CheckerMode(boolean checkProp) {
            this.checkProp = checkProp;
        }

        abstract ConsistencyCheck apply(DiffStore var1, ConsistencyCheck var2);
    }
}

