/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.log;

import java.util.HashMap;
import org.neo4j.backup.log.VerifyingTransactionInterceptor;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;

public class VerifyingTransactionInterceptorProvider
extends TransactionInterceptorProvider {
    public static final String NAME = "verifying";

    public VerifyingTransactionInterceptorProvider() {
        super(NAME);
    }

    public String name() {
        return NAME;
    }

    public VerifyingTransactionInterceptor create(XaDataSource ds, Object options, DependencyResolver dependencyResolver) {
        if (!(options instanceof String)) {
            return null;
        }
        String[] config = ((String)options).split(";");
        if (!"true".equalsIgnoreCase(config[0])) {
            return null;
        }
        HashMap<String, String> extra = new HashMap<String, String>();
        for (int i = 1; i < config.length; ++i) {
            String[] parts = config[i].split("=", 2);
            extra.put(parts[0].toLowerCase(), parts.length == 1 ? "true" : parts[1]);
        }
        return new VerifyingTransactionInterceptor((NeoStoreXaDataSource)ds, (StringLogger)dependencyResolver.resolveDependency(StringLogger.class), VerifyingTransactionInterceptor.CheckerMode.DIFF, true, extra);
    }

    public VerifyingTransactionInterceptor create(TransactionInterceptor next, XaDataSource ds, Object options, DependencyResolver dependencyResolver) {
        VerifyingTransactionInterceptor result = this.create(ds, options, dependencyResolver);
        result.setNext(next);
        return result;
    }
}

