/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;

public class BlockLogBuffer
implements LogBuffer {
    static final byte FULL_BLOCK_AND_MORE = 0;
    static final int MAX_SIZE = 256;
    static final int DATA_SIZE = 255;
    private final ChannelBuffer target;
    private final byte[] byteArray = new byte[264];
    private final ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArray);

    public BlockLogBuffer(ChannelBuffer target) {
        this.target = target;
        this.clearInternalBuffer();
    }

    private void clearInternalBuffer() {
        this.byteBuffer.clear();
        this.byteBuffer.put((byte)0);
    }

    private LogBuffer checkFlush() {
        if (this.byteBuffer.position() > 256) {
            this.target.writeBytes(this.byteArray, 0, 256);
            int pos = this.byteBuffer.position();
            this.clearInternalBuffer();
            this.byteBuffer.put(this.byteArray, 256, pos - 256);
        }
        return this;
    }

    public LogBuffer put(byte b) throws IOException {
        this.byteBuffer.put(b);
        return this.checkFlush();
    }

    public LogBuffer putShort(short s) throws IOException {
        this.byteBuffer.putShort(s);
        return this.checkFlush();
    }

    public LogBuffer putInt(int i) throws IOException {
        this.byteBuffer.putInt(i);
        return this.checkFlush();
    }

    public LogBuffer putLong(long l) throws IOException {
        this.byteBuffer.putLong(l);
        return this.checkFlush();
    }

    public LogBuffer putFloat(float f) throws IOException {
        this.byteBuffer.putFloat(f);
        return this.checkFlush();
    }

    public LogBuffer putDouble(double d) throws IOException {
        this.byteBuffer.putDouble(d);
        return this.checkFlush();
    }

    public LogBuffer put(byte[] bytes) throws IOException {
        int toWrite;
        for (int pos = 0; pos < bytes.length; pos += toWrite) {
            toWrite = Math.min(this.byteBuffer.remaining(), bytes.length - pos);
            this.byteBuffer.put(bytes, pos, toWrite);
            this.checkFlush();
        }
        return this;
    }

    public LogBuffer put(char[] chars) throws IOException {
        int bytesToWrite;
        for (int bytePos = 0; bytePos < chars.length * 2; bytePos += bytesToWrite) {
            bytesToWrite = Math.min(this.byteBuffer.remaining(), chars.length * 2 - bytePos);
            bytesToWrite -= bytesToWrite % 2;
            for (int i = 0; i < bytesToWrite / 2; ++i) {
                this.byteBuffer.putChar(chars[bytePos / 2 + i]);
            }
            this.checkFlush();
        }
        return this;
    }

    public void writeOut() throws IOException {
    }

    public void force() throws IOException {
    }

    public long getFileChannelPosition() throws IOException {
        throw new UnsupportedOperationException("BlockLogBuffer does not have a FileChannel");
    }

    public FileChannel getFileChannel() {
        throw new UnsupportedOperationException("BlockLogBuffer does not have a FileChannel");
    }

    public void done() {
        assert (this.byteBuffer.position() > 1) : "buffer should contain more than the header";
        assert (this.byteBuffer.position() <= 256) : "buffer should not be over full";
        this.byteBuffer.put(0, (byte)(this.byteBuffer.position() - 1));
        this.byteBuffer.flip();
        this.target.writeBytes(this.byteBuffer);
        this.clearInternalBuffer();
    }

    public int write(ReadableByteChannel data) throws IOException {
        int result = 0;
        int bytesRead = 0;
        while ((bytesRead = data.read(this.byteBuffer)) >= 0) {
            this.checkFlush();
            result += bytesRead;
        }
        return result;
    }
}

