/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.queue.BlockingReadHandler;
import org.neo4j.com.BlockLogReader;
import org.neo4j.com.ChunkingChannelBuffer;
import org.neo4j.com.ComException;
import org.neo4j.com.DechunkingChannelBuffer;
import org.neo4j.com.Deserializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestType;
import org.neo4j.com.ResourcePool;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreIdGetter;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class Client<M>
implements ChannelPipelineFactory {
    public static final int DEFAULT_MAX_NUMBER_OF_CONCURRENT_CHANNELS_PER_CLIENT = 20;
    public static final int DEFAULT_READ_RESPONSE_TIMEOUT_SECONDS = 20;
    private final ClientBootstrap bootstrap;
    private final SocketAddress address;
    private final StringLogger msgLog;
    private final ExecutorService executor;
    private final ResourcePool<Triplet<Channel, ChannelBuffer, ByteBuffer>> channelPool;
    private StoreId myStoreId;
    private final int frameLength;
    private final int readTimeout;
    private final byte applicationProtocolVersion;
    private final StoreIdGetter storeIdGetter;
    private final ResourceReleaser resourcePoolReleaser;
    public static final StoreIdGetter NO_STORE_ID_GETTER = new StoreIdGetter(){

        @Override
        public StoreId get() {
            throw new UnsupportedOperationException();
        }
    };

    public Client(String hostNameOrIp, int port, StringLogger logger, StoreIdGetter storeIdGetter, int frameLength, byte applicationProtocolVersion, int readTimeout, int maxConcurrentChannels, int maxUnusedPoolSize) {
        this(hostNameOrIp, port, logger, storeIdGetter, frameLength, applicationProtocolVersion, readTimeout, maxConcurrentChannels, maxUnusedPoolSize, ConnectionLostHandler.NO_ACTION);
    }

    public Client(String hostNameOrIp, int port, StringLogger logger, StoreIdGetter storeIdGetter, int frameLength, byte applicationProtocolVersion, int readTimeout, int maxConcurrentChannels, int maxUnusedPoolSize, ConnectionLostHandler connectionLostHandler) {
        this.msgLog = logger;
        this.storeIdGetter = storeIdGetter;
        this.frameLength = frameLength;
        this.applicationProtocolVersion = applicationProtocolVersion;
        this.readTimeout = readTimeout;
        this.channelPool = new ResourcePool<Triplet<Channel, ChannelBuffer, ByteBuffer>>(maxConcurrentChannels, maxUnusedPoolSize){

            @Override
            protected Triplet<Channel, ChannelBuffer, ByteBuffer> create() {
                ChannelFuture channelFuture = Client.this.bootstrap.connect(Client.this.address);
                channelFuture.awaitUninterruptibly(5L, TimeUnit.SECONDS);
                Triplet channel = null;
                if (channelFuture.isSuccess()) {
                    channel = Triplet.of((Object)channelFuture.getChannel(), (Object)ChannelBuffers.dynamicBuffer(), (Object)ByteBuffer.allocateDirect(0x100000));
                    Client.this.msgLog.logMessage("Opened a new channel to " + Client.this.address, true);
                    return channel;
                }
                String msg = "Client could not connect to " + Client.this.address;
                Client.this.msgLog.logMessage(msg, true);
                ComException exception = new ComException(msg);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Client.this.msgLog.logMessage("Interrupted", (Throwable)e);
                }
                throw exception;
            }

            @Override
            protected boolean isAlive(Triplet<Channel, ChannelBuffer, ByteBuffer> resource) {
                return ((Channel)resource.first()).isConnected();
            }

            @Override
            protected void dispose(Triplet<Channel, ChannelBuffer, ByteBuffer> resource) {
                Channel channel = (Channel)resource.first();
                if (channel.isConnected()) {
                    channel.close();
                }
            }
        };
        this.address = new InetSocketAddress(hostNameOrIp, port);
        this.executor = Executors.newCachedThreadPool();
        this.bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)this.executor, (Executor)this.executor));
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)this);
        this.resourcePoolReleaser = new ResourceReleaser(){

            @Override
            public void release() {
                Client.this.channelPool.release();
            }
        };
        this.msgLog.logMessage(this.getClass().getSimpleName() + " communication started and bound to " + hostNameOrIp + ":" + port, true);
    }

    protected byte getInternalProtocolVersion() {
        return 2;
    }

    protected <R> Response<R> sendRequest(RequestType<M> type, SlaveContext context, Serializer serializer, Deserializer<R> deserializer) {
        return this.sendRequest(type, context, serializer, deserializer, null);
    }

    protected <R> Response<R> sendRequest(RequestType<M> type, SlaveContext context, Serializer serializer, Deserializer<R> deserializer, StoreId specificStoreId) {
        boolean success = true;
        Triplet<Channel, ChannelBuffer, ByteBuffer> channelContext = null;
        try {
            channelContext = this.getChannel(type);
            Channel channel = (Channel)channelContext.first();
            ((ChannelBuffer)channelContext.second()).clear();
            ChunkingChannelBuffer chunkingBuffer = new ChunkingChannelBuffer((ChannelBuffer)channelContext.second(), channel, this.frameLength, this.getInternalProtocolVersion(), this.applicationProtocolVersion);
            chunkingBuffer.writeByte(type.id());
            this.writeContext(type, context, chunkingBuffer);
            serializer.write(chunkingBuffer, (ByteBuffer)channelContext.third());
            chunkingBuffer.done();
            BlockingReadHandler reader = (BlockingReadHandler)channel.getPipeline().get("blockingHandler");
            DechunkingChannelBuffer dechunkingBuffer = new DechunkingChannelBuffer((BlockingReadHandler<ChannelBuffer>)reader, this.getReadTimeout(type, this.readTimeout), this.getInternalProtocolVersion(), this.applicationProtocolVersion);
            R response = deserializer.read(dechunkingBuffer, (ByteBuffer)channelContext.third());
            StoreId storeId = this.readStoreId(dechunkingBuffer, (ByteBuffer)channelContext.third());
            if (this.shouldCheckStoreId(type)) {
                if (specificStoreId != null) {
                    this.assertCorrectStoreId(storeId, specificStoreId);
                } else {
                    this.assertCorrectStoreId(storeId, this.getMyStoreId());
                }
            }
            TransactionStream txStreams = Client.readTransactionStreams(dechunkingBuffer, this.channelPool);
            Response<R> response2 = new Response<R>(response, storeId, txStreams, this.resourcePoolReleaser);
            return response2;
        }
        catch (Throwable e) {
            success = false;
            if (channelContext != null) {
                this.closeChannel(channelContext);
            }
            throw (ComException)Exceptions.launderedException(ComException.class, (Throwable)e);
        }
        finally {
            if (!success) {
                this.releaseChannel(type, channelContext);
            }
        }
    }

    protected int getReadTimeout(RequestType<M> type, int readTimeout) {
        return readTimeout;
    }

    protected boolean shouldCheckStoreId(RequestType<M> type) {
        return true;
    }

    private void assertCorrectStoreId(StoreId storeId, StoreId myStoreId) {
        if (!myStoreId.equals((Object)storeId)) {
            throw new ComException(storeId + " from response doesn't match my " + myStoreId);
        }
    }

    protected StoreId getMyStoreId() {
        if (this.myStoreId == null) {
            this.myStoreId = this.storeIdGetter.get();
        }
        return this.myStoreId;
    }

    private StoreId readStoreId(ChannelBuffer source, ByteBuffer byteBuffer) {
        byteBuffer.clear();
        byteBuffer.limit(24);
        source.readBytes(byteBuffer);
        byteBuffer.flip();
        return StoreId.deserialize((ByteBuffer)byteBuffer);
    }

    protected void writeContext(RequestType<M> type, SlaveContext context, ChannelBuffer targetBuffer) {
        targetBuffer.writeLong(context.getSessionId());
        targetBuffer.writeInt(context.machineId());
        targetBuffer.writeInt(context.getEventIdentifier());
        SlaveContext.Tx[] txs = context.lastAppliedTransactions();
        targetBuffer.writeByte(txs.length);
        for (SlaveContext.Tx tx : txs) {
            Protocol.writeString(targetBuffer, tx.getDataSourceName());
            targetBuffer.writeLong(tx.getTxId());
        }
        targetBuffer.writeInt(context.getMasterId());
        targetBuffer.writeLong(context.getChecksum());
    }

    private Triplet<Channel, ChannelBuffer, ByteBuffer> getChannel(RequestType<M> type) throws Exception {
        Triplet<Channel, ChannelBuffer, ByteBuffer> result = this.channelPool.acquire();
        if (result == null) {
            this.msgLog.logMessage("Unable to acquire new channel for " + type);
            throw new ComException("Unable to acquire new channel for " + type);
        }
        return result;
    }

    protected void releaseChannel(RequestType<M> type, Triplet<Channel, ChannelBuffer, ByteBuffer> channel) {
        this.channelPool.release();
    }

    protected void closeChannel(Triplet<Channel, ChannelBuffer, ByteBuffer> channel) {
        ((Channel)channel.first()).close().awaitUninterruptibly();
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        Protocol.addLengthFieldPipes(pipeline, this.frameLength);
        BlockingReadHandler reader = new BlockingReadHandler(new ArrayBlockingQueue(3, false));
        pipeline.addLast("blockingHandler", (ChannelHandler)reader);
        return pipeline;
    }

    public void shutdown() {
        this.channelPool.close(true);
        this.executor.shutdownNow();
        this.msgLog.logMessage(this.toString() + " shutdown", true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.address + "]";
    }

    protected static TransactionStream readTransactionStreams(final ChannelBuffer buffer, ResourcePool<Triplet<Channel, ChannelBuffer, ByteBuffer>> resourcePool) {
        final String[] datasources = Client.readTransactionStreamHeader(buffer);
        if (datasources.length == 1) {
            return TransactionStream.EMPTY;
        }
        return new TransactionStream(new String[0]){

            protected Triplet<String, Long, TxExtractor> fetchNextOrNull() {
                Client.makeSureNextTransactionIsFullyFetched(buffer);
                String datasource = datasources[buffer.readUnsignedByte()];
                if (datasource == null) {
                    return null;
                }
                long txId = buffer.readLong();
                TxExtractor extractor = TxExtractor.create(new BlockLogReader(buffer));
                return Triplet.of((Object)datasource, (Object)txId, (Object)extractor);
            }

            @Override
            public String[] dataSourceNames() {
                return Arrays.copyOfRange(datasources, 1, datasources.length);
            }
        };
    }

    protected static String[] readTransactionStreamHeader(ChannelBuffer buffer) {
        short numberOfDataSources = buffer.readUnsignedByte();
        String[] datasources = new String[numberOfDataSources + 1];
        datasources[0] = null;
        for (int i = 1; i < datasources.length; ++i) {
            datasources[i] = Protocol.readString(buffer);
        }
        return datasources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeSureNextTransactionIsFullyFetched(ChannelBuffer buffer) {
        buffer.markReaderIndex();
        try {
            if (buffer.readUnsignedByte() > 0) {
                buffer.skipBytes(8);
                short blockSize = 0;
                while ((blockSize = buffer.readUnsignedByte()) == 0) {
                    buffer.skipBytes(255);
                }
                buffer.skipBytes((int)blockSize);
            }
        }
        finally {
            buffer.resetReaderIndex();
        }
    }

    public static StoreIdGetter storeIdGetterForDb(final GraphDatabaseService db) {
        return new StoreIdGetter(){

            @Override
            public StoreId get() {
                return ((AbstractGraphDatabase)db).getStoreId();
            }
        };
    }

    public static interface ConnectionLostHandler {
        public static final ConnectionLostHandler NO_ACTION = new ConnectionLostHandler(){

            @Override
            public void handle(Exception e) {
            }
        };

        public void handle(Exception var1);
    }
}

