/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.neo4j.com.MasterFailureException;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.StoreWriter;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxExtractor;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class MasterUtil {
    public static final Predicate<Long> ALL = new Predicate<Long>(){

        public boolean accept(Long item) {
            return true;
        }
    };
    public static final TxHandler NO_ACTION = new TxHandler(){

        @Override
        public void accept(Triplet<String, Long, TxExtractor> tx, XaDataSource dataSource) {
        }

        @Override
        public void done() {
        }
    };

    private static File getBaseDir(GraphDatabaseAPI graphDb) {
        File file = new File(graphDb.getStoreDir());
        try {
            return file.getCanonicalFile().getAbsoluteFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    private static String relativePath(File baseDir, File storeFile) throws IOException {
        String prefix = baseDir.getCanonicalPath();
        String path = storeFile.getCanonicalPath();
        if (!path.startsWith(prefix)) {
            throw new FileNotFoundException();
        }
        if ((path = path.substring(prefix.length())).startsWith(File.separator)) {
            return path.substring(1);
        }
        return path;
    }

    public static SlaveContext.Tx[] rotateLogs(GraphDatabaseAPI graphDb) {
        XaDataSourceManager dsManager = graphDb.getXaDataSourceManager();
        Collection sources = dsManager.getAllRegisteredDataSources();
        SlaveContext.Tx[] appliedTransactions = new SlaveContext.Tx[sources.size()];
        int i = 0;
        for (XaDataSource ds : sources) {
            try {
                appliedTransactions[i++] = SlaveContext.lastAppliedTx(ds.getName(), ds.getXaContainer().getResourceManager().rotateLogicalLog());
            }
            catch (IOException e) {
                graphDb.getMessageLog().logMessage("Unable to rotate log for " + ds, (Throwable)e);
                graphDb.getKernelPanicGenerator().generateEvent(ErrorState.TX_MANAGER_NOT_OK);
                throw new MasterFailureException(e);
            }
        }
        return appliedTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SlaveContext rotateLogsAndStreamStoreFiles(GraphDatabaseAPI graphDb, boolean includeLogicalLogs, StoreWriter writer) {
        File baseDir = MasterUtil.getBaseDir(graphDb);
        XaDataSourceManager dsManager = graphDb.getXaDataSourceManager();
        SlaveContext context = SlaveContext.anonymous(MasterUtil.rotateLogs(graphDb));
        ByteBuffer temporaryBuffer = ByteBuffer.allocateDirect(0x100000);
        for (XaDataSource ds : dsManager.getAllRegisteredDataSources()) {
            try {
                ClosableIterable files = ds.listStoreFiles(includeLogicalLogs);
                try {
                    for (File storefile : files) {
                        FileInputStream stream = new FileInputStream(storefile);
                        try {
                            writer.write(MasterUtil.relativePath(baseDir, storefile), stream.getChannel(), temporaryBuffer, storefile.length() > 0L);
                        }
                        finally {
                            stream.close();
                        }
                    }
                }
                finally {
                    files.close();
                }
            }
            catch (IOException e) {
                throw new MasterFailureException(e);
            }
        }
        return context;
    }

    private static LogExtractor getTransactionStreamForDatasource(final XaDataSource dataSource, final long startTxId, final long endTxId, List<Triplet<String, Long, TxExtractor>> stream, Predicate<Long> filter) {
        LogExtractor logExtractor = null;
        try {
            long masterLastTx = dataSource.getLastCommittedTxId();
            if (masterLastTx < endTxId) {
                throw new RuntimeException("Was requested to extract transaction ids " + startTxId + " to " + endTxId + " from data source " + dataSource.getName() + " but largest transaction id in master is " + masterLastTx);
            }
            try {
                logExtractor = dataSource.getLogExtractor(startTxId, endTxId);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            final LogExtractor finalLogExtractor = logExtractor;
            for (long txId = startTxId; txId <= endTxId; ++txId) {
                if (!filter.accept((Object)txId)) continue;
                final long finalTxId = txId;
                TxExtractor extractor = new TxExtractor(){

                    @Override
                    public ReadableByteChannel extract() {
                        InMemoryLogBuffer buffer = new InMemoryLogBuffer();
                        this.extract((LogBuffer)buffer);
                        return buffer;
                    }

                    @Override
                    public void extract(LogBuffer buffer) {
                        try {
                            long extractedTxId = finalLogExtractor.extractNext(buffer);
                            if (extractedTxId == -1L) {
                                throw new RuntimeException("Transaction " + finalTxId + " is missing and can't be extracted from " + dataSource.getName() + ". Was about to extract " + startTxId + " to " + endTxId);
                            }
                            if (extractedTxId != finalTxId) {
                                throw new RuntimeException("Expected txId " + finalTxId + ", but was " + extractedTxId);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                stream.add((Triplet<String, Long, TxExtractor>)Triplet.of((Object)dataSource.getName(), (Object)txId, (Object)extractor));
            }
            return logExtractor;
        }
        catch (Throwable t) {
            if (logExtractor != null) {
                logExtractor.close();
            }
            throw Exceptions.launderedException((Throwable)t);
        }
    }

    public static <T> Response<T> packResponse(GraphDatabaseAPI graphDb, SlaveContext context, T response, Predicate<Long> filter) {
        ArrayList<Triplet<String, Long, TxExtractor>> stream = new ArrayList<Triplet<String, Long, TxExtractor>>();
        HashSet<String> resourceNames = new HashSet<String>();
        XaDataSourceManager dsManager = graphDb.getXaDataSourceManager();
        ArrayList<LogExtractor> logExtractors = new ArrayList<LogExtractor>();
        try {
            for (SlaveContext.Tx txEntry : context.lastAppliedTransactions()) {
                String resourceName = txEntry.getDataSourceName();
                XaDataSource dataSource = dsManager.getXaDataSource(resourceName);
                if (dataSource == null) {
                    throw new RuntimeException("No data source '" + resourceName + "' found");
                }
                resourceNames.add(resourceName);
                long masterLastTx = dataSource.getLastCommittedTxId();
                if (txEntry.getTxId() >= masterLastTx) continue;
                LogExtractor logExtractor = MasterUtil.getTransactionStreamForDatasource(dataSource, txEntry.getTxId() + 1L, masterLastTx, stream, filter);
                logExtractors.add(logExtractor);
            }
            StoreId storeId = dsManager.getNeoStoreDataSource().getStoreId();
            return new Response<T>(response, storeId, MasterUtil.createTransactionStream(resourceNames, stream, logExtractors), ResourceReleaser.NO_OP);
        }
        catch (Throwable t) {
            for (LogExtractor extractor : logExtractors) {
                extractor.close();
            }
            throw Exceptions.launderedException((Throwable)t);
        }
    }

    public static Response<Void> getTransactions(GraphDatabaseAPI graphDb, String dataSourceName, long startTx, long endTx) {
        ArrayList<Triplet<String, Long, TxExtractor>> stream = new ArrayList<Triplet<String, Long, TxExtractor>>();
        XaDataSourceManager dsManager = graphDb.getXaDataSourceManager();
        XaDataSource dataSource = dsManager.getXaDataSource(dataSourceName);
        if (dataSource == null) {
            throw new RuntimeException("No data source '" + dataSourceName + "' found");
        }
        List<LogExtractor> extractors = startTx < endTx ? Collections.singletonList(MasterUtil.getTransactionStreamForDatasource(dataSource, startTx, endTx, stream, ALL)) : Collections.emptyList();
        StoreId storeId = ((NeoStoreXaDataSource)dsManager.getXaDataSource("nioneodb")).getStoreId();
        return new Response<Object>(null, storeId, MasterUtil.createTransactionStream(Collections.singletonList(dataSourceName), stream, extractors), ResourceReleaser.NO_OP);
    }

    private static TransactionStream createTransactionStream(Collection<String> resourceNames, final List<Triplet<String, Long, TxExtractor>> stream, final List<LogExtractor> logExtractors) {
        return new TransactionStream(resourceNames.toArray(new String[resourceNames.size()])){
            private final Iterator<Triplet<String, Long, TxExtractor>> iterator;
            {
                super(x0);
                this.iterator = stream.iterator();
            }

            protected Triplet<String, Long, TxExtractor> fetchNextOrNull() {
                return this.iterator.hasNext() ? this.iterator.next() : null;
            }

            @Override
            public void close() {
                for (LogExtractor extractor : logExtractors) {
                    extractor.close();
                }
            }
        };
    }

    public static <T> Response<T> packResponseWithoutTransactionStream(GraphDatabaseAPI graphDb, SlaveContext context, T response) {
        NeoStoreXaDataSource ds = graphDb.getXaDataSourceManager().getNeoStoreDataSource();
        StoreId storeId = ds.getStoreId();
        return new Response<T>(response, storeId, TransactionStream.EMPTY, ResourceReleaser.NO_OP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void applyReceivedTransactions(Response<T> response, GraphDatabaseAPI graphDb, TxHandler txHandler) throws IOException {
        XaDataSourceManager dataSourceManager = graphDb.getXaDataSourceManager();
        try {
            for (Triplet tx : IteratorUtil.asIterable((Iterator)((Object)response.transactions()))) {
                String resourceName = (String)tx.first();
                XaDataSource dataSource = dataSourceManager.getXaDataSource(resourceName);
                txHandler.accept((Triplet<String, Long, TxExtractor>)tx, dataSource);
                ReadableByteChannel txStream = ((TxExtractor)tx.third()).extract();
                try {
                    dataSource.applyCommittedTransaction(((Long)tx.second()).longValue(), txStream);
                }
                finally {
                    txStream.close();
                }
            }
            txHandler.done();
        }
        finally {
            response.close();
        }
    }

    public static TxHandler txHandlerForFullCopy() {
        return new TxHandler(){
            private final Set<String> visitedDataSources = new HashSet<String>();

            @Override
            public void accept(Triplet<String, Long, TxExtractor> tx, XaDataSource dataSource) {
                if (this.visitedDataSources.add((String)tx.first())) {
                    dataSource.setLastCommittedTxId((Long)tx.second() - 1L);
                }
            }

            @Override
            public void done() {
            }
        };
    }

    public static interface TxHandler {
        public void accept(Triplet<String, Long, TxExtractor> var1, XaDataSource var2);

        public void done();
    }
}

