/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.neo4j.com.BlockLogReader;
import org.neo4j.com.ComException;
import org.neo4j.com.Deserializer;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Serializer;
import org.neo4j.com.StoreWriter;

public abstract class Protocol {
    public static final int PORT = 8901;
    public static final int MEGA = 0x100000;
    public static final int DEFAULT_FRAME_LENGTH = 0x1000000;
    public static final ObjectSerializer<Integer> INTEGER_SERIALIZER = new ObjectSerializer<Integer>(){

        @Override
        public void write(Integer responseObject, ChannelBuffer result) throws IOException {
            result.writeInt(responseObject.intValue());
        }
    };
    public static final ObjectSerializer<Long> LONG_SERIALIZER = new ObjectSerializer<Long>(){

        @Override
        public void write(Long responseObject, ChannelBuffer result) throws IOException {
            result.writeLong(responseObject.longValue());
        }
    };
    public static final ObjectSerializer<Void> VOID_SERIALIZER = new ObjectSerializer<Void>(){

        @Override
        public void write(Void responseObject, ChannelBuffer result) throws IOException {
        }
    };
    public static final Deserializer<Integer> INTEGER_DESERIALIZER = new Deserializer<Integer>(){

        @Override
        public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            return buffer.readInt();
        }
    };
    public static final Deserializer<Void> VOID_DESERIALIZER = new Deserializer<Void>(){

        @Override
        public Void read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            return null;
        }
    };
    public static final Serializer EMPTY_SERIALIZER = new Serializer(){

        @Override
        public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
        }
    };

    public static void addLengthFieldPipes(ChannelPipeline pipeline, int frameLength) {
        pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(frameLength + 4, 0, 4, 0, 4));
        pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(4));
    }

    public static void writeString(ChannelBuffer buffer, String name) {
        char[] chars = name.toCharArray();
        buffer.writeInt(chars.length);
        Protocol.writeChars(buffer, chars);
    }

    public static void writeChars(ChannelBuffer buffer, char[] chars) {
        for (char ch : chars) {
            buffer.writeChar((int)ch);
        }
    }

    public static String readString(ChannelBuffer buffer) {
        return Protocol.readString(buffer, buffer.readInt());
    }

    public static boolean readBoolean(ChannelBuffer buffer) {
        byte value = buffer.readByte();
        switch (value) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new ComException("Invalid boolean value " + value);
    }

    public static String readString(ChannelBuffer buffer, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = buffer.readChar();
        }
        return new String(chars);
    }

    public static class FileStreamsDeserializer
    implements Deserializer<Void> {
        private final StoreWriter writer;

        public FileStreamsDeserializer(StoreWriter writer) {
            this.writer = writer;
        }

        @Override
        public Void read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
            int pathLength;
            while (0 != (pathLength = buffer.readUnsignedShort())) {
                String path = Protocol.readString(buffer, pathLength);
                boolean hasData = buffer.readByte() == 1;
                this.writer.write(path, hasData ? new BlockLogReader(buffer) : null, temporaryBuffer, hasData);
            }
            this.writer.done();
            return null;
        }
    }
}

