/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public abstract class ResourcePool<R> {
    private static final boolean FAIR = true;
    private final LinkedList<R> unused = new LinkedList();
    private final Map<Thread, R> current = new ConcurrentHashMap<Thread, R>();
    private final ResizableSemaphore resources;
    private int maxUnused;

    protected ResourcePool(int maxResources, int maxUnused) {
        this.maxUnused = maxUnused;
        this.resources = new ResizableSemaphore(maxResources);
    }

    protected abstract R create();

    protected void dispose(R resource) {
    }

    protected boolean isAlive(R resource) {
        return true;
    }

    public final void setMaxResources(int maxResources) {
        this.resources.setPermits(maxResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final R acquire() {
        Thread thread = Thread.currentThread();
        R resource = this.current.get(thread);
        if (resource == null) {
            this.resources.acquireUninterruptibly();
            LinkedList<R> garbage = null;
            LinkedList<R> linkedList = this.unused;
            synchronized (linkedList) {
                while ((resource = this.unused.poll()) != null && !this.isAlive(resource)) {
                    if (garbage == null) {
                        garbage = new LinkedList<R>();
                    }
                    garbage.add(resource);
                }
            }
            if (resource == null) {
                resource = this.create();
            }
            this.current.put(thread, resource);
            if (garbage != null) {
                for (Object dead : garbage) {
                    this.dispose(dead);
                }
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        block9: {
            Thread thread = Thread.currentThread();
            R resource = this.current.remove(thread);
            try {
                if (resource == null) break block9;
                boolean dead = false;
                LinkedList<R> linkedList = this.unused;
                synchronized (linkedList) {
                    if (this.unused.size() < this.maxUnused) {
                        this.unused.add(resource);
                    } else {
                        dead = true;
                    }
                }
                if (dead) {
                    this.dispose(resource);
                }
            }
            finally {
                this.resources.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(boolean force) {
        LinkedList<R> dead = new LinkedList<R>();
        LinkedList<R> linkedList = this.unused;
        synchronized (linkedList) {
            dead.addAll(this.unused);
            this.unused.clear();
            this.maxUnused = 0;
        }
        if (force) {
            dead.addAll(this.current.values());
        }
        for (Object resource : dead) {
            this.dispose(resource);
        }
    }

    private static class ResizableSemaphore
    extends Semaphore {
        private int permits;

        ResizableSemaphore(int permits) {
            super(permits, true);
            this.permits = permits;
        }

        synchronized void setPermits(int permits) {
            if (permits > this.permits) {
                this.release(permits - this.permits);
            } else if (permits < this.permits) {
                this.reducePermits(this.permits - permits);
            }
            this.permits = permits;
        }
    }
}

