/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.neo4j.com.BlockLogBuffer;
import org.neo4j.com.ChunkingChannelBuffer;
import org.neo4j.com.DechunkingChannelBuffer;
import org.neo4j.com.IllegalProtocolVersionException;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.SlaveContext;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TxChecksumVerifier;
import org.neo4j.com.TxExtractor;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class Server<M, R>
extends Protocol
implements ChannelPipelineFactory {
    static final byte INTERNAL_PROTOCOL_VERSION = 2;
    public static final int DEFAULT_BACKUP_PORT = 6362;
    public static final int DEFAULT_MAX_NUMBER_OF_CONCURRENT_TRANSACTIONS = 200;
    private final ChannelFactory channelFactory;
    private final ServerBootstrap bootstrap;
    private M realMaster;
    private final ChannelGroup channelGroup;
    private final Map<Channel, Pair<SlaveContext, AtomicLong>> connectedSlaveChannels = new HashMap<Channel, Pair<SlaveContext, AtomicLong>>();
    private final ExecutorService executor;
    private final ExecutorService masterCallExecutor;
    private final StringLogger msgLog;
    private final Map<Channel, PartialRequest> partialRequests = Collections.synchronizedMap(new HashMap());
    private final int frameLength;
    private volatile boolean shuttingDown;
    private final ExecutorService unfinishedTransactionExecutor;
    private final ScheduledExecutorService silentChannelExecutor;
    private final byte applicationProtocolVersion;
    private final int oldChannelThresholdMillis;
    private TxChecksumVerifier txVerifier;

    public Server(M realMaster, int port, StringLogger logger, int frameLength, byte applicationProtocolVersion, int maxNumberOfConcurrentTransactions, int oldChannelThreshold, TxChecksumVerifier txVerifier) {
        Channel channel;
        this.realMaster = realMaster;
        this.frameLength = frameLength;
        this.applicationProtocolVersion = applicationProtocolVersion;
        this.msgLog = logger;
        this.txVerifier = txVerifier;
        this.oldChannelThresholdMillis = oldChannelThreshold * 1000;
        this.executor = Executors.newCachedThreadPool();
        this.masterCallExecutor = Executors.newCachedThreadPool();
        this.unfinishedTransactionExecutor = Executors.newScheduledThreadPool(2);
        this.channelFactory = new NioServerSocketChannelFactory((Executor)this.executor, (Executor)this.executor, maxNumberOfConcurrentTransactions);
        this.silentChannelExecutor = Executors.newSingleThreadScheduledExecutor();
        this.silentChannelExecutor.scheduleWithFixedDelay(this.silentChannelFinisher(), 5L, 5L, TimeUnit.SECONDS);
        this.bootstrap = new ServerBootstrap(this.channelFactory);
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)this);
        try {
            channel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(port));
        }
        catch (ChannelException e) {
            this.msgLog.logMessage("Failed to bind master server to port " + port, (Throwable)e);
            this.executor.shutdown();
            throw e;
        }
        this.channelGroup = new DefaultChannelGroup();
        this.channelGroup.add((Object)channel);
        this.msgLog.logMessage(this.getClass().getSimpleName() + " communication server started and bound to " + port, true);
    }

    private Runnable silentChannelFinisher() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap channels = new HashMap();
                Map map = Server.this.connectedSlaveChannels;
                synchronized (map) {
                    for (Map.Entry channel : Server.this.connectedSlaveChannels.entrySet()) {
                        long age = System.currentTimeMillis() - ((AtomicLong)((Pair)channel.getValue()).other()).get();
                        if (age > (long)Server.this.oldChannelThresholdMillis) {
                            Server.this.msgLog.logMessage("Found a silent channel " + channel + ", " + age);
                            channels.put(channel.getKey(), Boolean.TRUE);
                            continue;
                        }
                        if (age <= (long)(Server.this.oldChannelThresholdMillis / 2)) continue;
                        channels.put(channel.getKey(), Boolean.FALSE);
                    }
                }
                for (Map.Entry channel : channels.entrySet()) {
                    if (!((Boolean)channel.getValue()).booleanValue() && ((Channel)channel.getKey()).isOpen() && ((Channel)channel.getKey()).isConnected() && ((Channel)channel.getKey()).isBound()) continue;
                    Server.this.tryToFinishOffChannel((Channel)channel.getKey());
                }
            }
        };
    }

    protected byte getInternalProtocolVersion() {
        return 2;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        Server.addLengthFieldPipes(pipeline, this.frameLength);
        pipeline.addLast("serverHandler", (ChannelHandler)new ServerHandler());
        return pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryToFinishOffChannel(Channel channel) {
        Pair<SlaveContext, AtomicLong> slave = null;
        Map<Channel, Pair<SlaveContext, AtomicLong>> map = this.connectedSlaveChannels;
        synchronized (map) {
            slave = this.connectedSlaveChannels.remove(channel);
        }
        if (slave == null) {
            return;
        }
        this.tryToFinishOffChannel(channel, (SlaveContext)slave.first());
    }

    protected void tryToFinishOffChannel(Channel channel, SlaveContext slave) {
        block2: {
            try {
                this.finishOffChannel(channel, slave);
                this.unmapSlave(channel, slave);
            }
            catch (Throwable failure) {
                this.submitSilent(this.unfinishedTransactionExecutor, this.newTransactionFinisher(slave));
                if (!this.shouldLogFailureToFinishOffChannel(failure)) break block2;
                this.msgLog.logMessage("Could not finish off dead channel", failure);
            }
        }
    }

    protected boolean shouldLogFailureToFinishOffChannel(Throwable failure) {
        return true;
    }

    private void submitSilent(ExecutorService service, Runnable job) {
        block2: {
            try {
                service.submit(job);
            }
            catch (RejectedExecutionException e) {
                if (this.shuttingDown) break block2;
                throw e;
            }
        }
    }

    private Runnable newTransactionFinisher(final SlaveContext slave) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Server.this.finishOffChannel(null, slave);
                }
                catch (Throwable e) {
                    this.sleepNicely(200);
                    Server.this.unfinishedTransactionExecutor.submit(Server.this.newTransactionFinisher(slave));
                }
            }

            private void sleepNicely(int millis) {
                try {
                    Thread.sleep(millis);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        };
    }

    protected void handleRequest(ChannelBuffer buffer, Channel channel) throws IOException {
        Byte continuation = this.readContinuationHeader(buffer, channel);
        if (continuation == null) {
            return;
        }
        if (continuation == 1) {
            PartialRequest partialRequest = this.partialRequests.get(channel);
            if (partialRequest == null) {
                RequestType<M> type = this.getRequestContext(buffer.readByte());
                SlaveContext context = this.readContext(buffer);
                ChannelBuffer targetBuffer = this.mapSlave(channel, context, type);
                partialRequest = new PartialRequest(type, context, targetBuffer);
                this.partialRequests.put(channel, partialRequest);
            }
            partialRequest.add(buffer);
        } else {
            PartialRequest partialRequest = this.partialRequests.remove(channel);
            RequestType type = null;
            SlaveContext context = null;
            ChannelBuffer bufferToReadFrom = null;
            ChannelBuffer bufferToWriteTo = null;
            if (partialRequest == null) {
                type = this.getRequestContext(buffer.readByte());
                context = this.readContext(buffer);
                ChannelBuffer targetBuffer = this.mapSlave(channel, context, type);
                bufferToReadFrom = buffer;
                bufferToWriteTo = targetBuffer;
            } else {
                type = partialRequest.type;
                context = partialRequest.context;
                ChannelBuffer targetBuffer = partialRequest.buffer;
                partialRequest.add(buffer);
                bufferToReadFrom = targetBuffer;
                bufferToWriteTo = ChannelBuffers.dynamicBuffer();
            }
            bufferToWriteTo.clear();
            ChunkingChannelBuffer chunkingBuffer = new ChunkingChannelBuffer(bufferToWriteTo, channel, this.frameLength, this.getInternalProtocolVersion(), this.applicationProtocolVersion);
            this.submitSilent(this.masterCallExecutor, this.masterCaller(type, channel, context, chunkingBuffer, bufferToReadFrom));
        }
    }

    private Byte readContinuationHeader(ChannelBuffer buffer, Channel channel) {
        byte[] header = new byte[2];
        buffer.readBytes(header);
        try {
            DechunkingChannelBuffer.assertSameProtocolVersion(header, this.getInternalProtocolVersion(), this.applicationProtocolVersion);
        }
        catch (IllegalProtocolVersionException e) {
            final ChunkingChannelBuffer failureResponse = new ChunkingChannelBuffer(ChannelBuffers.dynamicBuffer(), channel, this.frameLength, this.getInternalProtocolVersion(), this.applicationProtocolVersion);
            this.submitSilent(this.masterCallExecutor, new Runnable(){

                @Override
                public void run() {
                    Server.this.writeFailureResponse(e, failureResponse);
                }
            });
            return null;
        }
        return (byte)(header[0] & 1);
    }

    private Runnable masterCaller(final RequestType<M> type, final Channel channel, final SlaveContext context, final ChunkingChannelBuffer targetBuffer, final ChannelBuffer bufferToReadFrom) {
        return new Runnable(){

            @Override
            public void run() {
                Response response = null;
                try {
                    response = type.getMasterCaller().callMaster(Server.this.realMaster, context, bufferToReadFrom, targetBuffer);
                    type.getObjectSerializer().write(response.response(), targetBuffer);
                    Server.writeStoreId(response.getStoreId(), targetBuffer);
                    Server.writeTransactionStreams(response.transactions(), targetBuffer);
                    targetBuffer.done();
                    Server.this.responseWritten(type, channel, context);
                }
                catch (Throwable e) {
                    targetBuffer.clear(true);
                    Server.this.writeFailureResponse(e, targetBuffer);
                    Server.this.tryToFinishOffChannel(channel, context);
                    throw Exceptions.launderedException((Throwable)e);
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                    Server.this.unmapSlave(channel, context);
                }
            }
        };
    }

    protected void writeFailureResponse(Throwable exception, ChunkingChannelBuffer buffer) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bytes);
            out.writeObject(exception);
            out.close();
            buffer.writeBytes(bytes.toByteArray());
            buffer.done();
        }
        catch (IOException e) {
            this.msgLog.logMessage("Couldn't send cause of error to client", exception);
        }
    }

    protected void responseWritten(RequestType<M> type, Channel channel, SlaveContext context) {
    }

    private static void writeStoreId(StoreId storeId, ChannelBuffer targetBuffer) {
        targetBuffer.writeBytes(storeId.serialize());
    }

    private static <T> void writeTransactionStreams(TransactionStream txStream, ChannelBuffer buffer) throws IOException {
        if (!txStream.hasNext()) {
            buffer.writeByte(0);
            return;
        }
        String[] datasources = txStream.dataSourceNames();
        assert (datasources.length <= 255) : "too many data sources";
        buffer.writeByte(datasources.length);
        HashMap<String, Integer> datasourceId = new HashMap<String, Integer>();
        for (int i = 0; i < datasources.length; ++i) {
            String datasource = datasources[i];
            Server.writeString(buffer, datasource);
            datasourceId.put(datasource, i + 1);
        }
        for (Triplet tx : IteratorUtil.asIterable((Iterator)((Object)txStream))) {
            buffer.writeByte(((Integer)datasourceId.get(tx.first())).intValue());
            buffer.writeLong(((Long)tx.second()).longValue());
            BlockLogBuffer blockBuffer = new BlockLogBuffer(buffer);
            ((TxExtractor)tx.third()).extract(blockBuffer);
            blockBuffer.done();
        }
        buffer.writeByte(0);
    }

    protected SlaveContext readContext(ChannelBuffer buffer) {
        long sessionId = buffer.readLong();
        int machineId = buffer.readInt();
        int eventIdentifier = buffer.readInt();
        int txsSize = buffer.readByte();
        SlaveContext.Tx[] lastAppliedTransactions = new SlaveContext.Tx[txsSize];
        SlaveContext.Tx neoTx = null;
        for (int i = 0; i < txsSize; ++i) {
            SlaveContext.Tx tx;
            String ds = Server.readString(buffer);
            lastAppliedTransactions[i] = tx = SlaveContext.lastAppliedTx(ds, buffer.readLong());
            if (!ds.equals("nioneodb")) continue;
            neoTx = tx;
        }
        int masterId = buffer.readInt();
        long checksum = buffer.readLong();
        if (neoTx != null) {
            this.txVerifier.assertMatch(neoTx.getTxId(), masterId, checksum);
        }
        return new SlaveContext(sessionId, machineId, eventIdentifier, lastAppliedTransactions, masterId, checksum);
    }

    protected abstract RequestType<M> getRequestContext(byte var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChannelBuffer mapSlave(Channel channel, SlaveContext slave, RequestType<M> type) {
        this.channelGroup.add((Object)channel);
        Map<Channel, Pair<SlaveContext, AtomicLong>> map = this.connectedSlaveChannels;
        synchronized (map) {
            if (slave != null && slave.machineId() != SlaveContext.EMPTY.machineId()) {
                Pair<SlaveContext, AtomicLong> previous = this.connectedSlaveChannels.get(channel);
                if (previous != null) {
                    ((AtomicLong)previous.other()).set(System.currentTimeMillis());
                } else {
                    this.connectedSlaveChannels.put(channel, (Pair<SlaveContext, AtomicLong>)Pair.of((Object)slave, (Object)new AtomicLong(System.currentTimeMillis())));
                }
            }
        }
        return ChannelBuffers.dynamicBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unmapSlave(Channel channel, SlaveContext slave) {
        Map<Channel, Pair<SlaveContext, AtomicLong>> map = this.connectedSlaveChannels;
        synchronized (map) {
            this.connectedSlaveChannels.remove(channel);
            this.channelGroup.remove((Object)channel);
        }
    }

    protected M getMaster() {
        return this.realMaster;
    }

    public void shutdown() {
        this.shuttingDown = true;
        this.silentChannelExecutor.shutdown();
        this.unfinishedTransactionExecutor.shutdown();
        this.masterCallExecutor.shutdown();
        this.channelGroup.close().awaitUninterruptibly();
        this.executor.shutdown();
        this.msgLog.logMessage(this.getClass().getSimpleName() + " shutdown", true);
        this.realMaster = null;
        this.txVerifier = null;
    }

    protected abstract void finishOffChannel(Channel var1, SlaveContext var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Channel, SlaveContext> getConnectedSlaveChannels() {
        HashMap<Channel, SlaveContext> result = new HashMap<Channel, SlaveContext>();
        Map<Channel, Pair<SlaveContext, AtomicLong>> map = this.connectedSlaveChannels;
        synchronized (map) {
            for (Map.Entry<Channel, Pair<SlaveContext, AtomicLong>> entry : this.connectedSlaveChannels.entrySet()) {
                result.put(entry.getKey(), (SlaveContext)entry.getValue().first());
            }
        }
        return result;
    }

    private class PartialRequest {
        final SlaveContext context;
        final ChannelBuffer buffer;
        final RequestType<M> type;

        public PartialRequest(RequestType<M> type, SlaveContext context, ChannelBuffer buffer) {
            this.type = type;
            this.context = context;
            this.buffer = buffer;
        }

        public void add(ChannelBuffer buffer) {
            this.buffer.writeBytes(buffer);
        }
    }

    private class ServerHandler
    extends SimpleChannelHandler {
        private ServerHandler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
            try {
                ChannelBuffer message = (ChannelBuffer)event.getMessage();
                Server.this.handleRequest(message, event.getChannel());
            }
            catch (Throwable e) {
                Server.this.msgLog.logMessage("Error handling request", e);
                ctx.getChannel().close();
                Server.this.tryToFinishOffChannel(ctx.getChannel());
                throw Exceptions.launderedException((Throwable)e);
            }
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (!ctx.getChannel().isOpen()) {
                Server.this.tryToFinishOffChannel(ctx.getChannel());
            }
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (!ctx.getChannel().isConnected()) {
                Server.this.tryToFinishOffChannel(ctx.getChannel());
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            ctx.getChannel().close();
            e.getCause().printStackTrace();
        }
    }
}

