/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.util.Arrays;

public final class SlaveContext {
    private final int machineId;
    private final Tx[] lastAppliedTransactions;
    private final int eventIdentifier;
    private final int hashCode;
    private final long sessionId;
    private final int masterId;
    private final long checksum;
    public static SlaveContext EMPTY = new SlaveContext(-1L, -1, -1, new Tx[0], -1, -1L);

    public static Tx lastAppliedTx(String dataSourceName, long txId) {
        return new Tx(dataSourceName, txId);
    }

    public SlaveContext(long sessionId, int machineId, int eventIdentifier, Tx[] lastAppliedTransactions, int masterId, long checksum) {
        this.sessionId = sessionId;
        this.machineId = machineId;
        this.eventIdentifier = eventIdentifier;
        this.lastAppliedTransactions = lastAppliedTransactions;
        this.masterId = masterId;
        this.checksum = checksum;
        long hash = sessionId;
        hash = 31L * hash ^ (long)eventIdentifier;
        hash = 31L * hash ^ (long)machineId;
        this.hashCode = (int)(hash >>> 32 ^ hash);
    }

    public int machineId() {
        return this.machineId;
    }

    public Tx[] lastAppliedTransactions() {
        return this.lastAppliedTransactions;
    }

    public int getEventIdentifier() {
        return this.eventIdentifier;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public int getMasterId() {
        return this.masterId;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public String toString() {
        return "SlaveContext[session: " + this.sessionId + ", ID:" + this.machineId + ", eventIdentifier:" + this.eventIdentifier + ", " + Arrays.asList(this.lastAppliedTransactions) + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SlaveContext)) {
            return false;
        }
        SlaveContext o = (SlaveContext)obj;
        return o.eventIdentifier == this.eventIdentifier && o.machineId == this.machineId && o.sessionId == this.sessionId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static SlaveContext anonymous(Tx[] lastAppliedTransactions) {
        return new SlaveContext(SlaveContext.EMPTY.sessionId, SlaveContext.EMPTY.machineId, SlaveContext.EMPTY.eventIdentifier, lastAppliedTransactions, SlaveContext.EMPTY.masterId, SlaveContext.EMPTY.checksum);
    }

    public static class Tx {
        private final String dataSourceName;
        private final long txId;

        private Tx(String dataSourceName, long txId) {
            this.dataSourceName = dataSourceName;
            this.txId = txId;
        }

        public String getDataSourceName() {
            return this.dataSourceName;
        }

        public long getTxId() {
            return this.txId;
        }

        public String toString() {
            return this.dataSourceName + "/" + this.txId;
        }
    }
}

