/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.com.StoreWriter;

public class ToFileStoreWriter
implements StoreWriter {
    private final File basePath;

    public ToFileStoreWriter(String graphDbStoreDir) {
        this.basePath = new File(graphDbStoreDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
        try {
            temporaryBuffer.clear();
            File file = new File(this.basePath, path);
            RandomAccessFile randomAccessFile = null;
            try {
                file.getParentFile().mkdirs();
                randomAccessFile = new RandomAccessFile(file, "rw");
                if (hasData) {
                    FileChannel channel = randomAccessFile.getChannel();
                    while (data.read(temporaryBuffer) >= 0) {
                        temporaryBuffer.flip();
                        channel.write(temporaryBuffer);
                        temporaryBuffer.clear();
                    }
                }
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException(t);
        }
    }

    @Override
    public void done() {
    }
}

