/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.BlockLogBuffer;
import org.neo4j.com.Protocol;
import org.neo4j.com.StoreWriter;

public class ToNetworkStoreWriter
implements StoreWriter {
    private final ChannelBuffer targetBuffer;

    public ToNetworkStoreWriter(ChannelBuffer targetBuffer) {
        this.targetBuffer = targetBuffer;
    }

    @Override
    public void write(String path, ReadableByteChannel data, ByteBuffer temporaryBuffer, boolean hasData) throws IOException {
        char[] chars = path.toCharArray();
        this.targetBuffer.writeShort(chars.length);
        Protocol.writeChars(this.targetBuffer, chars);
        this.targetBuffer.writeByte(hasData ? 1 : 0);
        BlockLogBuffer buffer = new BlockLogBuffer(this.targetBuffer);
        if (hasData) {
            buffer.write(data);
            buffer.done();
        }
    }

    @Override
    public void done() {
        this.targetBuffer.writeShort(0);
    }
}

