/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import java.util.Iterator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;

public class AllPaths
implements PathFinder<Path> {
    private final RelationshipExpander expander;
    private final int maxDepth;

    public AllPaths(int maxDepth, RelationshipExpander expander) {
        this.maxDepth = maxDepth;
        this.expander = expander;
    }

    @Override
    public Iterable<Path> findAllPaths(Node start, final Node end) {
        Predicate<Path> filter = new Predicate<Path>(){

            public boolean accept(Path pos) {
                return pos.endNode().equals(end);
            }
        };
        return Traversal.description().expand(this.expander).depthFirst().filter((Predicate)filter).prune(Traversal.pruneAfterDepth((int)this.maxDepth)).uniqueness((UniquenessFactory)this.uniqueness()).traverse(start);
    }

    protected Uniqueness uniqueness() {
        return Uniqueness.RELATIONSHIP_PATH;
    }

    @Override
    public Path findSinglePath(Node start, Node end) {
        Iterator<Path> paths = this.findAllPaths(start, end).iterator();
        return paths.hasNext() ? paths.next() : null;
    }
}

