/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOSession;
import com.webobjects.directtoweb.D2W;
import com.webobjects.directtoweb.D2WComponent;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.directtoweb.D2WModel;
import com.webobjects.directtoweb.ERD2WContext;
import com.webobjects.directtoweb.ListPageInterface;
import com.webobjects.directtoweb.NextPageDelegate;
import com.webobjects.directtoweb.QueryPageInterface;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSForwardException;
import er.directtoweb.ERD2WFactory;
import er.directtoweb.delegates.ERDBranchDelegate;
import er.extensions.eof.ERXEC;
import er.extensions.foundation.ERXPatcher;
import org.apache.log4j.Logger;

public class ERD2WControllerFactory
extends ERD2WFactory {
    private static final Logger log = Logger.getLogger(ERD2WControllerFactory.class);

    public static ERD2WControllerFactory controllerFactory() {
        return (ERD2WControllerFactory)D2W.factory();
    }

    protected ERD2WController controllerInstanceWithContext(D2WContext d2wContext) {
        ERD2WController c = (ERD2WController)d2wContext.valueForKey("controller");
        try {
            String controllerClassName = (String)d2wContext.valueForKey("controllerClassName");
            if (controllerClassName != null) {
                c = (ERD2WController)ERXPatcher.classForName((String)controllerClassName).newInstance();
            }
        }
        catch (Exception ex) {
            throw new NSForwardException((Throwable)ex);
        }
        if (c != null) {
            c.setD2WContext(d2wContext);
            c.setSession((WOSession)d2wContext.valueForKey("session"));
            c.setControllerName((String)d2wContext.valueForKey("controllerName"));
            c.d2wContext().setDynamicPage((String)d2wContext.valueForKey("pageConfiguration"));
        }
        return c;
    }

    public ERD2WController controllerForName(String controllerName, WOSession session) {
        this.myCheckRules();
        D2WContext newContext = ERD2WContext.newContext(session);
        newContext.takeValueForKey((Object)controllerName, "controllerName");
        ERD2WController c = this.controllerInstanceWithContext(newContext);
        return c;
    }

    public ERD2WController controllerForTaskAndEntityNamed(String task, String entityName, WOSession session) {
        EOEntity newEntity;
        this.myCheckRules();
        D2WContext newContext = ERD2WContext.newContext(session);
        newContext.setTask(task);
        EOEntity eOEntity = newEntity = entityName != null ? EOModelGroup.defaultGroup().entityNamed(entityName) : null;
        if (newEntity != null) {
            newContext.setEntity(newEntity);
        }
        String controllerName = "__" + task + "__" + entityName;
        newContext.takeValueForKey((Object)controllerName, "controllerName");
        ERD2WController c = this.controllerInstanceWithContext(newContext);
        return c;
    }

    public static class ERCQuery
    extends ERCCore {
        protected EODataSource dataSource;

        public WOComponent searchAction(WOComponent currentPage) {
            D2WContext d2wContext = ((D2WComponent)currentPage.parent()).d2wContext();
            EODataSource ds = ((QueryPageInterface)currentPage.parent()).queryDataSource();
            log.info((Object)("searchAction: " + ds));
            ListPageInterface listpageinterface = null;
            String listConfigurationName = (String)d2wContext.valueForKey("listConfigurationName");
            if (listConfigurationName == null) {
                listConfigurationName = "__list__" + this.d2wContext().entity().name();
            }
            listpageinterface = (ListPageInterface)this.pageForConfigurationNamed(listConfigurationName);
            listpageinterface.setDataSource(ds);
            listpageinterface.setNextPage(this.returnPage());
            return (WOComponent)listpageinterface;
        }

        public void setDataSource(EODataSource value) {
            this.dataSource = value;
        }

        public WOComponent firstPage(String pageConfiguration) {
            QueryPageInterface qpi = (QueryPageInterface)this.pageForConfigurationNamed(pageConfiguration);
            qpi.setNextPageDelegate((NextPageDelegate)this);
            return (WOComponent)qpi;
        }
    }

    public static class ERCCreate
    extends ERCEdit {
        public EOEditingContext ec;

        public WOComponent runWithPageConfiguration(String value) {
            WOComponent start = super.runWithPageConfiguration(value);
            EOEditingContext ec = ERXEC.newEditingContext();
            EOEnterpriseObject eo = EOUtilities.createAndInsertInstance((EOEditingContext)ec, (String)this.d2wContext().entity().name());
            this.setObject(eo);
            start.takeValueForKey((Object)this.object(), "object");
            return start;
        }
    }

    public static class ERCEdit
    extends ERCSingleObject {
        public WOComponent cancelChangesAction(WOComponent sender) {
            if (this.editingContext().hasChanges()) {
                log.info((Object)("Reverting changes: " + this.object()));
                this.editingContext().revert();
            }
            return this.returnPage();
        }

        public WOComponent saveChangesAction(WOComponent sender) {
            if (this.editingContext().hasChanges()) {
                log.info((Object)("Has changes: " + this.object()));
                this.editingContext().saveChanges();
            }
            return this.returnPage();
        }
    }

    public static class ERCInspect
    extends ERCSingleObject {
        public WOComponent deleteObjectAction(WOComponent sender) {
            if (this.editingContext() != null) {
                log.info((Object)("Deleting Object: " + this.object()));
                this.editingContext().deleteObject(this.object());
                this.editingContext().saveChanges();
            }
            return this.returnPage();
        }
    }

    public static class ERCSingleObject
    extends ERCCore {
        protected Object pk;
        protected EOEnterpriseObject object;
        protected EOEditingContext editingContext;

        public WOComponent runWithPageConfiguration(String value) {
            WOComponent start = super.runWithPageConfiguration(value);
            start.takeValueForKey((Object)this.object(), "object");
            return start;
        }

        public EOEnterpriseObject object() {
            if (this.object == null && this.pk != null) {
                this.object = EOUtilities.objectWithPrimaryKeyValue((EOEditingContext)this.editingContext(), (String)this.d2wContext().entity().name(), (Object)this.pk);
            }
            return this.object;
        }

        public void setObject(EOEnterpriseObject value) {
            this.object = value;
        }

        public EOEditingContext editingContext() {
            if (this.editingContext == null) {
                EOEditingContext eOEditingContext = this.editingContext = this.object == null ? null : this.object.editingContext();
                if (this.editingContext == null) {
                    this.editingContext = this.session().defaultEditingContext();
                }
            }
            return this.editingContext;
        }

        public void setEditingContext(EOEditingContext value) {
            this.editingContext = value;
        }

        public void setPrimaryKeyValue(Object value) {
            this.pk = value;
        }
    }

    public static class ERCCore
    extends ERD2WController {
        protected WOComponent pageWithContextTaskEntity(String task, String entityName) {
            EOEntity eoentity;
            D2WModel.defaultModel().checkRules();
            EOEntity eOEntity = eoentity = entityName == null ? null : EOModelGroup.defaultGroup().entityNamed(entityName);
            if (eoentity == null && entityName != null && !entityName.equals("") && !entityName.equals("*all*")) {
                throw new IllegalArgumentException("Could not find entity named " + entityName);
            }
            this.d2wContext().setTask(task);
            this.d2wContext().setEntity(eoentity);
            WOComponent wocomponent = WOApplication.application().pageWithName(this.d2wContext().pageName(), this.session().context());
            if (wocomponent instanceof D2WComponent) {
                ((D2WComponent)wocomponent).setLocalContext(this.d2wContext());
            }
            return wocomponent;
        }

        protected WOComponent pageForConfigurationNamed(String pageConfiguration) {
            D2WModel.defaultModel().checkRules();
            this.d2wContext().setDynamicPage(pageConfiguration);
            if (this.d2wContext().entity() == null || this.d2wContext().task() == null) {
                throw new IllegalArgumentException("Either no entity or task for pc: " + pageConfiguration);
            }
            WOComponent wocomponent = WOApplication.application().pageWithName(this.d2wContext().pageName(), this.session().context());
            if (wocomponent instanceof D2WComponent) {
                ((D2WComponent)wocomponent).setLocalContext(this.d2wContext());
            }
            return wocomponent;
        }

        public WOComponent firstPage() {
            return this.runWithPageConfiguration((String)this.d2wContext().valueForKey("pageConfiguration"));
        }

        public WOComponent runWithPageConfiguration(String value) {
            WOComponent page = this.pageForConfigurationNamed(value);
            page.takeValueForKey((Object)this, "nextPageDelegate");
            return page;
        }

        public WOComponent returnAction(WOComponent sender) {
            return this.returnPage();
        }

        protected WOComponent returnPage() {
            return this.finalPage;
        }
    }

    public static class ERD2WController
    extends ERDBranchDelegate {
        protected WOSession session;
        protected WOComponent finalPage;
        protected D2WContext d2wContext;
        protected String controllerName;

        public ERD2WController(D2WContext c) {
            this.d2wContext = c;
        }

        public ERD2WController() {
        }

        public String controllerName() {
            return this.controllerName;
        }

        public void setControllerName(String value) {
            this.controllerName = value;
        }

        public WOComponent finalPage() {
            return this.finalPage;
        }

        public void setFinalPage(WOComponent c) {
            this.finalPage = c;
        }

        public D2WContext d2wContext() {
            if (this.d2wContext == null) {
                this.d2wContext = ERD2WContext.newContext(this.session());
            }
            return this.d2wContext;
        }

        public void setD2wContext(D2WContext value) {
            this.setD2WContext(value);
        }

        public void setD2WContext(D2WContext value) {
            this.d2wContext = value;
        }

        public WOSession session() {
            if (this.session == null) {
                this.session = this.finalPage() == null ? null : this.finalPage().session();
            }
            return this.session;
        }

        public void setSession(WOSession s) {
            this.session = s;
        }

        public WOComponent firstPage() {
            return this.finalPage;
        }

        public void setFirstPage(WOComponent value) {
            this.finalPage = value;
        }

        public WOContext context() {
            return this.session().context();
        }
    }
}

