/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.assignments;

import com.webobjects.directtoweb.D2WContext;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.foundation.NSArray;
import er.directtoweb.assignments.ERDAssignment;
import er.directtoweb.assignments.ERDLocalizableAssignmentInterface;
import org.apache.log4j.Logger;

public class ERDImageNameAssignment
extends ERDAssignment
implements ERDLocalizableAssignmentInterface {
    public static final Logger log = Logger.getLogger((String)"er.directtoweb.rules.ERDImageNameAssignment");
    public static final NSArray _DEPENDENT_KEYS = new NSArray((Object[])new String[]{"baseImageDirectory", "sectionKey", "tabKey"});

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver eokeyvalueunarchiver) {
        return new ERDImageNameAssignment(eokeyvalueunarchiver);
    }

    public ERDImageNameAssignment(EOKeyValueUnarchiver u) {
        super(u);
    }

    public ERDImageNameAssignment(String key, Object value) {
        super(key, value);
    }

    public NSArray dependentKeys(String keyPath) {
        return _DEPENDENT_KEYS;
    }

    public String imageNameForKey(String key, String baseImageDirectory, String prefix) {
        String imageName = null;
        if (key != null && baseImageDirectory != null) {
            String name = NSArray.componentsSeparatedByString((String)key, (String)" ").componentsJoinedByString("");
            imageName = baseImageDirectory + prefix + name + ".gif";
        }
        return imageName;
    }

    public Object sectionImageName(D2WContext c) {
        String sectionKey = (String)c.valueForKey("sectionKey");
        String baseImageDirectory = (String)c.valueForKey("baseImageDirectory");
        if (sectionKey == null) {
            log.warn((Object)("SectionKey is null for pageConfiguration: " + c.valueForKey("pageConfiguration")));
        }
        if (baseImageDirectory == null) {
            log.warn((Object)("BaseImageDirectory is null for sectionKey: " + sectionKey + " and pageConfiguration: " + c.valueForKey("pageConfiguration")));
        }
        return this.imageNameForKey(sectionKey, baseImageDirectory, "section");
    }

    public Object tabImageName(D2WContext c) {
        String tabKey = (String)c.valueForKey("tabKey");
        String baseImageDirectory = (String)c.valueForKey("baseImageDirectory");
        if (tabKey == null) {
            log.warn((Object)("TabKey is null for pageConfiguration: " + c.valueForKey("pageConfiguration")));
        }
        if (baseImageDirectory == null) {
            log.warn((Object)("BaseImageDirectory is null for tabKey: " + tabKey + " and pageConfiguration: " + c.valueForKey("pageConfiguration")));
        }
        return this.imageNameForKey(tabKey, baseImageDirectory, "tab");
    }
}

