/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.components.misc;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.appserver.WOSession;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOObjectNotAvailableException;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOKeyValueArchiver;
import com.webobjects.eocontrol.EOKeyValueArchiving;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.eocontrol.EOSharedEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import er.extensions.appserver.ERXSession;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSelectorUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public abstract class ERDSavedQueriesComponent
extends WOComponent {
    public static final Logger log = Logger.getLogger(ERDSavedQueriesComponent.class);
    public static final EOKeyValueArchiving.Support originalEOKVArchivingTimestampSupport = new EOKeyValueArchiving._TimestampSupport();
    public static final EOKeyValueArchiving.Support newEOKVArchivingTimestampSupport = new _TimestampSupport();
    public static final EOKeyValueArchiving.Support originalEOKVArchiningTimestampSupport = originalEOKVArchivingTimestampSupport;
    public static final EOKeyValueArchiving.Support newEOKVArchiningTimestampSupport = newEOKVArchivingTimestampSupport;
    private NSKeyValueCoding _userPreferences = null;
    private NSMutableArray _savedQueries = null;
    public SavedQuery aSavedQuery = null;
    public SavedQuery selectedSavedQuery = null;
    public String newQueryName = null;
    public final String DEFAULT_QUERY_NONE = "";
    public boolean needsAutoSubmit = false;
    private static SavedQuery emptySavedQueryForDeletes = new SavedQuery();

    public ERDSavedQueriesComponent(WOContext context) {
        super(context);
    }

    protected NSKeyValueCoding userPreferences() {
        if (this._userPreferences == null) {
            this._userPreferences = ERDSavedQueriesComponent.userPreferences(this.session());
        }
        return this._userPreferences;
    }

    static NSKeyValueCoding userPreferences(WOSession session) {
        NSKeyValueCoding result = null;
        Class prefClass = ERXPatcher.classForName((String)"ERCoreUserPreferences");
        if (prefClass == null) {
            result = (NSKeyValueCoding)session.objectForKey("ERCoreUserPreferences");
            if (result == null) {
                result = new NSMutableDictionary();
                session.setObjectForKey((Object)result, "ERCoreUserPreferences");
            }
        } else {
            NSSelector s = new NSSelector("userPreferences", new Class[0]);
            result = (NSKeyValueCoding)ERXSelectorUtilities.invoke((NSSelector)s, (Object)prefClass);
        }
        return result;
    }

    public static String userPreferenceNameForPageConfiguration(String pageConfiguration) {
        return "SavedQueryFor:" + pageConfiguration;
    }

    public static String userPreferenceNameForDefaultQueryWithPageConfiguration(String pageConfiguration) {
        return "DefaultQueryNameFor:" + pageConfiguration;
    }

    public static String userPreferenceNameForAutoSubmitWithPageConfiguration(String pageConfiguration) {
        return "AutoSubmitQueryFor:" + pageConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSMutableArray loadSavedQueriesForPageConfigurationNamed(String pageConfigurationName) {
        NSArray savedQueries = null;
        EOKeyValueArchiving.Support.setSupportForClass((EOKeyValueArchiving.Support)newEOKVArchivingTimestampSupport, (Class)NSTimestamp._CLASS);
        try {
            savedQueries = (NSArray)this.userPreferences().valueForKey(ERDSavedQueriesComponent.userPreferenceNameForPageConfiguration(pageConfigurationName));
        }
        finally {
            EOKeyValueArchiving.Support.setSupportForClass((EOKeyValueArchiving.Support)originalEOKVArchivingTimestampSupport, (Class)NSTimestamp._CLASS);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadSavedQueriesForPageConfigurationNamed(" + pageConfigurationName + "): queries = " + savedQueries));
        }
        return savedQueries == null ? new NSMutableArray() : savedQueries.mutableClone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSDictionary savedQueriesForPageConfigurationNamed(WOSession session, String pageConfigurationName) {
        NSArray savedQueries = null;
        NSKeyValueCoding userPreferences = ERDSavedQueriesComponent.userPreferences(session);
        EOKeyValueArchiving.Support.setSupportForClass((EOKeyValueArchiving.Support)newEOKVArchivingTimestampSupport, (Class)NSTimestamp._CLASS);
        try {
            savedQueries = (NSArray)userPreferences.valueForKey(ERDSavedQueriesComponent.userPreferenceNameForPageConfiguration(pageConfigurationName));
        }
        finally {
            EOKeyValueArchiving.Support.setSupportForClass((EOKeyValueArchiving.Support)originalEOKVArchivingTimestampSupport, (Class)NSTimestamp._CLASS);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadSavedQueriesForPageConfigurationNamed(" + pageConfigurationName + "): queries = " + savedQueries));
        }
        if (savedQueries != null) {
            return ERXArrayUtilities.arrayGroupedByKeyPath((NSArray)savedQueries, (String)"name", (boolean)false, null);
        }
        return NSDictionary.emptyDictionary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveQueriesForPageConfigurationNamed(NSArray queries, String pageConfigurationName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveQueriesForPageConfigurationNamed(" + pageConfigurationName + "): queries = " + queries));
        }
        EOKeyValueArchiving.Support.setSupportForClass((EOKeyValueArchiving.Support)newEOKVArchivingTimestampSupport, (Class)NSTimestamp._CLASS);
        try {
            this.userPreferences().takeValueForKey((Object)queries, ERDSavedQueriesComponent.userPreferenceNameForPageConfiguration(pageConfigurationName));
        }
        finally {
            EOKeyValueArchiving.Support.setSupportForClass((EOKeyValueArchiving.Support)originalEOKVArchivingTimestampSupport, (Class)NSTimestamp._CLASS);
        }
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public boolean isStateless() {
        return false;
    }

    public void sleep() {
        this.needsAutoSubmit = false;
        super.sleep();
    }

    public D2WContext d2wContext() {
        return (D2WContext)this.valueForBinding("localContext");
    }

    public WODisplayGroup displayGroup() {
        return (WODisplayGroup)this.valueForBinding("displayGroup");
    }

    public String pageConfiguration() {
        return (String)this.d2wContext().valueForKey("pageConfiguration");
    }

    public NSMutableArray savedQueries() {
        if (this._savedQueries == null) {
            String pageConfiguration = this.pageConfiguration();
            this._savedQueries = this.loadSavedQueriesForPageConfigurationNamed(pageConfiguration);
            String defaultName = this.defaultQueryNameForPageConfiguration(pageConfiguration);
            this.selectedSavedQuery = null;
            if (this._savedQueries.count() > 0 && !"".equals(defaultName)) {
                Enumeration queryEnum = this._savedQueries.objectEnumerator();
                while (queryEnum.hasMoreElements()) {
                    SavedQuery aQuery = (SavedQuery)queryEnum.nextElement();
                    if (!defaultName.equals(aQuery.name())) continue;
                    this.selectedSavedQuery = aQuery;
                    this.selectedSavedQuery.sendValuesToDisplayGroup(this.displayGroup(), false);
                    this.newQueryName = this.selectedSavedQuery.name();
                    break;
                }
            }
        }
        return this._savedQueries;
    }

    public WOComponent popupChangedSelection() {
        if (this.selectedSavedQuery != null) {
            this.selectedSavedQuery.sendValuesToDisplayGroup(this.displayGroup(), true);
            this.newQueryName = this.selectedSavedQuery.name();
            this.needsAutoSubmit = this.autoSubmitEnabled();
        } else {
            this.clearForm();
        }
        return null;
    }

    public WOComponent refresh() {
        return this.context().page();
    }

    public boolean autoSubmitEnabled() {
        return ERXValueUtilities.booleanValue((Object)this.userPreferences().valueForKey(ERDSavedQueriesComponent.userPreferenceNameForAutoSubmitWithPageConfiguration(this.pageConfiguration())));
    }

    public void setAutoSubmitEnabled(boolean b) {
        this.userPreferences().takeValueForKey((Object)(b ? "1" : "0"), ERDSavedQueriesComponent.userPreferenceNameForAutoSubmitWithPageConfiguration(this.pageConfiguration()));
    }

    public WOComponent addNewQuery() {
        SavedQuery newQuery = new SavedQuery(this.newQueryName, this.displayGroup());
        this._savedQueries.addObject((Object)newQuery);
        this.selectedSavedQuery = newQuery;
        this.saveQueriesForPageConfigurationNamed((NSArray)this._savedQueries, this.pageConfiguration());
        return null;
    }

    public WOComponent updateCurrentQuery() {
        if (this.newQueryName != null && this.newQueryName.trim().length() > 0) {
            if (this.isDefaultQuery(this.selectedSavedQuery)) {
                this.setDefaultQueryNameForPageConfiguration(this.newQueryName, this.pageConfiguration());
            }
            this.selectedSavedQuery.setName(this.newQueryName);
        }
        this.selectedSavedQuery.getValuesFromDisplayGroup(this.displayGroup());
        if (ERXProperties.booleanForKeyWithDefault((String)"er.neutral.ERDSavedQueriesComponent.saveAfterUpdating", (boolean)true)) {
            this.saveQueriesForPageConfigurationNamed((NSArray)this._savedQueries, this.pageConfiguration());
        }
        return null;
    }

    public WOComponent deleteCurrentQuery() {
        if (this.selectedSavedQuery != null) {
            this._savedQueries.removeObject((Object)this.selectedSavedQuery);
            this.saveQueriesForPageConfigurationNamed((NSArray)this._savedQueries, this.pageConfiguration());
            if (this.isDefaultQuery(this.selectedSavedQuery)) {
                this.setDefaultQueryNameForPageConfiguration("", this.pageConfiguration());
            }
            this.selectedSavedQuery = null;
        }
        return this.clearForm();
    }

    public WOComponent deleteAllSavedQueries() {
        this._savedQueries.removeAllObjects();
        this.saveQueriesForPageConfigurationNamed((NSArray)this._savedQueries, this.pageConfiguration());
        this.selectedSavedQuery = null;
        return this.clearForm();
    }

    public WOComponent clearForm() {
        this.selectedSavedQuery = null;
        this.newQueryName = null;
        emptySavedQueryForDeletes.sendValuesToDisplayGroup(this.displayGroup(), true);
        return null;
    }

    public WOComponent makeDefaultSavedQuery() {
        String aQueryName = this.selectedSavedQuery != null ? this.selectedSavedQuery.name() : "";
        this.setDefaultQueryNameForPageConfiguration(aQueryName, this.pageConfiguration());
        return null;
    }

    public String defaultQueryNameForPageConfiguration(String pageConfigurationName) {
        String defaultQueryName = (String)this.userPreferences().valueForKey(ERDSavedQueriesComponent.userPreferenceNameForDefaultQueryWithPageConfiguration(pageConfigurationName));
        if (log.isDebugEnabled()) {
            log.debug((Object)("defaultQueryNameForPageConfiguration(" + pageConfigurationName + "): defaultQueryName = " + defaultQueryName));
        }
        return defaultQueryName != null ? defaultQueryName : "";
    }

    public void setDefaultQueryNameForPageConfiguration(String aName, String pageConfigurationName) {
        this.userPreferences().takeValueForKey((Object)aName, ERDSavedQueriesComponent.userPreferenceNameForDefaultQueryWithPageConfiguration(pageConfigurationName));
        if (log.isDebugEnabled()) {
            log.debug((Object)("setDefaultQueryNameForPageConfiguration(" + pageConfigurationName + "): defaultQueryName = " + aName));
        }
    }

    public boolean isSelectedQueryTheDefault() {
        return this.isDefaultQuery(this.selectedSavedQuery);
    }

    public boolean isNoSelectedQuery() {
        return this.selectedSavedQuery == null;
    }

    public boolean hasNoSavedQueries() {
        return this._savedQueries.count() == 0;
    }

    public boolean isDefaultQuery(SavedQuery aQuery) {
        String queryName = aQuery != null ? aQuery.name() : "";
        return queryName.equals(this.defaultQueryNameForPageConfiguration(this.pageConfiguration()));
    }

    public NSDictionary queryParamsToFetchSavedQueryResults() {
        NSMutableDictionary dict = new NSMutableDictionary();
        dict.setObjectForKey((Object)this.pageConfiguration(), (Object)"pconfig");
        dict.setObjectForKey((Object)this.selectedSavedQuery.name(), (Object)"qname");
        dict.setObjectForKey((Object)this.d2wContext().entity().name(), (Object)"ename");
        return dict.immutableClone();
    }

    public String fetchSavedQueryResultsLink() {
        StringBuffer url = new StringBuffer();
        WOContext newContext = new WOContext(this.context().request());
        newContext._url().setApplicationNumber("-1");
        newContext.request()._completeURLPrefix(url, false, 0);
        NSMutableDictionary requestParams = new NSMutableDictionary();
        requestParams.setObjectForKey((Object)this.pageConfiguration(), (Object)"pconfig");
        requestParams.setObjectForKey((Object)this.d2wContext().entity().name(), (Object)"ename");
        try {
            requestParams.setObjectForKey((Object)URLEncoder.encode(this.selectedSavedQuery.name(), "UTF-8"), (Object)"qname");
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"error generating bookmarkable url", (Throwable)e);
        }
        String directActionName = (String)this.d2wContext().valueForKey("directActionNameToFetchSavedQueryResults");
        url.append(newContext.directActionURLForActionNamed(directActionName, (NSDictionary)requestParams));
        return url.toString();
    }

    public boolean showBookmarkableQueryResultsLink() {
        return this.selectedSavedQuery != null && this.d2wContext().valueForKey("directActionNameToFetchSavedQueryResults") != null;
    }

    public static interface RequestParams {
        public static final String PageConfiguration = "pconfig";
        public static final String EntityName = "ename";
        public static final String SavedQueryName = "qname";
    }

    public static class _TimestampSupport
    extends EOKeyValueArchiving.Support {
        private static NSTimestampFormatter _formatter = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S");

        public void encodeWithKeyValueArchiver(Object receiver, EOKeyValueArchiver archiver) {
            archiver.encodeObject((Object)_formatter.format(receiver), "value");
        }

        public Object decodeObjectWithKeyValueUnarchiver(EOKeyValueUnarchiver unarchiver) {
            try {
                return _formatter.parseObject((String)unarchiver.decodeObjectForKey("value"));
            }
            catch (ParseException exception) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
            }
        }
    }

    public static class SavedQuery
    implements NSKeyValueCoding,
    EOKeyValueArchiving {
        private NSMutableDictionary dict = new NSMutableDictionary();
        public static final String NAME_KEY = "name";
        public static final String QUERY_MIN_KEY = "queryMin";
        public static final String QUERY_MAX_KEY = "queryMax";
        public static final String QUERY_MATCH_KEY = "queryMatch";
        public static final String QUERY_OPERATOR_KEY = "queryOperator";
        public static final String QUERY_BINDINGS_KEY = "queryBindings";

        public SavedQuery() {
        }

        public SavedQuery(String name, WODisplayGroup displayGroup) {
            this();
            this.setName(name);
            this.getValuesFromDisplayGroup(displayGroup);
        }

        protected static String logDictionary(String title, NSDictionary dictionary, String indentStr) {
            StringBuffer buf = new StringBuffer();
            buf.append("\r\n" + indentStr + "==========" + (title != null ? title : "") + "==================\r\n");
            buf.append(indentStr + "Dictionary dump, count=" + dictionary.count() + "\r\n");
            Enumeration anEnum = dictionary.keyEnumerator();
            while (anEnum.hasMoreElements()) {
                String key = (String)anEnum.nextElement();
                Object value = dictionary.objectForKey((Object)key);
                buf.append(indentStr + "key=" + key);
                buf.append(", valueClass=" + value.getClass().getName());
                buf.append(", toString = " + value.toString() + "\r\n");
                if (!(value instanceof NSDictionary)) continue;
                SavedQuery.logDictionary(null, (NSDictionary)value, indentStr + "    ");
            }
            buf.append(indentStr + "============================\r\n");
            return buf.toString();
        }

        public void sendValuesToDisplayGroup(WODisplayGroup displayGroup, boolean clearFormFirst) {
            SavedQuery.sendValuesToDisplayGroup(this, displayGroup, clearFormFirst);
        }

        public static void sendValuesToDisplayGroup(SavedQuery savedQuery, WODisplayGroup displayGroup, boolean clearFormFirst) {
            SavedQuery.updateDisplayGroupForKey(savedQuery, displayGroup, QUERY_MIN_KEY, clearFormFirst);
            SavedQuery.updateDisplayGroupForKey(savedQuery, displayGroup, QUERY_MAX_KEY, clearFormFirst);
            SavedQuery.updateDisplayGroupForKey(savedQuery, displayGroup, QUERY_MATCH_KEY, clearFormFirst);
            SavedQuery.updateDisplayGroupForKey(savedQuery, displayGroup, QUERY_OPERATOR_KEY, clearFormFirst);
            SavedQuery.updateDisplayGroupForKey(savedQuery, displayGroup, QUERY_BINDINGS_KEY, clearFormFirst);
        }

        static NSMutableDictionary updateDisplayGroupForKey(SavedQuery savedQuery, WODisplayGroup displayGroup, String key, boolean clearFormFirst) {
            NSDictionary source = (NSDictionary)savedQuery.valueForKey(key);
            NSMutableDictionary destination = (NSMutableDictionary)displayGroup.valueForKey(key);
            if (log.isDebugEnabled()) {
                log.debug((Object)("\r\nBEGIN key=" + key + ", destination.class=" + destination.getClass().getName() + ", destination.hashCode=" + destination.hashCode() + ", destination=" + destination));
            }
            if (clearFormFirst && ERXProperties.booleanForKeyWithDefault((String)"er.neutral.ERDSavedQueriesComponent.removeAllObjectBeforeUpdating", (boolean)true)) {
                destination.removeAllObjects();
            }
            if (source != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("source != null, adding to destination.  source=" + source));
                }
                destination.addEntriesFromDictionary(source);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"source == null, NOT adding to destination.");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("END key=" + key + ", destination.class=" + destination.getClass().getName() + ", destination=" + destination + "\r\n"));
                log.debug((Object)SavedQuery.logDictionary(key, (NSDictionary)destination, "**"));
            }
            return destination;
        }

        public void getValuesFromDisplayGroup(WODisplayGroup displayGroup) {
            if (displayGroup != null) {
                this.setQueryMin((NSDictionary)displayGroup.queryMin().mutableClone());
                this.setQueryMax((NSDictionary)displayGroup.queryMax().mutableClone());
                this.setQueryMatch((NSDictionary)displayGroup.queryMatch().mutableClone());
                this.setQueryOperator((NSDictionary)displayGroup.queryOperator().mutableClone());
                this.setQueryBindings((NSDictionary)displayGroup.queryBindings().mutableClone());
            }
        }

        public NSDictionary values() {
            return this.dict;
        }

        public String name() {
            return (String)this.dict.objectForKey((Object)NAME_KEY);
        }

        public void setName(String aName) {
            if (aName == null) {
                aName = "Untitled Saved Query";
            }
            this.dict.setObjectForKey((Object)aName, (Object)NAME_KEY);
        }

        public NSDictionary queryMin() {
            return (NSDictionary)this.dict.objectForKey((Object)QUERY_MIN_KEY);
        }

        public void setQueryMin(NSDictionary queryMin) {
            if (queryMin == null) {
                queryMin = NSDictionary.EmptyDictionary;
            }
            this.dict.setObjectForKey((Object)queryMin, (Object)QUERY_MIN_KEY);
        }

        public NSDictionary queryMax() {
            return (NSDictionary)this.dict.objectForKey((Object)QUERY_MAX_KEY);
        }

        public void setQueryMax(NSDictionary queryMax) {
            if (queryMax == null) {
                queryMax = NSDictionary.EmptyDictionary;
            }
            this.dict.setObjectForKey((Object)queryMax, (Object)QUERY_MAX_KEY);
        }

        public NSDictionary queryMatch() {
            return (NSDictionary)this.dict.objectForKey((Object)QUERY_MATCH_KEY);
        }

        public void setQueryMatch(NSDictionary queryMatch) {
            if (queryMatch == null) {
                queryMatch = NSDictionary.EmptyDictionary;
            }
            log.debug((Object)SavedQuery.logDictionary("setQueryMatch", queryMatch, "==="));
            this.dict.setObjectForKey((Object)queryMatch, (Object)QUERY_MATCH_KEY);
        }

        public NSDictionary queryOperator() {
            return (NSDictionary)this.dict.objectForKey((Object)QUERY_OPERATOR_KEY);
        }

        public void setQueryOperator(NSDictionary queryOperator) {
            if (queryOperator == null) {
                queryOperator = NSDictionary.EmptyDictionary;
            }
            this.dict.setObjectForKey((Object)queryOperator, (Object)QUERY_OPERATOR_KEY);
        }

        public NSDictionary queryBindings() {
            return (NSDictionary)this.dict.objectForKey((Object)QUERY_BINDINGS_KEY);
        }

        public void setQueryBindings(NSDictionary queryBindings) {
            if (queryBindings == null) {
                queryBindings = NSDictionary.EmptyDictionary;
            }
            this.dict.setObjectForKey((Object)queryBindings, (Object)QUERY_BINDINGS_KEY);
        }

        public Object valueForKey(String key) {
            return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)key);
        }

        public void takeValueForKey(Object value, String key) {
            NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)value, (String)key);
        }

        public Object handleQueryWithUnboundKey(String key) {
            return NSKeyValueCoding.DefaultImplementation.handleQueryWithUnboundKey((Object)this, (String)key);
        }

        public void handleTakeValueForUnboundKey(Object value, String key) {
            NSKeyValueCoding.DefaultImplementation.handleTakeValueForUnboundKey((Object)this, (Object)value, (String)key);
        }

        public void unableToSetNullForKey(String key) {
            NSKeyValueCoding.DefaultImplementation.unableToSetNullForKey((Object)this, (String)key);
        }

        public void encodeWithKeyValueArchiver(EOKeyValueArchiver archiver) {
            archiver.encodeObject((Object)this.name(), NAME_KEY);
            archiver.encodeObject((Object)this.encodeDictionaryWithEOs((NSDictionary)this.queryMin().mutableClone()), QUERY_MIN_KEY);
            archiver.encodeObject((Object)this.encodeDictionaryWithEOs((NSDictionary)this.queryMax().mutableClone()), QUERY_MAX_KEY);
            archiver.encodeObject((Object)this.encodeDictionaryWithEOs((NSDictionary)this.queryMatch().mutableClone()), QUERY_MATCH_KEY);
            archiver.encodeObject((Object)this.encodeDictionaryWithEOs((NSDictionary)this.queryOperator().mutableClone()), QUERY_OPERATOR_KEY);
            archiver.encodeObject((Object)this.encodeDictionaryWithEOs((NSDictionary)this.queryBindings().mutableClone()), QUERY_BINDINGS_KEY);
        }

        public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver unarchiver) {
            return new SavedQuery(unarchiver);
        }

        private SavedQuery(EOKeyValueUnarchiver unarchiver) {
            this();
            this.setName((String)unarchiver.decodeObjectForKey(NAME_KEY));
            this.setQueryMin((NSDictionary)this.decodeDictionaryWithEOs((NSDictionary)unarchiver.decodeObjectForKey(QUERY_MIN_KEY)));
            this.setQueryMax((NSDictionary)this.decodeDictionaryWithEOs((NSDictionary)unarchiver.decodeObjectForKey(QUERY_MAX_KEY)));
            this.setQueryMatch((NSDictionary)this.decodeDictionaryWithEOs((NSDictionary)unarchiver.decodeObjectForKey(QUERY_MATCH_KEY)));
            this.setQueryOperator((NSDictionary)this.decodeDictionaryWithEOs((NSDictionary)unarchiver.decodeObjectForKey(QUERY_OPERATOR_KEY)));
            this.setQueryBindings((NSDictionary)this.decodeDictionaryWithEOs((NSDictionary)unarchiver.decodeObjectForKey(QUERY_BINDINGS_KEY)));
        }

        public String toString() {
            return "SavedQuery: " + this.hashCode() + " dict=" + this.dict;
        }

        private boolean isDictionaryAnEncodedEO(NSDictionary dictionary) {
            return dictionary != null && dictionary.objectForKey((Object)"encodedEO") != null;
        }

        private boolean isDictionaryAnEncodedSharedEO(NSDictionary dictionary) {
            return dictionary != null && dictionary.objectForKey((Object)"encodedSharedEO") != null;
        }

        private NSMutableDictionary encodeEO(EOEnterpriseObject eo) {
            NSMutableDictionary encodedDict = new NSMutableDictionary(3);
            if (eo.editingContext() instanceof EOSharedEditingContext) {
                encodedDict.setObjectForKey((Object)Boolean.TRUE, (Object)"encodedSharedEO");
            } else {
                encodedDict.setObjectForKey((Object)Boolean.TRUE, (Object)"encodedEO");
            }
            encodedDict.setObjectForKey((Object)eo.entityName(), (Object)"entityName");
            encodedDict.setObjectForKey((Object)ERXEOControlUtilities.primaryKeyStringForObject((EOEnterpriseObject)eo), (Object)"pk");
            if (log.isDebugEnabled()) {
                log.debug((Object)("encodeSharedEO, eo=" + eo + ",  encodedDict=" + encodedDict));
            }
            return encodedDict;
        }

        private EOEnterpriseObject decodeEO(NSDictionary dictionary) {
            EOEnterpriseObject eo;
            block8: {
                String entityName = (String)dictionary.objectForKey((Object)"entityName");
                String pk = (String)dictionary.objectForKey((Object)"pk");
                EOEntity entity = ERXEOAccessUtilities.entityNamed(null, (String)entityName);
                eo = null;
                if (entity != null) {
                    EOAttribute primaryKeyAttribute = (EOAttribute)ERXArrayUtilities.firstObject((NSArray)entity.primaryKeyAttributes());
                    Object primaryKeyObject = pk;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("decodeEO with dict: " + dictionary));
                    }
                    if (primaryKeyAttribute != null && !String.class.getName().equals(primaryKeyAttribute.className())) {
                        primaryKeyObject = ERXConstant.integerForString((String)pk);
                    }
                    try {
                        if (this.isDictionaryAnEncodedSharedEO(dictionary)) {
                            eo = ERXEOControlUtilities.sharedObjectWithPrimaryKey((String)entityName, (Object)primaryKeyObject);
                            break block8;
                        }
                        eo = ERXEOControlUtilities.objectWithPrimaryKeyValue((EOEditingContext)ERXSession.session().defaultEditingContext(), (String)entityName, (Object)primaryKeyObject, null);
                    }
                    catch (EOObjectNotAvailableException eoonae) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Unable to restore serialized EO from saved query.  The EO for entity '" + entityName + "' with pk '" + pk + "' was not found."));
                        }
                        break block8;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unable to restore serialized EO from saved query.  Could not find entity '" + entityName + "."));
                }
            }
            return eo;
        }

        protected NSMutableDictionary encodeDictionaryWithEOs(NSDictionary dictionary) {
            NSMutableDictionary theMutableDictionary = (NSMutableDictionary)(dictionary instanceof NSMutableDictionary ? dictionary : dictionary.mutableClone());
            Enumeration anEnum = theMutableDictionary.keyEnumerator();
            while (anEnum.hasMoreElements()) {
                String key = (String)anEnum.nextElement();
                Object value = theMutableDictionary.objectForKey((Object)key);
                if (value instanceof EOEnterpriseObject && !ERXEOControlUtilities.isNewObject((EOEnterpriseObject)((EOEnterpriseObject)value))) {
                    EOEnterpriseObject eo = (EOEnterpriseObject)value;
                    NSMutableDictionary encodedDict = this.encodeEO(eo);
                    theMutableDictionary.setObjectForKey((Object)encodedDict, (Object)key);
                    continue;
                }
                if (!(value instanceof NSDictionary)) continue;
                theMutableDictionary.setObjectForKey((Object)this.encodeDictionaryWithEOs((NSDictionary)value), (Object)key);
            }
            return theMutableDictionary;
        }

        protected Object decodeDictionaryWithEOs(NSDictionary dictionary) {
            NSMutableDictionary theMutableDictionary = (NSMutableDictionary)(dictionary instanceof NSMutableDictionary ? dictionary : dictionary.mutableClone());
            if (this.isDictionaryAnEncodedSharedEO(dictionary) || this.isDictionaryAnEncodedEO(dictionary)) {
                EOEnterpriseObject eo = this.decodeEO(dictionary);
                return eo != null ? eo : dictionary;
            }
            Enumeration anEnum = theMutableDictionary.keyEnumerator();
            while (anEnum.hasMoreElements()) {
                String key = (String)anEnum.nextElement();
                Object value = theMutableDictionary.objectForKey((Object)key);
                if (!(value instanceof NSDictionary)) continue;
                theMutableDictionary.setObjectForKey(this.decodeDictionaryWithEOs((NSDictionary)value), (Object)key);
            }
            return theMutableDictionary;
        }

        public static interface SerializationKeys {
            public static final String EncodedEO = "encodedEO";
            public static final String EncodedSharedEO = "encodedSharedEO";
            public static final String EntityName = "entityName";
            public static final String PrimaryKey = "pk";
        }
    }
}

