/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.components.numbers;

import com.webobjects.appserver.WOContext;
import com.webobjects.directtoweb.D2WEditNumber;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.foundation.NSNumberFormatter;
import com.webobjects.foundation.NSValidation;
import er.extensions.eof.ERXConstant;
import er.extensions.formatters.ERXNumberFormatter;
import er.extensions.validation.ERXValidationFactory;
import java.math.BigDecimal;
import java.text.Format;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class ERD2WEditNumber
extends D2WEditNumber {
    public static final Logger log = Logger.getLogger(ERD2WEditNumber.class);
    private NSNumberFormatter _numberFormatter;

    public ERD2WEditNumber(WOContext context) {
        super(context);
    }

    public void reset() {
        super.reset();
        this._numberFormatter = null;
    }

    public EOAttribute attribute() {
        return super.attribute() != null ? super.attribute() : (EOAttribute)this.d2wContext().valueForKey("smartAttribute");
    }

    protected Format numberFormatter() {
        if (this._numberFormatter == null) {
            this._numberFormatter = ERXNumberFormatter.numberFormatterForPattern((String)this.formatter());
        }
        return this._numberFormatter;
    }

    public Object validateTakeValueForKeyPath(Object anObject, String aPath) throws NSValidation.ValidationException {
        Number number = null;
        try {
            if (anObject instanceof String) {
                number = (Number)this.numberFormatValueForString((String)anObject);
            } else if (anObject != null && !(anObject instanceof Number)) {
                log.warn((Object)("Unable to read number: " + anObject));
                throw ERXValidationFactory.defaultFactory().createException(this.object(), this.propertyKey(), anObject, "NotANumberException");
            }
        }
        catch (NSValidation.ValidationException ex) {
            this.validationFailedWithException(ex, anObject, this.propertyKey());
            throw ex;
        }
        return super.validateTakeValueForKeyPath(this.convertNumber(number), this.propertyKey());
    }

    public void validationFailedWithException(Throwable theException, Object theValue, String theKeyPath) {
        String keyPath = theKeyPath.equals("stringValue") ? this.propertyKey() : theKeyPath;
        Number formatValue = null;
        try {
            if (theValue != null) {
                formatValue = (Number)this.numberFormatter().parseObject((String)theValue);
            }
        }
        catch (Exception ex) {
            formatValue = (Number)this.objectPropertyValue();
        }
        this.parent().validationFailedWithException(theException, (Object)formatValue, keyPath);
    }

    public String stringValue() {
        return this.value() != null ? this.numberFormatter().format(this.value()) : null;
    }

    public void setStringValue(String newStringValue) {
        if (newStringValue != null) {
            this.setValue(this.numberFormatValueForString(newStringValue));
        } else {
            this.setValue(null);
        }
    }

    protected Object numberFormatValueForString(String value) {
        Object formatValue = null;
        try {
            if (value != null) {
                formatValue = this.numberFormatter().parseObject(value);
            }
        }
        catch (ParseException e) {
            log.debug((Object)("Unable to parse number: " + value + " in " + this.propertyKey()));
            throw ERXValidationFactory.defaultFactory().createException(this.object(), this.propertyKey(), (Object)value, "IllegalCharacterInNumberException");
        }
        return formatValue;
    }

    protected Object convertNumber(Object anObject) {
        Number newValue = null;
        if (anObject != null && anObject instanceof Number && (newValue = (Number)anObject) instanceof BigDecimal && !this.isDecimalNumber() && this.attribute().valueType() != null && this.attribute().valueType().equals("i")) {
            newValue = ERXConstant.integerForInt((int)newValue.intValue());
        }
        return newValue;
    }
}

