/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.pages;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.directtoweb.EditPageInterface;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSValidation;
import er.directtoweb.ERD2WContainer;
import er.directtoweb.ERD2WFactory;
import er.directtoweb.interfaces.ERDTabEditPageInterface;
import er.directtoweb.pages.ERD2WInspectPage;
import er.extensions.components._private.ERXWOForm;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import org.apache.log4j.Logger;

public class ERD2WTabInspectPage
extends ERD2WInspectPage
implements ERDTabEditPageInterface {
    public static final String WILL_SWITCH_TAB = "willSwitchTab";
    public static final Logger log = Logger.getLogger(ERD2WTabInspectPage.class);
    public static final Logger validationLog = Logger.getLogger((String)"er.directtoweb.validation.ERD2WTabInspectPage");
    protected Integer _tabNumber;

    public ERD2WTabInspectPage(WOContext c) {
        super(c);
    }

    public String switchTabActionName() {
        return this.isEditing() ? "switchTabAction" : null;
    }

    public boolean switchTabAction() {
        boolean switchTab = true;
        if (this.shouldSaveChangesForTab()) {
            if (validationLog.isDebugEnabled()) {
                validationLog.debug((Object)"Calling tryToSaveChanges");
            }
            switchTab = this.tryToSaveChanges(true);
        }
        if (switchTab && this.errorMessages.count() == 0 && this.object().editingContext().hasChanges() && this.shouldNotSwitchIfHasChanges()) {
            this.validationFailedWithException(new NSValidation.ValidationException("You currently have changes outstanding.  Please either save or cancel your changes before navigating elsewhere."), null, "editingContextChanges");
        }
        return switchTab && this.errorMessages.count() == 0;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        String tabName = this.context().request().stringFormValueForKey("__tab");
        this.setTabByName(tabName);
        if (this.currentTab() == null && this.tabSectionsContents() != null && this.tabSectionsContents().count() > 0) {
            if (this.tabNumber() != null && this.tabNumber() <= this.tabSectionsContents().count()) {
                this.setCurrentTab((ERD2WContainer)this.tabSectionsContents().objectAtIndex(this.tabNumber().intValue()));
            }
            if (this.currentTab() == null) {
                this.setCurrentTab((ERD2WContainer)this.tabSectionsContents().objectAtIndex(0));
            }
        }
        super.appendToResponse(response, context);
    }

    public Integer tabNumber() {
        return this._tabNumber;
    }

    public void setTabNumber(Integer newTabNumber) {
        this._tabNumber = newTabNumber;
    }

    public WOComponent printerFriendlyVersion() {
        WOComponent result = ERD2WFactory.erFactory().printerFriendlyPageForD2WContext(this.d2wContext(), this.session());
        ((EditPageInterface)result).setObject(this.object());
        return result;
    }

    public void awake() {
        super.awake();
    }

    public void setTabByName(String tabName) {
        if (tabName != null) {
            int i = 0;
            for (ERD2WContainer container : this.tabSectionsContents()) {
                if (tabName.equals(container.name)) {
                    this.setTabNumber(i);
                    this.setCurrentTab(container);
                    break;
                }
                ++i;
            }
        }
    }

    public String urlForCurrentState() {
        String url = super.urlForCurrentState();
        if (this.currentTab() != null) {
            url = url + "&__tab=" + ERXStringUtilities.urlEncode((String)this.currentTab().name);
        }
        return url;
    }

    public String tabScriptString() {
        if (this.d2wContext().valueForKey("firstResponderKey") != null) {
            return this.scriptForFirstResponderActivation();
        }
        String result = "";
        String formName = ERXWOForm.formName((WOContext)this.context(), (String)"EditForm");
        if (formName != null) {
            int pos = this.tabSectionsContents().count() - 1;
            result = "var pos=0;\n if (document." + formName + ".elements.length>" + pos + ") pos=" + pos + ";\n var elem = document." + formName + ".elements[" + pos + "];\n if (elem!=null && (elem.type == 'text' || elem.type ==  'area')) elem.focus();";
        }
        return result;
    }

    private boolean d2wContextValueForKey(String key, boolean defaultValue) {
        return ERXValueUtilities.booleanValueWithDefault((Object)this.d2wContext().valueForKey(key), (boolean)defaultValue);
    }

    public boolean shouldNotSwitchIfHasChanges() {
        return this.d2wContextValueForKey("shouldNotSwitchIfHasChanges", false);
    }

    public boolean shouldSaveChangesForTab() {
        return this.d2wContextValueForKey("shouldSaveChangesForTab", false);
    }

    public boolean shouldShowNextPreviousButtons() {
        return this.d2wContextValueForKey("shouldShowNextPreviousButtons", true);
    }

    public boolean shouldShowPreviousButton() {
        return this.d2wContextValueForKey("shouldShowPreviousButton", !this.currentTabIsFirstTab());
    }

    public boolean shouldShowNextButton() {
        return this.d2wContextValueForKey("shouldShowNextButton", !this.currentTabIsLastTab());
    }

    public boolean useSubmitImages() {
        return this.d2wContextValueForKey("useSubmitImages", false);
    }

    public boolean useTabImages() {
        return this.d2wContextValueForKey("useTabImages", false);
    }

    public boolean useTabSectionImages() {
        return this.d2wContextValueForKey("useTabSectionImages", false);
    }

    public WOComponent nextTab() {
        return this.nextTabAction();
    }

    public WOComponent previousTab() {
        return this.previousTabAction();
    }

    public WOComponent nextTabAction() {
        if (this.switchTabAction()) {
            int currentIndex = this.tabSectionsContents().indexOfObject((Object)this.currentTab());
            if (this.tabSectionsContents().count() >= currentIndex + 2 && currentIndex >= 0) {
                NSNotificationCenter.defaultCenter().postNotification(WILL_SWITCH_TAB, (Object)this);
                this.setCurrentTab((ERD2WContainer)this.tabSectionsContents().objectAtIndex(currentIndex + 1));
            } else {
                log.warn((Object)("Attempting to move to next tab when current index is: " + currentIndex + " and tab count: " + this.tabSectionsContents().count()));
            }
        }
        return null;
    }

    public WOComponent previousTabAction() {
        if (this.switchTabAction()) {
            int currentIndex = this.tabSectionsContents().indexOfObject((Object)this.currentTab());
            if (this.tabSectionsContents().count() >= currentIndex && currentIndex > 0) {
                this.setCurrentTab((ERD2WContainer)this.tabSectionsContents().objectAtIndex(currentIndex - 1));
            } else {
                log.warn((Object)("Attempting to move to previous tab when current index is: " + currentIndex + " and tab count: " + this.tabSectionsContents().count()));
            }
        }
        return null;
    }

    public boolean currentTabIsFirstTab() {
        return this.tabSectionsContents() != null && this.tabSectionsContents().count() > 0 && this.currentTab() != null ? ((ERD2WContainer)this.tabSectionsContents().objectAtIndex(0)).equals(this.currentTab()) : false;
    }

    public boolean currentTabIsLastTab() {
        return this.tabSectionsContents() != null && this.tabSectionsContents().count() > 0 && this.currentTab() != null ? ((ERD2WContainer)this.tabSectionsContents().lastObject()).equals(this.currentTab()) : false;
    }

    public String tabComponentName() {
        return (String)this.d2wContext().valueForKey("tabComponentName");
    }

    public boolean disablePrevious() {
        return this.currentTabIsFirstTab();
    }

    public boolean disableNext() {
        return this.currentTabIsLastTab();
    }

    public boolean disableCancel() {
        return !this.showCancel();
    }

    public boolean disableSave() {
        return false;
    }
}

