/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAccessFaultHandler;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EODatabaseDataSource;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOQualifierSQLGeneration;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOCooperatingObjectStore;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFaultHandler;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOObserverCenter;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSArrayUtilities;

public class EODatabaseChannel {
    protected EODatabaseContext _databaseContext;
    protected EOAdaptorChannel _adaptorChannel;
    protected EOEntity _currentEntity;
    protected EOEditingContext _currentEditCtx;
    protected long _currentEditCtxTimestamp;
    protected NSMutableArray _fetchProperties;
    protected NSMutableArray _fetchSpecifications;
    protected NSMutableArray _refreshedGIDs;
    protected boolean _isLocking;
    protected boolean _isRefreshingObjects;
    protected boolean _isFetchingSingleTableEntity;
    private final NSSelector _pathSelector = new NSSelector("path", null);

    public EODatabaseChannel(EODatabaseContext databaseContext) {
        EOAdaptorContext context = databaseContext.adaptorContext();
        this._adaptorChannel = context.createAdaptorChannel();
        if (this._adaptorChannel == null) {
            throw new IllegalStateException("EODatabaseChannel is unable to obtain new channel from " + context.getClass().getName() + " " + context);
        }
        this._databaseContext = databaseContext;
    }

    private void setEntity(EOEntity entity) {
        NSArray rels = entity.relationships();
        Class<?> dbContextClass = ((Object)((Object)this.databaseContext())).getClass();
        int iCount = rels.count();
        for (int i = 0; i < iCount; ++i) {
            EORelationship rel = (EORelationship)rels.objectAtIndex(i);
            EOModel destModel = rel.destinationEntity().model();
            if (rel.entity().model() == destModel) continue;
            NSSelector._safeInvokeSelector((NSSelector)EODatabaseDataSource._registeredDBContextSelector, dbContextClass, (Object[])new Object[]{destModel, this.currentEditingContext()});
        }
    }

    public void setCurrentEntity(EOEntity entity) {
        if (entity != this._currentEntity) {
            this._fetchProperties = null;
            this._currentEntity = entity;
            this.setEntity(entity);
        }
    }

    public void setCurrentEditingContext(EOEditingContext context) {
        this._currentEditCtx = context;
        if (this._currentEditCtx != null) {
            this._currentEditCtxTimestamp = context.fetchTimestamp();
            ((EOObjectStoreCoordinator)this._currentEditCtx.rootObjectStore()).addCooperatingObjectStore((EOCooperatingObjectStore)this.databaseContext());
        }
    }

    public void selectObjectsWithFetchSpecification(EOFetchSpecification fetchSpecification, EOEditingContext context) {
        EODatabase db = this._databaseContext.database();
        EOEntity entity = db.entityNamed(fetchSpecification.entityName());
        EOQualifier qual = fetchSpecification.qualifier();
        if (qual != null) {
            qual = EOQualifierSQLGeneration.Support._schemaBasedQualifierWithRootEntity(qual, entity);
        }
        if (qual != fetchSpecification.qualifier()) {
            fetchSpecification = (EOFetchSpecification)fetchSpecification.clone();
            fetchSpecification.setQualifier(qual);
        }
        this._selectWithFetchSpecificationEditingContext(fetchSpecification, context);
        db.setTimestampToNow();
    }

    public boolean isFetchInProgress() {
        return this._adaptorChannel.isFetchInProgress();
    }

    public Object fetchObject() {
        _EODatabaseChannelFetchResult result = this._fetchObject();
        if (result != null) {
            return result.initializeObject(this.currentEditingContext(), this.databaseContext());
        }
        return null;
    }

    _EODatabaseChannelFetchResult _fetchObject() {
        NSDictionary effectiveSnapshot;
        EOEnterpriseObject object2;
        EOKeyGlobalID gid;
        EOEntity entity;
        EODatabase database = this._databaseContext.database();
        NSDictionary newSnapshot = null;
        boolean observerNotificationDisabled = false;
        if (!this.isFetchInProgress()) {
            return null;
        }
        try {
            this._propertiesToFetch();
            NSMutableDictionary row = this._adaptorChannel.fetchRow();
            while (row == null) {
                if (this._fetchSpecifications != null) {
                    this._cancelInternalFetch();
                    this._selectWithFetchSpecificationEditingContext(null, this._currentEditCtx);
                    this._propertiesToFetch();
                    row = this._adaptorChannel.fetchRow();
                    continue;
                }
                this._isLocking = false;
                return null;
            }
            if (this._isFetchingSingleTableEntity) {
                entity = this._currentEntity._singleTableSubEntityForRow((NSDictionary)row);
                if (entity == null) {
                    throw new IllegalStateException("Unable to determine subentity of '" + this._currentEntity.name() + "' for row: " + row + ". Check that the attribute '" + this._currentEntity._singleTableSubEntityKey() + "' is marked as a class property in the EOModel and that the value satisfies some subentity's restricting qualifier.");
                }
            } else {
                entity = this._currentEntity;
            }
            if ((gid = entity._globalIDForRowIsFinal((NSDictionary)row, true)) == null) {
                throw new IllegalArgumentException("Cannot determine primary key for entity " + this._currentEntity.name() + " from row: " + row);
            }
            object2 = this._currentEditCtx.objectForGlobalID((EOGlobalID)gid);
            boolean databaseContextRespondsTo_shouldUpdateCurrentSnapshot = this._databaseContext._respondsTo_shouldUpdateCurrentSnapshot();
            NSDictionary snapshot = database.snapshotForGlobalID((EOGlobalID)gid, databaseContextRespondsTo_shouldUpdateCurrentSnapshot ? EODatabase.DistantPastTimeInterval : this._currentEditCtxTimestamp);
            if (snapshot != null) {
                if (databaseContextRespondsTo_shouldUpdateCurrentSnapshot && (newSnapshot = this._databaseContext._shouldUpdateCurrentSnapshot(snapshot, (NSDictionary)row, gid, this)) != null) {
                    if (newSnapshot != snapshot) {
                        snapshot = newSnapshot;
                        database.recordSnapshotForGlobalID(snapshot, (EOGlobalID)gid);
                    } else {
                        newSnapshot = null;
                    }
                } else if ((this._isLocking || this._isRefreshingObjects) && !this._databaseContext.isObjectLockedWithGlobalID((EOGlobalID)gid) && !snapshot.isEqualToDictionary((NSDictionary)row)) {
                    if (this._isLocking && !this._isRefreshingObjects) {
                        throw new IllegalStateException("fetchObject: attempt to lock object that has out of date snapshot: %@" + gid);
                    }
                    snapshot = newSnapshot = row;
                    database.recordSnapshotForGlobalID(snapshot, (EOGlobalID)gid);
                }
                effectiveSnapshot = snapshot;
            } else {
                NSDictionary oldSnap = database.snapshotForGlobalID((EOGlobalID)gid);
                database.recordSnapshotForGlobalID((NSDictionary)row, (EOGlobalID)gid);
                if (oldSnap != null && !oldSnap.isEqualToDictionary((NSDictionary)row)) {
                    newSnapshot = row;
                }
                effectiveSnapshot = row;
                oldSnap = null;
            }
            database.incrementSnapshotCountForGlobalID((EOGlobalID)gid);
            if (this._isLocking) {
                this._databaseContext.registerLockedObjectWithGlobalID((EOGlobalID)gid);
            }
            if (newSnapshot != null) {
                if (this._refreshedGIDs == null) {
                    this._refreshedGIDs = new NSMutableArray();
                }
                this._refreshedGIDs.addObject((Object)gid);
            }
            if (object2 != null && !EOFaultHandler.isFault((Object)object2)) {
                return this._recForFetch(object2, (EOGlobalID)gid, entity, effectiveSnapshot, false);
            }
            if (object2 == null && newSnapshot != null) {
                object2 = this._currentEditCtx.faultForGlobalID((EOGlobalID)gid, this._currentEditCtx);
                return this._recForFetch(object2, (EOGlobalID)gid, entity, effectiveSnapshot, false);
            }
            if (object2 == null) {
                object2 = entity.classDescriptionForInstances().createInstanceWithEditingContext(this._currentEditCtx, (EOGlobalID)gid);
                this._currentEditCtx.recordObject(object2, (EOGlobalID)gid);
            } else {
                EOAccessFaultHandler handler = (EOAccessFaultHandler)EOFaultHandler.handlerForFault((Object)object2);
                if (handler.globalID()._isFinal()) {
                    EOFaultHandler.clearFault((Object)object2);
                } else {
                    EOFaultHandler.clearFault((Object)object2);
                    entity.initObjectEditingContextGlobalID(object2, this._currentEditCtx, (EOGlobalID)gid);
                }
            }
            this._databaseContext._lastEntity = entity;
        }
        catch (Throwable e) {
            if (observerNotificationDisabled) {
                EOObserverCenter.enableObserverNotification();
            }
            this._isLocking = false;
            this.cancelFetch();
            Object object2 = null;
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        return this._recForFetch(object2, (EOGlobalID)gid, entity, effectiveSnapshot, true);
    }

    _EODatabaseChannelFetchResult _recForFetch(EOEnterpriseObject t, EOGlobalID g, EOEntity e, NSDictionary snap, boolean init) {
        if (t == null) {
            return null;
        }
        return new _EODatabaseChannelFetchResult(t, g, e, snap, init);
    }

    public void cancelFetch() {
        EODatabaseContext._EOAssertSafeMultiThreadedAccess(this._databaseContext);
        if (this._fetchSpecifications != null) {
            this._fetchSpecifications = null;
        }
        this._cancelInternalFetch();
        if (this._refreshedGIDs != null) {
            int i;
            EOEditingContext currentEC = this._currentEditCtx;
            NSMutableArray refreshedGIDs = this._refreshedGIDs;
            EODatabase database = this._databaseContext.database();
            int cnt = refreshedGIDs.count();
            this._refreshedGIDs = null;
            for (i = 0; i < cnt; ++i) {
                database.incrementSnapshotCountForGlobalID((EOGlobalID)((EOKeyGlobalID)refreshedGIDs.objectAtIndex(i)));
            }
            NSNotificationCenter.defaultCenter().postNotification("EOObjectsChangedInStoreNotification", (Object)this._databaseContext, new NSDictionary((Object)refreshedGIDs, (Object)"updated"));
            for (i = 0; i < cnt; ++i) {
                EOKeyGlobalID gid = (EOKeyGlobalID)refreshedGIDs.objectAtIndex(i);
                EOEnterpriseObject obj = currentEC.objectForGlobalID((EOGlobalID)gid);
                obj.willRead();
                database.decrementSnapshotCountForGlobalID((EOGlobalID)gid);
            }
        }
    }

    public EODatabaseContext databaseContext() {
        return this._databaseContext;
    }

    public EOAdaptorChannel adaptorChannel() {
        return this._adaptorChannel;
    }

    public boolean isRefreshingObjects() {
        return this._isRefreshingObjects;
    }

    public void setIsRefreshingObjects(boolean isRefreshingObjects) {
        this._isRefreshingObjects = isRefreshingObjects;
    }

    public boolean isLocking() {
        return this._isLocking;
    }

    public void setIsLocking(boolean isLocking) {
        this._isLocking = isLocking;
    }

    protected void _openChannel() {
        if (!this._adaptorChannel.isOpen()) {
            this._adaptorChannel.openChannel();
        }
    }

    protected void _closeChannel() {
        this._adaptorChannel.closeChannel();
    }

    protected void _cancelInternalFetch() {
        if (this._adaptorChannel.isFetchInProgress()) {
            this._adaptorChannel.cancelFetch();
        }
    }

    private EOEditingContext currentEditingContext() {
        return this._currentEditCtx;
    }

    protected void _setCurrentEntityAndRelationshipWithFetchSpecification(EOFetchSpecification fetchSpec) {
        EOEntity entity = this._databaseContext.database().entityNamed(fetchSpec.entityName());
        if (entity == null) {
            NSArray models = this._databaseContext.database().models();
            NSMutableArray modelPaths = _NSArrayUtilities.resultsOfPerformingSelector((NSArray)models, (NSSelector)this._pathSelector);
            throw new IllegalArgumentException("Fetch specification " + fetchSpec + " refers to entity " + fetchSpec.entityName() + " which is not contained in the models of the EODatabase for this channel " + this + ".  If the expected model is not in the list " + modelPaths + " then check the connection dictionaries of your models to make sure that they match exactly.");
        }
        this.setCurrentEntity(entity);
    }

    protected void _buildNodeListWithParent(NSMutableArray nodes, EOEntity parent) {
        NSArray subEntities;
        boolean isSingleTableEntity = parent._isSingleTableEntity();
        if (isSingleTableEntity || !parent.isAbstractEntity()) {
            nodes.addObject((Object)parent.name());
        }
        if (!isSingleTableEntity && (subEntities = parent.subEntities()) != NSArray.EmptyArray) {
            for (int i = subEntities.count() - 1; i >= 0; --i) {
                EODatabaseContext childContext;
                EOEntity subEntity = (EOEntity)subEntities.objectAtIndex(i);
                if (parent.model() != subEntity.model() && (childContext = (EODatabaseContext)((Object)NSSelector._safeInvokeSelector((NSSelector)EODatabaseDataSource._registeredDBContextSelector, ((Object)((Object)this.databaseContext())).getClass(), (Object[])new Object[]{subEntity.model(), this.currentEditingContext()}))) != this.databaseContext()) {
                    throw new IllegalArgumentException("_buildNodeListWithParent: cannot do a deep fetch on entity '" + subEntity.name() + "' with parent '" + parent.name() + "' because they are stored in different databases");
                }
                this._buildNodeListWithParent(nodes, subEntity);
            }
        }
    }

    protected void _selectWithFetchSpecificationEditingContext(EOFetchSpecification fetchSpec, EOEditingContext context) {
        EOStoredProcedure sp;
        NSDictionary hints;
        EOSQLExpression customQuery = null;
        this._isFetchingSingleTableEntity = false;
        if (this._fetchSpecifications != null) {
            fetchSpec = (EOFetchSpecification)this._fetchSpecifications.lastObject();
            this._fetchSpecifications.removeLastObject();
            this.setCurrentEntity(this._databaseContext.database().entityNamed(fetchSpec.entityName()));
            this._isFetchingSingleTableEntity = this._currentEntity._isSingleTableEntity();
            if (this._fetchSpecifications.count() == 0) {
                this._fetchSpecifications = null;
            }
        } else {
            if (fetchSpec == null) {
                throw new IllegalArgumentException("_selectWithFetchSpecificationEditingContext invoked with null fetchSpecification");
            }
            hints = fetchSpec.hints();
            Object custom = hints.objectForKey((Object)"EOCustomQueryExpressionHintKey");
            if (custom != null) {
                customQuery = custom instanceof String ? this._databaseContext.adaptorContext().adaptor().expressionFactory().expressionForString((String)custom) : (EOSQLExpression)custom;
            }
            this.setCurrentEditingContext(context);
            this._setCurrentEntityAndRelationshipWithFetchSpecification(fetchSpec);
            if (fetchSpec.isDeep() && customQuery == null) {
                this._isFetchingSingleTableEntity = this._currentEntity._isSingleTableEntity();
                if (!this._isFetchingSingleTableEntity && this._currentEntity.subEntities() != NSArray.EmptyArray) {
                    NSMutableArray nodes = new NSMutableArray();
                    this._buildNodeListWithParent(nodes, this._currentEntity);
                    int cnt = nodes.count();
                    this._fetchSpecifications = new NSMutableArray(cnt);
                    for (int i = 0; i < cnt; ++i) {
                        EOFetchSpecification newFetchSpec = (EOFetchSpecification)fetchSpec.clone();
                        newFetchSpec.setEntityName((String)nodes.objectAtIndex(i));
                        this._fetchSpecifications.addObject((Object)newFetchSpec);
                    }
                    this._selectWithFetchSpecificationEditingContext(null, context);
                    return;
                }
            }
        }
        NSArray attributes = this._propertiesToFetch();
        if (!this._databaseContext._performShouldSelectObjects(fetchSpec, this)) {
            return;
        }
        this._isLocking = this._databaseContext._usesPessimisticLocking(fetchSpec, this);
        this._isRefreshingObjects = fetchSpec.refreshesRefetchedObjects();
        if (this._isLocking && !this._adaptorChannel.adaptorContext().hasOpenTransaction()) {
            this._adaptorChannel.adaptorContext().beginTransaction();
        }
        if (this._currentEntity.primaryKeyAttributes().count() == 0) {
            throw new IllegalStateException("_selectWithFetchSpecificationEditingContext: attempt to select EOs from entity '" + this._currentEntity.name() + "' which has no primary key defined. All entities must have a primary key specified. You should run the EOModeler consistency checker on the model containing this entity and perform whatever actions are necessary to ensure that the model is in a consistent state.");
        }
        hints = fetchSpec.hints();
        if (hints.count() > 0) {
            EOModel model = this._currentEntity.model();
            EOModelGroup group = model.modelGroup();
            String spName = (String)hints.objectForKey((Object)"EOStoredProcedureNameHintKey");
            sp = spName == null ? null : (group == null ? model.storedProcedureNamed(spName) : group.storedProcedureNamed(spName));
        } else {
            sp = null;
        }
        EOQualifier qual = fetchSpec.qualifier();
        if (sp != null) {
            this._adaptorChannel.executeStoredProcedure(sp, null);
            this._adaptorChannel.setAttributesToFetch(attributes);
        } else if (customQuery != null) {
            this._adaptorChannel.evaluateExpression(customQuery);
            this._adaptorChannel.setAttributesToFetch(attributes);
        } else if ((qual == null || qual._isEmpty()) && (sp = this._currentEntity.storedProcedureForOperation("EOFetchAllProcedure")) != null) {
            this._adaptorChannel.executeStoredProcedure(sp, null);
            this._adaptorChannel.setAttributesToFetch(attributes);
        } else {
            sp = this._currentEntity.storedProcedureForOperation("EOFetchWithPrimaryKeyProcedure");
            if (qual != null && sp != null && this._currentEntity.isQualifierForPrimaryKey(qual)) {
                NSMutableDictionary spArgs;
                if (qual instanceof EOKeyValueQualifier) {
                    spArgs = new NSMutableDictionary(((EOKeyValueQualifier)qual).value(), (Object)((EOKeyValueQualifier)qual).key());
                } else {
                    NSArray qualifiers = ((EOAndQualifier)qual).qualifiers();
                    int icount = qualifiers.count();
                    spArgs = new NSMutableDictionary(icount);
                    for (int i = 0; i < icount; ++i) {
                        EOKeyValueQualifier qualifierComponent = (EOKeyValueQualifier)qualifiers.objectAtIndex(i);
                        spArgs.setObjectForKey(qualifierComponent.value(), (Object)qualifierComponent.key());
                    }
                }
                this._adaptorChannel.executeStoredProcedure(sp, (NSDictionary)spArgs);
                this._adaptorChannel.setAttributesToFetch(attributes);
            } else {
                this._adaptorChannel.selectAttributes(attributes, fetchSpec, this._isLocking, this._currentEntity);
            }
        }
        this._databaseContext._performDidSelectObjects(fetchSpec, this);
    }

    public NSArray _propertiesToFetch() {
        if (this._currentEntity == null) {
            return this._adaptorChannel.describeResults();
        }
        return this._currentEntity._attributesToFetch();
    }

    static class _EODatabaseChannelFetchResult {
        public EOEnterpriseObject _object;
        public EOGlobalID _globalID;
        public EOEntity _entity;
        public NSDictionary _effectiveSnapshot;
        public boolean _requiresECInit;

        public _EODatabaseChannelFetchResult(EOEnterpriseObject t, EOGlobalID g, EOEntity e, NSDictionary snap, boolean init) {
            this._object = t;
            this._globalID = g;
            this._entity = e;
            this._effectiveSnapshot = snap;
            this._requiresECInit = init;
        }

        public static NSArray initializeObjects(NSArray objects, EOEditingContext ec, EODatabaseContext dc) {
            int c = objects.count();
            EOObserverCenter.suppressObserverNotification();
            boolean observerNotificationDisabled = true;
            NSMutableArray resultantObjects = new NSMutableArray(c);
            EOEnterpriseObject[] objectToAwaken = new EOEnterpriseObject[c];
            boolean awakenSome = false;
            try {
                int i;
                for (i = 0; i < c; ++i) {
                    _EODatabaseChannelFetchResult rec = (_EODatabaseChannelFetchResult)objects.objectAtIndex(i);
                    EOEnterpriseObject eo = rec._object;
                    resultantObjects.addObject((Object)eo);
                    EOGlobalID gid = rec._globalID;
                    if (rec._requiresECInit) {
                        awakenSome = true;
                        objectToAwaken[i] = eo;
                        dc._lastEntity = rec._entity;
                        dc._currentGlobalID = gid;
                        dc._currentSnapshot = rec._effectiveSnapshot;
                        ec.initializeObject(eo, gid, ec);
                    }
                    dc.database().decrementSnapshotCountForGlobalID(gid);
                }
                dc._currentGlobalID = null;
                dc._currentSnapshot = null;
                EOObserverCenter.enableObserverNotification();
                observerNotificationDisabled = false;
                if (awakenSome) {
                    for (i = 0; i < c; ++i) {
                        EOEnterpriseObject eo = objectToAwaken[i];
                        if (eo == null) continue;
                        eo.awakeFromFetch(ec);
                    }
                }
            }
            catch (Throwable t) {
                if (observerNotificationDisabled) {
                    EOObserverCenter.enableObserverNotification();
                }
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)t);
            }
            return resultantObjects;
        }

        public EOEnterpriseObject initializeObject(EOEditingContext ec, EODatabaseContext dc) {
            if (!this._requiresECInit) {
                dc.database().decrementSnapshotCountForGlobalID(this._globalID);
                return this._object;
            }
            EOObserverCenter.suppressObserverNotification();
            boolean observerNotificationDisabled = true;
            try {
                dc._lastEntity = this._entity;
                dc._currentGlobalID = this._globalID;
                dc._currentSnapshot = this._effectiveSnapshot;
                ec.initializeObject(this._object, this._globalID, ec);
                dc._currentGlobalID = null;
                dc._currentSnapshot = null;
                dc.database().decrementSnapshotCountForGlobalID(this._globalID);
                EOObserverCenter.enableObserverNotification();
                observerNotificationDisabled = false;
                this._object.awakeFromFetch(ec);
            }
            catch (Throwable t) {
                if (observerNotificationDisabled) {
                    EOObserverCenter.enableObserverNotification();
                }
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)t);
            }
            return this._object;
        }
    }
}

