/*
 * Decompiled with CFR 0.152.
 */
package er.excel;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNumberFormatter;
import er.extensions.formatters.ERXNumberFormatter;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXKeyValueCodingUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EGSimpleTableParser {
    protected final Logger log = Logger.getLogger(EGSimpleTableParser.class);
    private InputStream _contentStream;
    private HSSFWorkbook _workbook;
    private NSMutableDictionary _styles = new NSMutableDictionary();
    private NSMutableDictionary _fonts = new NSMutableDictionary();
    private NSMutableDictionary _styleDicts;
    private NSMutableDictionary _fontDicts;
    private static final NSArray STYLE_KEYS = new NSArray(new Object[]{"font", "hidden", "locked", "wrapText", "leftBorderColor", "rightBorderColor", "topBorderColor", "bottomBorderColor", "borderLeft", "borderRight", "borderTop", "borderBottom", "fillForegroundColor", "fillBackgroundColor", "fillPattern", "rotation", "indention", "wrapText", "alignment", "verticalAlignment", "format"});

    public EGSimpleTableParser(InputStream contentStream) {
        this(contentStream, null, null);
    }

    public EGSimpleTableParser(InputStream contentStream, NSDictionary fontDicts, NSDictionary styleDicts) {
        this._contentStream = contentStream;
        this._fontDicts = new NSMutableDictionary();
        if (this._fontDicts != null) {
            this._fontDicts.addEntriesFromDictionary(fontDicts);
        }
        this._styleDicts = new NSMutableDictionary();
        if (styleDicts != null) {
            this._styleDicts.addEntriesFromDictionary(styleDicts);
        }
    }

    public void writeToStream(OutputStream out) throws IOException {
        this.workbook().write(out);
        out.close();
    }

    public NSData data() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.workbook().write((OutputStream)out);
            out.close();
            return new NSData(out.toByteArray());
        }
        catch (IOException e) {
            this.log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public HSSFWorkbook workbook() {
        if (this._workbook == null) {
            this.parse();
        }
        return this._workbook;
    }

    private String nodeValueForKey(Node node, String key, String defaultValue) {
        NamedNodeMap attributes = node.getAttributes();
        String result = defaultValue;
        if (attributes.getNamedItem(key) != null && ((result = attributes.getNamedItem(key).getNodeValue()) == null || result.length() == 0)) {
            result = defaultValue;
        }
        return result;
    }

    private String keyPathToAttributeString(String aString) {
        int cnt = aString.length();
        StringBuffer result = new StringBuffer(cnt * 2);
        for (int i = 0; i < cnt; ++i) {
            char c = aString.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append('-');
                result.append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private String attributeStringToKeyPath(String aString) {
        int cnt = aString.length();
        boolean upperNext = false;
        StringBuffer result = new StringBuffer(cnt * 2);
        for (int i = 0; i < cnt; ++i) {
            char c = aString.charAt(i);
            if (upperNext) {
                if (Character.isLowerCase(c)) {
                    c = Character.toUpperCase(c);
                }
                result.append(c);
                upperNext = false;
                continue;
            }
            if (c == '-') {
                upperNext = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private void addEntriesFromNode(NSMutableDictionary dictionary, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            String key = this.attributeStringToKeyPath(n.getNodeName());
            String value = n.getNodeValue();
            if ("".equals(value)) {
                dictionary.removeObjectForKey((Object)key);
                continue;
            }
            dictionary.setObjectForKey((Object)value, (Object)key);
        }
    }

    private String dictValueForKey(NSDictionary dict, String key, String defaultValue) {
        String result = (String)dict.objectForKey((Object)key);
        if (result == null) {
            result = (String)dict.objectForKey((Object)this.keyPathToAttributeString(key));
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private void takeBooleanValueForKey(NSDictionary dict, String key, Object target, String defaultValue) {
        String value = this.dictValueForKey(dict, key, defaultValue);
        if (value != null) {
            NSKeyValueCoding.Utility.takeValueForKey((Object)target, (Object)Boolean.valueOf(value), (String)key);
        }
    }

    private void takeNumberValueForKey(NSDictionary dict, String key, Object target, String defaultValue) {
        String value = this.dictValueForKey(dict, key, defaultValue);
        if (value != null) {
            NSKeyValueCoding.Utility.takeValueForKey((Object)target, (Object)Integer.valueOf(value), (String)key);
        }
    }

    private void takeClassValueForKey(NSDictionary dict, String key, Object target, String defaultValue) {
        String value = this.dictValueForKey(dict, key, defaultValue);
        if (value != null) {
            Number number = (Number)ERXKeyValueCodingUtilities.classValueForKey(target.getClass(), (String)value);
            NSKeyValueCoding.Utility.takeValueForKey((Object)target, (Object)number, (String)key);
        }
    }

    private void takeClassValueForKey(NSDictionary dict, String key, Object target, Class source, String defaultValue) {
        String value = this.dictValueForKey(dict, key, defaultValue);
        if (value != null) {
            Number number = (Number)ERXKeyValueCodingUtilities.classValueForKey((Class)source, (String)value);
            NSKeyValueCoding.Utility.takeValueForKey((Object)target, (Object)number, (String)key);
        }
    }

    private void parse() {
        try {
            Document document = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            InputStream stream = this._contentStream;
            document = builder.parse(stream);
            this._workbook = new HSSFWorkbook();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)document.getDocumentElement());
            }
            NodeList nodes = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                this.parseNode(node);
            }
        }
        catch (Exception ex) {
            throw new NSForwardException((Throwable)ex);
        }
    }

    private void parseNode(Node node) {
        String tagName = node.getLocalName().toLowerCase();
        if ("font".equals(tagName)) {
            this.parseFont(node);
        } else if ("style".equals(tagName)) {
            this.parseStyle(node);
        } else if ("table".equals(tagName)) {
            this.parseTable(node);
        } else {
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node child = nodes.item(i);
                if (child.getNodeType() != 1) continue;
                this.parseNode(child);
            }
        }
    }

    private void parseStyle(Node node) {
        String id = this.nodeValueForKey(node, "id", null);
        if (id != null) {
            NSMutableDictionary dict = new NSMutableDictionary();
            String extendsID = this.nodeValueForKey(node, "extends", null);
            if (extendsID != null) {
                NSDictionary otherDict = (NSDictionary)this._styleDicts.objectForKey((Object)extendsID);
                if (otherDict == null) {
                    throw new NullPointerException("Extends Style Id not found");
                }
                dict.addEntriesFromDictionary(otherDict);
            }
            this.addEntriesFromNode(dict, node);
            this._styleDicts.setObjectForKey((Object)dict, (Object)id);
        }
    }

    private void parseFont(Node node) {
        String id = this.nodeValueForKey(node, "id", null);
        if (id != null) {
            NSMutableDictionary dict = new NSMutableDictionary();
            String extendsID = this.nodeValueForKey(node, "extends", null);
            if (extendsID != null) {
                NSDictionary otherDict = (NSDictionary)this._fonts.objectForKey((Object)extendsID);
                if (otherDict == null) {
                    throw new NullPointerException("Extends Font Id not found");
                }
                dict.addEntriesFromDictionary(otherDict);
            }
            this.addEntriesFromNode(dict, node);
            this._fontDicts.setObjectForKey((Object)dict, (Object)id);
        }
    }

    private void parseTable(Node tableNode) {
        String sheetName = this.nodeValueForKey(tableNode, "name", "Unnamed Sheet " + (this._workbook.getNumberOfSheets() + 1));
        NSMutableDictionary sheetDict = new NSMutableDictionary();
        this.addEntriesFromNode(sheetDict, tableNode);
        if (sheetName.matches("[\\/\\\\\\*\\?\\[\\]]")) {
            sheetName = sheetName.replaceAll("[\\/\\\\\\*\\?\\[\\]]", "-");
            this.log.warn((Object)("Illegal characters in sheet name (/\\*?[]): " + sheetName));
        }
        if (sheetName.length() > 31) {
            sheetName = sheetName.substring(0, 31);
            this.log.warn((Object)("Sheet name too long (max 31 Characters): " + sheetName));
        }
        HSSFSheet sheet = this._workbook.createSheet(sheetName);
        NodeList rowNodes = tableNode.getChildNodes();
        this.takeNumberValueForKey((NSDictionary)sheetDict, "defaultColumnWidth", sheet, null);
        this.takeNumberValueForKey((NSDictionary)sheetDict, "defaultRowHeight", sheet, null);
        this.takeNumberValueForKey((NSDictionary)sheetDict, "defaultRowHeightInPoints", sheet, null);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sheet: " + this._workbook.getNumberOfSheets()));
        }
        int rowNum = 0;
        for (int j = 0; j < rowNodes.getLength(); ++j) {
            Node rowNode = rowNodes.item(j);
            if (rowNode.getNodeType() != 1 || !"tr".equals(rowNode.getLocalName().toLowerCase())) continue;
            NSMutableDictionary rowDict = new NSMutableDictionary((NSDictionary)sheetDict);
            this.addEntriesFromNode(rowDict, rowNode);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Row: " + rowNum));
            }
            HSSFRow row = sheet.createRow(rowNum);
            ++rowNum;
            NodeList cellNodes = rowNode.getChildNodes();
            for (int k = 0; k < cellNodes.getLength(); ++k) {
                HSSFCellStyle style;
                String cellHeightString;
                Node cellNode = cellNodes.item(k);
                if (cellNode.getNodeType() != 1 || !"td".equals(cellNode.getLocalName().toLowerCase()) && !"th".equals(cellNode.getLocalName().toLowerCase())) continue;
                int currentColumnNumber = row.getPhysicalNumberOfCells();
                HSSFCell cell = row.createCell(currentColumnNumber);
                String value = null;
                if (cellNode.getFirstChild() != null) {
                    value = cellNode.getFirstChild().getNodeValue();
                }
                NSMutableDictionary cellDict = new NSMutableDictionary((NSDictionary)rowDict);
                this.addEntriesFromNode(cellDict, cellNode);
                String cellTypeName = this.dictValueForKey((NSDictionary)cellDict, "cellType", "CELL_TYPE_NUMERIC");
                String cellFormatName = this.dictValueForKey((NSDictionary)cellDict, "cellFormat", "0.00;-;-0.00");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(value + ": " + cellFormatName + "-" + cellTypeName));
                }
                Integer cellType = (Integer)ERXKeyValueCodingUtilities.classValueForKey(Cell.class, (String)cellTypeName);
                switch (cellType) {
                    case 2: {
                        cell.setCellType(2);
                        cell.setCellFormula(value != null ? value.toString() : null);
                        break;
                    }
                    case 0: {
                        try {
                            if (value == null) break;
                            NSNumberFormatter f = ERXNumberFormatter.numberFormatterForPattern((String)cellFormatName);
                            Number numberValue = (Number)f.parseObject(value.toString());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)(f.pattern() + ": " + numberValue));
                            }
                            if (numberValue == null) break;
                            cell.setCellValue(numberValue.doubleValue());
                            break;
                        }
                        catch (ParseException e1) {
                            this.log.info((Object)e1);
                        }
                    }
                    default: {
                        cell.setCellType(cellType.intValue());
                        cell.setCellValue((RichTextString)new HSSFRichTextString(value != null ? value.toString() : null));
                    }
                }
                String cellWidthString = this.nodeValueForKey(cellNode, "width", null);
                if (cellWidthString != null && cellWidthString.indexOf("%") < 0) {
                    if ("auto".equalsIgnoreCase(cellWidthString)) {
                        try {
                            sheet.autoSizeColumn((int)((short)currentColumnNumber));
                        }
                        catch (Exception ex) {
                            this.log.warn((Object)ex);
                        }
                    } else {
                        try {
                            short width = Integer.valueOf(cellWidthString).shortValue();
                            sheet.setColumnWidth(currentColumnNumber, width * 256);
                        }
                        catch (Exception ex) {
                            this.log.warn((Object)ex);
                        }
                    }
                }
                if ((cellHeightString = this.nodeValueForKey(cellNode, "height", null)) != null && cellHeightString.indexOf("%") < 0) {
                    try {
                        short height = Integer.valueOf(cellHeightString).shortValue();
                        row.setHeightInPoints((float)height);
                    }
                    catch (Exception ex) {
                        this.log.warn((Object)ex);
                    }
                }
                if ((style = this.styleWithDictionary((NSDictionary)cellDict)) != null) {
                    cell.setCellStyle(style);
                }
                String colspanString = this.dictValueForKey((NSDictionary)cellDict, "colspan", "1");
                int colspan = Integer.valueOf(colspanString).shortValue();
                for (int col = 1; col < colspan; ++col) {
                    int nextColumnNumber = row.getPhysicalNumberOfCells();
                    cell = row.createCell(nextColumnNumber);
                    if (style == null) continue;
                    cell.setCellStyle(style);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Cell: " + value));
            }
        }
    }

    private HSSFFont fontWithID(String id) {
        HSSFFont font = (HSSFFont)this._fonts.objectForKey((Object)id);
        if (font == null) {
            font = this._workbook.createFont();
            NSDictionary dict = (NSDictionary)this._fontDicts.objectForKey((Object)id);
            String value = this.dictValueForKey(dict, "name", null);
            if (value != null) {
                font.setFontName(value);
            }
            this.takeNumberValueForKey(dict, "fontHeight", font, null);
            this.takeNumberValueForKey(dict, "fontHeightInPoints", font, null);
            this.takeNumberValueForKey(dict, "color", font, null);
            this.takeBooleanValueForKey(dict, "italic", font, null);
            this.takeBooleanValueForKey(dict, "strikeout", font, null);
            this.takeClassValueForKey(dict, "underline", font, Font.class, null);
            this.takeClassValueForKey(dict, "typeOffset", font, Font.class, null);
            this.takeClassValueForKey(dict, "boldweight", font, Font.class, null);
            this._fonts.setObjectForKey((Object)font, (Object)id);
        }
        return font;
    }

    private HSSFCellStyle styleWithDictionary(NSDictionary dict) {
        HSSFCellStyle cellStyle;
        String cellClass = this.dictValueForKey(dict, "class", null);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("before - " + cellClass + ": " + dict));
        }
        dict = ERXDictionaryUtilities.dictionaryFromObjectWithKeys((Object)dict, (NSArray)STYLE_KEYS);
        if (cellClass != null) {
            String[] styles = cellClass.split(" +");
            NSMutableDictionary stylesFromClass = new NSMutableDictionary();
            for (String string : styles) {
                NSDictionary current = (NSDictionary)this._styleDicts.objectForKey((Object)string);
                if (current == null) {
                    throw new IllegalArgumentException("Cell Style not found: " + cellClass);
                }
                stylesFromClass.addEntriesFromDictionary(current);
            }
            stylesFromClass = ERXDictionaryUtilities.dictionaryFromObjectWithKeys((Object)stylesFromClass, (NSArray)STYLE_KEYS).mutableClone();
            stylesFromClass.addEntriesFromDictionary(dict);
            dict = stylesFromClass.immutableClone();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("after - " + cellClass + ": " + dict));
        }
        if ((cellStyle = (HSSFCellStyle)this._styles.objectForKey((Object)dict)) == null) {
            cellStyle = this._workbook.createCellStyle();
            String fontID = this.dictValueForKey(dict, "font", null);
            if (fontID != null) {
                HSSFFont font = this.fontWithID(fontID);
                if (font == null) {
                    throw new IllegalArgumentException("Font ID not found!");
                }
                cellStyle.setFont(font);
            }
            this.takeBooleanValueForKey(dict, "hidden", cellStyle, null);
            this.takeBooleanValueForKey(dict, "locked", cellStyle, null);
            this.takeBooleanValueForKey(dict, "wrapText", cellStyle, null);
            this.takeNumberValueForKey(dict, "leftBorderColor", cellStyle, null);
            this.takeNumberValueForKey(dict, "rightBorderColor", cellStyle, null);
            this.takeNumberValueForKey(dict, "topBorderColor", cellStyle, null);
            this.takeNumberValueForKey(dict, "bottomBorderColor", cellStyle, null);
            this.takeNumberValueForKey(dict, "fillBackgroundColor", cellStyle, null);
            this.takeNumberValueForKey(dict, "fillForegroundColor", cellStyle, null);
            this.takeNumberValueForKey(dict, "indention", cellStyle, null);
            this.takeNumberValueForKey(dict, "rotation", cellStyle, null);
            this.takeClassValueForKey(dict, "borderLeft", cellStyle, CellStyle.class, null);
            this.takeClassValueForKey(dict, "borderRight", cellStyle, CellStyle.class, null);
            this.takeClassValueForKey(dict, "borderTop", cellStyle, CellStyle.class, null);
            this.takeClassValueForKey(dict, "borderBottom", cellStyle, CellStyle.class, null);
            this.takeClassValueForKey(dict, "fillPattern", cellStyle, CellStyle.class, null);
            this.takeClassValueForKey(dict, "alignment", cellStyle, CellStyle.class, null);
            this.takeClassValueForKey(dict, "verticalAlignment", cellStyle, CellStyle.class, null);
            String formatString = this.dictValueForKey(dict, "format", null);
            if (formatString != null) {
                HSSFDataFormat format = this._workbook.createDataFormat();
                short formatId = format.getFormat(formatString);
                cellStyle.setDataFormat(formatId);
            }
            this._styles.setObjectForKey((Object)cellStyle, (Object)dict);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Created style (" + cellClass + "): " + dict));
            }
        }
        return cellStyle;
    }
}

