/*
 * Decompiled with CFR 0.152.
 */
package er.movies;

import com.webobjects.foundation.NSTimestamp;
import er.chronic.Chronic;
import er.chronic.Options;
import er.chronic.utils.Span;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChronicFormatter
extends SimpleDateFormat {
    private Options options;
    private boolean isGuessingEarly = true;

    public ChronicFormatter(String pattern) {
        this(pattern, null, true);
    }

    public ChronicFormatter(String pattern, Options options) {
        this(pattern, options, true);
    }

    public ChronicFormatter(String pattern, Options options, boolean isGuessingEarly) {
        super(pattern);
        this.options = options;
        this.isGuessingEarly = isGuessingEarly;
    }

    public Options options() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public boolean isGuessingEarly() {
        return this.isGuessingEarly;
    }

    public void setIsGuessingEarly(boolean isGuessingEarly) {
        this.isGuessingEarly = isGuessingEarly;
    }

    public NSTimestamp parseObject(String text) throws ParseException {
        NSTimestamp parsedTimestamp = null;
        try {
            Date parsedDate = super.parse(text);
            parsedTimestamp = new NSTimestamp(parsedDate);
        }
        catch (ParseException e) {
            Span span = Chronic.parse((String)text, (Options)this.options());
            if (span == null) {
                throw e;
            }
            parsedTimestamp = span.isSingularity() || this.isGuessingEarly() ? new NSTimestamp(span.getBeginCalendar().getTime()) : new NSTimestamp(span.getEndCalendar().getTime());
        }
        return parsedTimestamp;
    }
}

