/*
 * Decompiled with CFR 0.152.
 */
package er.imadaptor;

import er.extensions.concurrency.ERXAsyncQueue;
import er.imadaptor.Conversation;
import er.imadaptor.IInstantMessenger;
import er.imadaptor.IInstantMessengerFactory;
import er.imadaptor.IMessageListener;
import er.imadaptor.InstantMessengerAdaptor;
import er.imadaptor.InstantMessengerWatchDog;
import er.imadaptor.MessageException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantMessengerConnection {
    private InstantMessageQueue _messageQueue;
    private IInstantMessenger _instantMessenger;
    private InstantMessengerWatchDog _watchDog;
    private Map<String, Conversation> _conversations = new HashMap<String, Conversation>();

    protected InstantMessengerConnection() {
        this._messageQueue = new InstantMessageQueue();
        this._messageQueue.start();
    }

    public InstantMessengerConnection(String screenName, String password, IInstantMessengerFactory factory) {
        this();
        this._instantMessenger = factory.createInstantMessenger(screenName, password);
    }

    public InstantMessengerConnection(IInstantMessenger instantMessenger) {
        this();
        this._instantMessenger = instantMessenger;
    }

    public void setWatchDog(String screenName, String password, IInstantMessengerFactory watchdogFactory) {
        if (this._watchDog != null) {
            this._watchDog.stop();
        }
        IInstantMessenger watchdogInstantMessenger = watchdogFactory.createInstantMessenger(screenName, password);
        this.setWatchDog(watchdogInstantMessenger);
    }

    public void setWatchDog(IInstantMessenger instantMessenger) {
        if (this._watchDog != null) {
            this._watchDog.stop();
        }
        this._watchDog = new InstantMessengerWatchDog(this._instantMessenger, instantMessenger);
    }

    public IInstantMessenger instantMessenger() {
        return this._instantMessenger;
    }

    public InstantMessengerWatchDog watchDog() {
        return this._watchDog;
    }

    public List<Conversation> conversations() {
        LinkedList<Conversation> conversations = new LinkedList<Conversation>(this._conversations.values());
        return conversations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation conversationForBuddyNamed(String buddyName, long conversationTimeout) {
        Conversation conversation;
        Map<String, Conversation> map = this._conversations;
        synchronized (map) {
            conversation = this._conversations.get(buddyName);
            System.out.println("InstantMessengerConnection.conversationForBuddyNamed: conversation = " + conversation);
            if (conversation == null || conversation.isExpired(conversationTimeout)) {
                System.out.println("InstantMessengerConnection.conversationForBuddyNamed:   ... created a new one");
                conversation = new Conversation();
                conversation.setScreenName(this._instantMessenger.getScreenName());
                conversation.setBuddyName(buddyName);
                this._conversations.put(buddyName, conversation);
            } else {
                conversation.ping();
            }
        }
        return conversation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredConversations(long conversationTimeout) {
        Map<String, Conversation> map = this._conversations;
        synchronized (map) {
            Iterator<Map.Entry<String, Conversation>> conversationsIter = this._conversations.entrySet().iterator();
            while (conversationsIter.hasNext()) {
                Map.Entry<String, Conversation> entry = conversationsIter.next();
                Conversation conversation = entry.getValue();
                if (!conversation.isExpired(conversationTimeout)) continue;
                this.conversationExpired(conversation);
                conversationsIter.remove();
            }
        }
    }

    protected void conversationExpired(Conversation conversation) {
    }

    public void sendMessage(String buddyName, String message, boolean block) throws MessageException {
        if (block) {
            this._instantMessenger.sendMessage(buddyName, message, true);
        } else {
            this._messageQueue.enqueue(new Message(buddyName, message));
        }
    }

    public void connect(IMessageListener messageListener) {
        this._instantMessenger.addMessageListener(messageListener);
        try {
            this._instantMessenger.connect();
        }
        catch (Throwable e) {
            InstantMessengerAdaptor.log.debug((Object)"Failed to connect to provider.", e);
        }
        if (this._watchDog != null) {
            this._watchDog.start();
        }
    }

    public void disconnect() {
        if (this._instantMessenger != null) {
            this._instantMessenger.disconnect();
        }
        if (this._watchDog != null) {
            this._watchDog.stop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InstantMessageQueue
    extends ERXAsyncQueue<Message> {
        protected InstantMessageQueue() {
        }

        public void process(Message message) {
            try {
                IInstantMessenger instantMessenger = InstantMessengerConnection.this.instantMessenger();
                instantMessenger.sendMessage(message.buddyName(), message.contents(), true);
            }
            catch (MessageException e) {
                InstantMessengerAdaptor.log.error((Object)e);
            }
        }
    }

    protected static class Message {
        private String _contents;
        private String _buddyName;

        public Message(String buddyName, String contents) {
            this._buddyName = buddyName;
            this._contents = contents;
        }

        public String contents() {
            return this._contents;
        }

        public String buddyName() {
            return this._buddyName;
        }
    }
}

