/*
 * Decompiled with CFR 0.152.
 */
package er.imadaptor.components;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.foundation.ERXStringUtilities;
import er.imadaptor.InstantMessengerAdaptor;
import er.imadaptor.components.IMAction;
import java.util.Enumeration;

abstract class AbstractIMSearchAction
extends IMAction {
    private WOAssociation _value;
    private WOAssociation _values;
    private WOAssociation _quicksilver;
    private WOAssociation _optionsDictionary;
    private WOAssociation _optionsArray;
    private WOAssociation _optionKeyPath;

    public AbstractIMSearchAction(String name, NSDictionary associations, WOElement element) {
        super(name, associations, element);
        this._value = (WOAssociation)associations.objectForKey((Object)"value");
        this._values = (WOAssociation)associations.objectForKey((Object)"values");
        if (this._value == null && this._values == null) {
            throw new WODynamicElementCreationException("Only one of 'value' or 'values' can be bound at any time.");
        }
        this._quicksilver = (WOAssociation)associations.objectForKey((Object)"quicksilver");
        this._optionsDictionary = (WOAssociation)associations.objectForKey((Object)"optionsDictionary");
        this._optionsArray = (WOAssociation)associations.objectForKey((Object)"optionsArray");
        if (this._optionsArray == null && this._optionsDictionary == null) {
            throw new WODynamicElementCreationException("Only one of 'optionsArray' or 'optionsDictionary' can be bound at any time.");
        }
        if (this._optionsArray != null && this._optionsDictionary != null) {
            throw new WODynamicElementCreationException("Both 'optionsArray' and 'optionsDictionary' cannot be bound at the same time.");
        }
        this._optionKeyPath = (WOAssociation)associations.objectForKey((Object)"optionKeyPath");
        if (this._optionKeyPath != null && this._optionsDictionary != null) {
            throw new WODynamicElementCreationException("Both 'optionKeyPath' and 'optionsDictionary' cannot be bound at the same time.");
        }
    }

    protected abstract boolean searchInsideMessage();

    public static NSArray selectedValues(NSDictionary options, boolean quicksilver, String message, boolean searchInsideMessage) {
        NSMutableArray selectedValues = new NSMutableArray();
        String lowercaseMessage = message.toLowerCase();
        Enumeration keyEnum = options.keyEnumerator();
        while (keyEnum.hasMoreElements()) {
            String stringToSearchFor;
            String stringToSearch;
            String key = (String)keyEnum.nextElement();
            if (searchInsideMessage) {
                stringToSearch = lowercaseMessage;
                stringToSearchFor = key;
            } else {
                stringToSearch = key;
                stringToSearchFor = lowercaseMessage;
            }
            String selectedKey = null;
            if (quicksilver && ERXStringUtilities.quicksilverContains((String)stringToSearch, (String)stringToSearchFor)) {
                selectedKey = key;
            } else if (!quicksilver && stringToSearch.indexOf(stringToSearchFor) != -1) {
                selectedKey = key;
            }
            if (selectedKey == null) continue;
            Object selectedValue = options.objectForKey((Object)selectedKey);
            selectedValues.addObject(selectedValue);
        }
        return selectedValues;
    }

    public static NSArray selectedValues(NSArray options, String optionKeyPath, boolean quicksilver, String message, boolean searchInsideMessage) {
        NSMutableArray selectedValues = new NSMutableArray();
        String lowercaseMessage = message.toLowerCase();
        Enumeration optionEnum = options.objectEnumerator();
        while (optionEnum.hasMoreElements()) {
            String stringToSearchFor;
            String stringToSearch;
            Object optionKeyPathValue;
            Object option = optionEnum.nextElement();
            String optionStr = optionKeyPath == null ? option.toString() : ((optionKeyPathValue = NSKeyValueCodingAdditions.Utility.valueForKeyPath(option, (String)optionKeyPath)) == null ? "" : optionKeyPathValue.toString());
            if (searchInsideMessage) {
                stringToSearch = lowercaseMessage;
                stringToSearchFor = optionStr;
            } else {
                stringToSearch = optionStr;
                stringToSearchFor = lowercaseMessage;
            }
            if (quicksilver && ERXStringUtilities.quicksilverContains((String)stringToSearch, (String)stringToSearchFor)) {
                selectedValues.addObject(option);
                continue;
            }
            if (quicksilver || stringToSearch.indexOf(stringToSearchFor) == -1) continue;
            selectedValues.addObject(option);
        }
        return selectedValues;
    }

    protected void actionInvoked(WORequest request, WOContext context) {
        NSArray selectedValues;
        NSDictionary options;
        boolean quicksilver;
        WOComponent component = context.component();
        String message = InstantMessengerAdaptor.message(request);
        boolean bl = quicksilver = this._quicksilver != null && (Boolean)this._quicksilver.valueInComponent(component) != false;
        if (this._optionsDictionary != null) {
            options = (NSDictionary)this._optionsDictionary.valueInComponent(component);
            selectedValues = AbstractIMSearchAction.selectedValues(options, quicksilver, message, this.searchInsideMessage());
        } else if (this._optionsArray != null) {
            options = (NSArray)this._optionsArray.valueInComponent(component);
            String optionKeyPath = null;
            if (this._optionKeyPath != null) {
                optionKeyPath = (String)this._optionKeyPath.valueInComponent(component);
            }
            selectedValues = AbstractIMSearchAction.selectedValues((NSArray)options, optionKeyPath, quicksilver, message, this.searchInsideMessage());
        } else {
            throw new IllegalArgumentException("You must specify either optionsDictionary or optionsArray.");
        }
        if (this._values != null) {
            this._values.setValue((Object)selectedValues, component);
        }
        if (this._value != null) {
            Object selectedValue = null;
            if (selectedValues.count() == 1) {
                selectedValue = selectedValues.objectAtIndex(0);
            }
            this._value.setValue(selectedValue, component);
        }
    }
}

